/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableDataConsistencyCheckIgnoredType;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableInventoryCheckCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.MatchingTableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryCheckParameter;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.RecordTableInventoryCheckCalculator;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.StreamingRangeType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.TableInventoryCalculator;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.annotation.SPIDescription;

@SPIDescription(value="Match raw data of records.")
public final class DataMatchTableDataConsistencyChecker
implements TableDataConsistencyChecker {
    private static final String CHUNK_SIZE_KEY = "chunk-size";
    private static final String STREAMING_RANGE_TYPE_KEY = "streaming-range-type";
    private static final int DEFAULT_CHUNK_SIZE = 1000;
    private static final StreamingRangeType DEFAULT_STREAMING_RANGE_TYPE = StreamingRangeType.SMALL;
    private int chunkSize;
    private StreamingRangeType streamingRangeType;

    public void init(Properties props) {
        this.chunkSize = this.getChunkSize(props);
        this.streamingRangeType = this.getStreamingRangeType(props);
    }

    private int getChunkSize(Properties props) {
        int result;
        String chunkSizeText = props.getProperty(CHUNK_SIZE_KEY);
        if (Strings.isNullOrEmpty((String)chunkSizeText)) {
            return 1000;
        }
        try {
            result = Integer.parseInt(chunkSizeText);
        }
        catch (NumberFormatException ignore) {
            throw new PipelineInvalidParameterException("'chunk-size' is not a valid number: `" + chunkSizeText + "`");
        }
        if (result <= 0) {
            throw new PipelineInvalidParameterException("Invalid 'chunk-size' value: `" + result + "`, it should be a positive integer.");
        }
        return result;
    }

    private StreamingRangeType getStreamingRangeType(Properties props) {
        String streamingRangeTypeText = props.getProperty(STREAMING_RANGE_TYPE_KEY);
        if (Strings.isNullOrEmpty((String)streamingRangeTypeText)) {
            return DEFAULT_STREAMING_RANGE_TYPE;
        }
        try {
            return StreamingRangeType.valueOf(streamingRangeTypeText.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new PipelineInvalidParameterException("Invalid 'streaming-range-type' value: `" + streamingRangeTypeText + "`, expected values are " + Arrays.toString((Object[])StreamingRangeType.values()));
        }
    }

    @Override
    public TableInventoryChecker buildTableInventoryChecker(TableInventoryCheckParameter param) {
        return new DataMatchTableInventoryChecker(param, this.chunkSize, this.streamingRangeType);
    }

    public Collection<DatabaseType> getSupportedDatabaseTypes() {
        return ShardingSphereServiceLoader.getServiceInstances(DatabaseType.class);
    }

    @Override
    public void close() {
    }

    public String getType() {
        return "DATA_MATCH";
    }

    private static final class DataMatchTableInventoryChecker
    extends MatchingTableInventoryChecker {
        private final int chunkSize;
        private final StreamingRangeType streamingRangeType;

        DataMatchTableInventoryChecker(TableInventoryCheckParameter param, int chunkSize, StreamingRangeType streamingRangeType) {
            super(param);
            this.chunkSize = chunkSize;
            this.streamingRangeType = streamingRangeType;
        }

        @Override
        public Optional<TableDataConsistencyCheckResult> preCheck() {
            if (this.getParam().getUniqueKeys().isEmpty()) {
                return Optional.of(new TableDataConsistencyCheckResult(TableDataConsistencyCheckIgnoredType.NO_UNIQUE_KEY));
            }
            return Optional.empty();
        }

        @Override
        protected TableInventoryCalculator<TableInventoryCheckCalculatedResult> buildSingleTableInventoryCalculator() {
            return new RecordTableInventoryCheckCalculator(this.chunkSize, this.streamingRangeType);
        }
    }
}

