/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datasource;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDataSourceManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDataSourceManager.class);
    private final Map<PipelineDataSourceConfiguration, PipelineDataSource> cachedDataSources = new ConcurrentHashMap<PipelineDataSourceConfiguration, PipelineDataSource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineDataSource getDataSource(PipelineDataSourceConfiguration dataSourceConfig) {
        PipelineDataSource result = this.cachedDataSources.get(dataSourceConfig);
        if (null != result) {
            return result;
        }
        Map<PipelineDataSourceConfiguration, PipelineDataSource> map = this.cachedDataSources;
        synchronized (map) {
            result = this.cachedDataSources.get(dataSourceConfig);
            if (null != result) {
                if (!result.isClosed()) {
                    return result;
                }
                log.warn("{} is already closed, create again.", (Object)result);
            }
            result = new PipelineDataSource(dataSourceConfig);
            this.cachedDataSources.put(dataSourceConfig, result);
            return result;
        }
    }

    @Override
    public void close() {
        for (PipelineDataSource each : this.cachedDataSources.values()) {
            if (each.isClosed()) continue;
            each.close();
        }
        this.cachedDataSources.clear();
    }
}

