/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column.DialectInventoryColumnValueReader;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;

public final class InventoryColumnValueReaderEngine {
    private final DatabaseType databaseType;

    public Object read(ResultSet resultSet, ResultSetMetaData metaData, int columnIndex) throws SQLException {
        Optional<Object> dialectValue = this.readDialectValue(resultSet, metaData, columnIndex);
        Object result = dialectValue.isPresent() ? dialectValue.get() : this.readStandardValue(resultSet, metaData, columnIndex);
        return resultSet.wasNull() ? null : result;
    }

    private Optional<Object> readDialectValue(ResultSet resultSet, ResultSetMetaData metaData, int columnIndex) throws SQLException {
        Optional dialectColumnReader = DatabaseTypedSPILoader.findService(DialectInventoryColumnValueReader.class, (DatabaseType)this.databaseType);
        return dialectColumnReader.isPresent() ? ((DialectInventoryColumnValueReader)dialectColumnReader.get()).read(resultSet, metaData, columnIndex) : Optional.empty();
    }

    private Object readStandardValue(ResultSet resultSet, ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int columnType = metaData.getColumnType(columnIndex);
        switch (columnType) {
            case 16: {
                return resultSet.getBoolean(columnIndex);
            }
            case -6: {
                if (this.isSigned(metaData, columnIndex)) {
                    return resultSet.getByte(columnIndex);
                }
                return resultSet.getShort(columnIndex);
            }
            case 5: {
                if (this.isSigned(metaData, columnIndex)) {
                    return resultSet.getShort(columnIndex);
                }
                return resultSet.getInt(columnIndex);
            }
            case 4: {
                if (this.isSigned(metaData, columnIndex)) {
                    return resultSet.getInt(columnIndex);
                }
                return resultSet.getLong(columnIndex);
            }
            case -5: {
                if (this.isSigned(metaData, columnIndex)) {
                    return resultSet.getLong(columnIndex);
                }
                BigDecimal decimal = resultSet.getBigDecimal(columnIndex);
                return null == decimal ? null : decimal.toBigInteger();
            }
            case 2: 
            case 3: {
                return resultSet.getBigDecimal(columnIndex);
            }
            case 6: 
            case 7: {
                return Float.valueOf(resultSet.getFloat(columnIndex));
            }
            case 8: {
                return resultSet.getDouble(columnIndex);
            }
            case 92: {
                return resultSet.getTime(columnIndex);
            }
            case 91: {
                return resultSet.getDate(columnIndex);
            }
            case 93: {
                return resultSet.getTimestamp(columnIndex);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return resultSet.getString(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return resultSet.getBytes(columnIndex);
            }
            case 2004: {
                Blob blob = resultSet.getBlob(columnIndex);
                return null == blob ? null : blob.getBytes(1L, (int)blob.length());
            }
            case 2005: {
                Clob clob = resultSet.getClob(columnIndex);
                return null == clob ? null : clob.getSubString(1L, (int)clob.length());
            }
            case 2011: {
                NClob nClob = resultSet.getNClob(columnIndex);
                return null == nClob ? null : nClob.getSubString(1L, (int)nClob.length());
            }
            case 2003: {
                return resultSet.getArray(columnIndex);
            }
        }
        return resultSet.getObject(columnIndex);
    }

    private boolean isSigned(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return metaData.isSigned(columnIndex);
    }

    @Generated
    public InventoryColumnValueReaderEngine(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

