/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;

public final class TableAndSchemaNameMapper {
    private final Map<ShardingSphereIdentifier, String> mapping;

    public TableAndSchemaNameMapper(Map<String, String> tableSchemaMap) {
        this.mapping = null == tableSchemaMap ? Collections.emptyMap() : this.getLogicTableNameMap(tableSchemaMap);
    }

    public TableAndSchemaNameMapper(Collection<String> tableNames) {
        Map<String, String> tableNameSchemaMap = tableNames.stream().map(each -> each.split("\\.")).filter(split -> ((String[])split).length > 1).collect(Collectors.toMap(split -> split[1], split -> split[0]));
        this.mapping = this.getLogicTableNameMap(tableNameSchemaMap);
    }

    private Map<ShardingSphereIdentifier, String> getLogicTableNameMap(Map<String, String> tableSchemaMap) {
        HashMap<ShardingSphereIdentifier, String> result = new HashMap<ShardingSphereIdentifier, String>(tableSchemaMap.size(), 1.0f);
        for (Map.Entry<String, String> entry : tableSchemaMap.entrySet()) {
            String tableName = entry.getKey();
            String schemaName = entry.getValue();
            if (null == schemaName) continue;
            result.put(new ShardingSphereIdentifier(tableName), schemaName);
        }
        return result;
    }

    public String getSchemaName(String logicTableName) {
        return this.mapping.get(new ShardingSphereIdentifier(logicTableName));
    }

    public String getSchemaName(ShardingSphereIdentifier logicTableName) {
        return this.mapping.get(logicTableName);
    }

    public Collection<QualifiedTable> getQualifiedTables() {
        return this.mapping.entrySet().stream().map(entry -> new QualifiedTable((String)entry.getValue(), ((ShardingSphereIdentifier)entry.getKey()).getValue())).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "TableAndSchemaNameMapper(mapping=" + this.mapping + ")";
    }
}

