/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper;

import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.config.YamlTransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlJobItemIncrementalTasksProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlJobItemInventoryTasksProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlPipelineJobItemProgressSwapper;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class YamlTransmissionJobItemProgressSwapper
implements YamlPipelineJobItemProgressSwapper<YamlTransmissionJobItemProgress, TransmissionJobItemProgress> {
    private final YamlJobItemInventoryTasksProgressSwapper inventoryTasksProgressSwapper = new YamlJobItemInventoryTasksProgressSwapper();
    private final YamlJobItemIncrementalTasksProgressSwapper incrementalTasksProgressSwapper = new YamlJobItemIncrementalTasksProgressSwapper();

    public YamlTransmissionJobItemProgress swapToYamlConfiguration(TransmissionJobItemProgress progress) {
        YamlTransmissionJobItemProgress result = new YamlTransmissionJobItemProgress();
        result.setStatus(progress.getStatus().name());
        result.setSourceDatabaseType(progress.getSourceDatabaseType().getType());
        result.setDataSourceName(progress.getDataSourceName());
        result.setInventory(this.inventoryTasksProgressSwapper.swapToYaml(progress.getInventory()));
        result.setIncremental(this.incrementalTasksProgressSwapper.swapToYaml(progress.getIncremental()));
        result.setProcessedRecordsCount(progress.getProcessedRecordsCount());
        result.setInventoryRecordsCount(progress.getInventoryRecordsCount());
        return result;
    }

    public TransmissionJobItemProgress swapToObject(YamlTransmissionJobItemProgress yamlProgress) {
        TransmissionJobItemProgress result = new TransmissionJobItemProgress();
        result.setStatus(JobStatus.valueOf(yamlProgress.getStatus()));
        result.setSourceDatabaseType((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)yamlProgress.getSourceDatabaseType()));
        result.setDataSourceName(yamlProgress.getDataSourceName());
        result.setInventory(this.inventoryTasksProgressSwapper.swapToObject(yamlProgress.getInventory()));
        result.setIncremental(this.incrementalTasksProgressSwapper.swapToObject(yamlProgress.getSourceDatabaseType(), yamlProgress.getIncremental()));
        result.setProcessedRecordsCount(yamlProgress.getProcessedRecordsCount());
        result.setInventoryRecordsCount(yamlProgress.getInventoryRecordsCount());
        return result;
    }

    @Override
    public Class<YamlTransmissionJobItemProgress> getYamlProgressClass() {
        return YamlTransmissionJobItemProgress.class;
    }
}

