/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.splitter;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.UniqueKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.placeholder.IngestPlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataUtils;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.InventoryRecordsCountCalculator;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.InventoryPositionCalculator;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;

public final class InventoryDumperContextSplitter {
    private final PipelineDataSource dataSource;
    private final InventoryDumperContext dumperContext;

    public Collection<InventoryDumperContext> split(TransmissionJobItemContext jobItemContext) {
        return this.splitByTable().stream().flatMap(each -> this.splitByPrimaryKey((InventoryDumperContext)each, jobItemContext).stream()).collect(Collectors.toList());
    }

    private Collection<InventoryDumperContext> splitByTable() {
        return this.dumperContext.getCommonContext().getTableNameMapper().getTableNameMap().entrySet().stream().map(entry -> this.createTableSplitDumperContext((ShardingSphereIdentifier)entry.getKey(), (ShardingSphereIdentifier)entry.getValue())).collect(Collectors.toList());
    }

    private InventoryDumperContext createTableSplitDumperContext(ShardingSphereIdentifier actualTableName, ShardingSphereIdentifier logicTableName) {
        InventoryDumperContext result = new InventoryDumperContext(this.dumperContext.getCommonContext());
        result.setActualTableName(actualTableName.toString());
        result.setLogicTableName(logicTableName.toString());
        result.getCommonContext().setPosition(new IngestPlaceholderPosition());
        result.setInsertColumnNames(this.dumperContext.getInsertColumnNames());
        result.setUniqueKeyColumns(this.dumperContext.getUniqueKeyColumns());
        return result;
    }

    private Collection<InventoryDumperContext> splitByPrimaryKey(InventoryDumperContext dumperContext, TransmissionJobItemContext jobItemContext) {
        if (null == dumperContext.getUniqueKeyColumns()) {
            dumperContext.setUniqueKeyColumns(this.getTableUniqueKeys(dumperContext, jobItemContext));
        }
        LinkedList<InventoryDumperContext> result = new LinkedList<InventoryDumperContext>();
        TransmissionProcessContext jobProcessContext = jobItemContext.getJobProcessContext();
        int batchSize = jobProcessContext.getProcessConfiguration().getRead().getBatchSize();
        JobRateLimitAlgorithm rateLimitAlgorithm = jobProcessContext.getReadRateLimitAlgorithm();
        int i = 0;
        for (IngestPosition each : this.getPositions(dumperContext, jobItemContext)) {
            result.add(this.createPrimaryKeySplitDumperContext(dumperContext, each, i++, batchSize, rateLimitAlgorithm));
        }
        return result;
    }

    private List<PipelineColumnMetaData> getTableUniqueKeys(InventoryDumperContext dumperContext, TransmissionJobItemContext jobItemContext) {
        String schemaName = dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(dumperContext.getLogicTableName());
        return PipelineTableMetaDataUtils.getUniqueKeyColumns(schemaName, dumperContext.getActualTableName(), jobItemContext.getSourceMetaDataLoader());
    }

    private Collection<IngestPosition> getPositions(InventoryDumperContext dumperContext, TransmissionJobItemContext jobItemContext) {
        Collection<IngestPosition> result;
        TransmissionJobItemProgress initProgress = jobItemContext.getInitProgress();
        if (null != initProgress && !(result = initProgress.getInventory().getInventoryPosition(dumperContext.getActualTableName()).values()).isEmpty()) {
            return result;
        }
        long tableRecordsCount = InventoryRecordsCountCalculator.getTableRecordsCount(dumperContext, this.dataSource);
        jobItemContext.updateInventoryRecordsCount(tableRecordsCount);
        if (!dumperContext.hasUniqueKey()) {
            return Collections.singleton(UniqueKeyIngestPosition.ofUnsplit());
        }
        String schemaName = dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(dumperContext.getLogicTableName());
        int shardingSize = jobItemContext.getJobProcessContext().getProcessConfiguration().getRead().getShardingSize();
        return new InventoryPositionCalculator(this.dataSource, new QualifiedTable(schemaName, dumperContext.getActualTableName()), dumperContext.getUniqueKeyColumns(), tableRecordsCount, shardingSize).getPositions();
    }

    private InventoryDumperContext createPrimaryKeySplitDumperContext(InventoryDumperContext dumperContext, IngestPosition position, int shardingItem, int batchSize, JobRateLimitAlgorithm rateLimitAlgorithm) {
        InventoryDumperContext result = new InventoryDumperContext(dumperContext.getCommonContext());
        result.getCommonContext().setPosition(position);
        result.setShardingItem(shardingItem);
        result.setActualTableName(dumperContext.getActualTableName());
        result.setLogicTableName(dumperContext.getLogicTableName());
        result.setUniqueKeyColumns(dumperContext.getUniqueKeyColumns());
        result.setInsertColumnNames(dumperContext.getInsertColumnNames());
        result.setBatchSize(batchSize);
        result.setRateLimitAlgorithm(rateLimitAlgorithm);
        return result;
    }

    @Generated
    public InventoryDumperContextSplitter(PipelineDataSource dataSource, InventoryDumperContext dumperContext) {
        this.dataSource = dataSource;
        this.dumperContext = dumperContext;
    }
}

