/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment.PipelineSQLSegmentBuilder;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;

public final class PipelineInventoryDumpSQLBuilder {
    private final PipelineSQLSegmentBuilder sqlSegmentBuilder;

    public PipelineInventoryDumpSQLBuilder(DatabaseType databaseType) {
        this.sqlSegmentBuilder = new PipelineSQLSegmentBuilder(databaseType);
    }

    public String buildFetchAllSQL(String schemaName, String tableName, Collection<String> columnNames) {
        String qualifiedTableName = this.sqlSegmentBuilder.getQualifiedTableName(schemaName, tableName);
        String queryColumns = columnNames.stream().map(this.sqlSegmentBuilder::getEscapedIdentifier).collect(Collectors.joining(","));
        return String.format("SELECT %s FROM %s", queryColumns, qualifiedTableName);
    }
}

