/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import javafx.scene.control.ToggleButton;
import javafx.scene.text.Font;
import org.apache.sis.util.logging.Logging;

public final class FontGIS {
    private static final Font FONT;
    private static final int DEFAULT_SIZE = 18;
    private static final int DEFAULT_PADDING = 3;
    private static final String FALLBACK = "\u2b1a";

    private FontGIS() {
    }

    public static Button button(char code, String text) {
        Button glyph = new Button();
        FontGIS.setGlyph((Labeled)glyph, code, text, 18, 3);
        return glyph;
    }

    public static ToggleButton toggle(char code, String text) {
        ToggleButton glyph = new ToggleButton();
        FontGIS.setGlyph((Labeled)glyph, code, text, 18, 3);
        return glyph;
    }

    public static void setGlyph(Labeled ctrl, char code, String text, int size, int pads) {
        StringBuilder style = new StringBuilder();
        if (code != '\u0000' && FONT != null) {
            style.append("-fx-font-family:'").append(FONT.getFamily()).append("';");
            text = new String(new char[]{code});
        } else if (text == null) {
            text = FALLBACK;
        }
        if (size >= 0) {
            style.append(" -fx-font-size:").append(size).append("pt;");
        }
        if (pads >= 0) {
            style.append(" -fx-padding:").append(pads).append("pt;");
        }
        ctrl.setStyle(style.toString());
        ctrl.setText(text);
    }

    static {
        Font font;
        block9: {
            font = null;
            String filename = "font-gis.ttf";
            try {
                InputStream in = Code.class.getResourceAsStream("font-gis.ttf");
                if (in != null) {
                    try (InputStream inputStream = in;){
                        font = Font.loadFont((InputStream)in, (double)0.0);
                        break block9;
                    }
                }
                throw new FileNotFoundException("font-gis.ttf");
            }
            catch (IOException e) {
                Logging.unexpectedException((Logger)Logger.getLogger("org.apache.sis.gui"), FontGIS.class, (String)"<cinit>", (Throwable)e);
            }
        }
        FONT = font;
    }

    public static final class Code {
        public static final char NORTH_ARROW = '\uea8b';
        public static final char NORTH_ARROW_N = '\uea8c';
        public static final char COMPASS = '\uea90';
        public static final char COMPASS_NEEDLE = '\uea91';
        public static final char COMPASS_ROSE = '\uea92';
        public static final char COMPASS_ROSE_N = '\uea93';
        public static final char COMPASS_ALT = '\ueb06';
        public static final char COMPASS_ALT_O = '\ueb07';
        public static final char ARROW_O = '\uea3a';
        public static final char ARROW = '\uea3b';
        public static final char MODIFY_LINE = '\uea3c';
        public static final char MODIFY_POLY = '\uea3d';
        public static final char MODIFY_POLY_O = '\uea40';
        public static final char COPY_POINT = '\uea4f';
        public static final char COPY_LINE = '\uea50';
        public static final char COPY_POLY = '\uea51';
        public static final char BUFFER = '\uea6e';
        public static final char DIFFERENCE = '\uea6f';
        public static final char INTERSECTION = '\uea70';
        public static final char UNION = '\uea71';
        public static final char SYM_DIFFERENCE = '\uea72';
        public static final char MOVE = '\uea73';
        public static final char MOVE_ALT = '\uea74';
        public static final char OFFSET = '\uea75';
        public static final char SNAP = '\uea76';
        public static final char SPLIT = '\uea77';
        public static final char SPLIT_LINE = '\uea78';
        public static final char SPLIT_POLYGON = '\uea79';
        public static final char CONVEX_HULL = '\ueaa8';
        public static final char SELECT_EXTENT = '\ueaad';
        public static final char SNAP_ORTHO = '\ueaae';
        public static final char COLOR = '\ueaaf';
        public static final char ROTATE = '\ueae3';
        public static final char FLIP_H = '\ueae4';
        public static final char FLIP_V = '\ueae5';
        public static final char SIMPLIFY = '\ueae6';
        public static final char PROJ_POINT = '\ueae7';
        public static final char SCALE_POLY = '\ueae8';
        public static final char SKELETONIZE = '\ueb17';
        public static final char DILATATION = '\ueb18';
        public static final char EROSION = '\ueb19';
        public static final char TRANSLATE = '\ueb26';
        public static final char TRANSLATE_X = '\ueb27';
        public static final char TRANSLATE_Y = '\ueb28';
        public static final char GPX_FILE = '\uea99';
        public static final char GEOJSON_FILE = '\uea9a';
        public static final char KML_FILE = '\uea9b';
        public static final char WMS = '\uea9c';
        public static final char WMTS = '\uea9d';
        public static final char WFS = '\uea9e';
        public static final char WFS_T = '\uea9f';
        public static final char MVT = '\ueaa0';
        public static final char XYZ = '\ueaa1';
        public static final char SHAPE_FILE = '\ueaa2';
        public static final char ESRI_JSON_FILE = '\ueaa3';
        public static final char TOPOJSON_FILE = '\ueaa4';
        public static final char FOLDER_MAP = '\ueb2f';
        public static final char WORLD_FOLDER_O = '\ueb30';
        public static final char WORLD_FOLDER = '\ueb31';
        public static final char FOLDER_GLOBE = '\ueb32';
        public static final char FOLDER_GLOBE_O = '\ueb33';
        public static final char FOLDER_MAPS = '\ueb34';
        public static final char FOLDER_POI = '\ueb35';
        public static final char FOLDER_POI_O = '\ueb36';
        public static final char FOLDER_POIS = '\ueb37';
        public static final char EARTH_NET = '\ueb38';
        public static final char EARTH_NET_O = '\ueb39';
        public static final char WCS = '\ueb59';
        public static final char POINT = '\uea01';
        public static final char POLYLINE_PT = '\uea02';
        public static final char POLYGON_PT = '\uea03';
        public static final char POLYGON_HOLE_PT = '\uea04';
        public static final char RECTANGLE_PT = '\uea05';
        public static final char SQUARE_PT = '\uea06';
        public static final char CIRCLE_O = '\uea07';
        public static final char POLYLINE = '\uea09';
        public static final char POLYGON_O = '\uea0a';
        public static final char POLYGON_HOLE_O = '\uea0b';
        public static final char RECTANGLE_O = '\uea0c';
        public static final char SQUARE_O = '\uea0d';
        public static final char POLYGON_HOLE = '\uea0e';
        public static final char POLYGON = '\uea0f';
        public static final char RECTANGLE = '\uea10';
        public static final char SQUARE = '\uea11';
        public static final char CIRCLE = '\uea12';
        public static final char MULTIPOINT = '\uea52';
        public static final char BBOX_ALT = '\ueaa9';
        public static final char EXTENT_ALT = '\ueaaa';
        public static final char BBOX = '\ueaab';
        public static final char EXTENT = '\ueaac';
        public static final char MAP_EXTENT = '\ueab0';
        public static final char REGULAR_SHAPE_PT = '\ueaeb';
        public static final char REGULAR_SHAPE_O = '\ueaec';
        public static final char REGULAR_SHAPE = '\ueaed';
        public static final char LAYER = '\uea41';
        public static final char LAYER_O = '\uea42';
        public static final char LAYERS = '\uea43';
        public static final char LAYERS_O = '\uea44';
        public static final char LAYER_UP = '\uea45';
        public static final char LAYER_DOWN = '\uea46';
        public static final char LAYER_ALT = '\uea47';
        public static final char LAYER_ALT_O = '\uea48';
        public static final char LAYER_STACK = '\uea49';
        public static final char LAYER_STACK_O = '\uea4a';
        public static final char LAYER_ADD = '\uea4b';
        public static final char LAYER_ADD_O = '\uea4c';
        public static final char LAYER_RM = '\uea4d';
        public static final char LAYER_RM_O = '\uea4e';
        public static final char LAYER_POI = '\uea6a';
        public static final char LAYER_DOWNLOAD = '\uea97';
        public static final char LAYER_UPLOAD = '\uea98';
        public static final char LAYER_ROAD = '\ueaf0';
        public static final char LAYER_HYDRO = '\ueaf1';
        public static final char LAYER_LANDCOVER = '\ueaf2';
        public static final char LAYER_CONTOUR = '\ueaf3';
        public static final char LAYER_STAT = '\ueaf4';
        public static final char LAYER_STAT_ALT = '\ueb29';
        public static final char LAYER_EDIT = '\ueb2d';
        public static final char LAYER_ALT_EDIT = '\ueb2e';
        public static final char LAYER_HEIGHT = '\ueb41';
        public static final char LAYER_2_ADD_O = '\ueb46';
        public static final char LAYER_2_RM_O = '\ueb47';
        public static final char LAYER_ALT_ADD_O = '\ueb48';
        public static final char LAYER_ALT_RM_O = '\ueb49';
        public static final char LAYER_ALT_X_O = '\ueb4a';
        public static final char LAYERS_POI = '\ueb4f';
        public static final char LAYER_ALT_POI = '\ueb50';
        public static final char EARTH = '\uea22';
        public static final char EARTH_EURO_AFRICA = '\uea23';
        public static final char EARTH_ATLANTIC = '\uea24';
        public static final char EARTH_AMERICA = '\uea25';
        public static final char EARTH_PACIFIC = '\uea26';
        public static final char EARTH_AUSTRALIA = '\uea27';
        public static final char EARTH_ASIA = '\uea28';
        public static final char EARTH_NORTH = '\uea29';
        public static final char EARTH_SOUTH = '\uea2a';
        public static final char EARTH_O = '\uea2b';
        public static final char EARTH_EURO_AFRICA_O = '\uea2c';
        public static final char EARTH_ATLANTIC_O = '\uea2d';
        public static final char EARTH_AMERICA_O = '\uea2e';
        public static final char EARTH_PACIFIC_O = '\uea2f';
        public static final char EARTH_AUSTRALIA_O = '\uea30';
        public static final char EARTH_ASIA_O = '\uea31';
        public static final char EARTH_NORTH_O = '\uea32';
        public static final char EARTH_SOUTH_O = '\uea33';
        public static final char GLOBE = '\uea36';
        public static final char GLOBE_O = '\uea37';
        public static final char GLOBE_ALT = '\uea38';
        public static final char GLOBE_ALT_O = '\uea39';
        public static final char GLOBE_POI = '\uea82';
        public static final char NETWORK = '\ueabb';
        public static final char NETWORK_O = '\ueabc';
        public static final char TAG = '\ueac1';
        public static final char TAG_O = '\ueac2';
        public static final char TAGS = '\ueac3';
        public static final char TAGS_O = '\ueac4';
        public static final char EARTH_GEAR = '\uead5';
        public static final char GLOBE_EARTH = '\ueaf8';
        public static final char GLOBE_EARTH_ALT = '\ueaf9';
        public static final char GLOBE_FAVORITE = '\ueafb';
        public static final char GLOBE_OPTIONS = '\ueafc';
        public static final char GLOBE_SHARE = '\ueafd';
        public static final char GLOBE_STAR = '\ueafe';
        public static final char GLOBE_SMILEY = '\ueaff';
        public static final char GLOBE_USER = '\ueb0c';
        public static final char GLOBE_USERS = '\ueb0d';
        public static final char GLOBE_SHIELD = '\ueb0e';
        public static final char EARTH_NETWORK = '\ueb0f';
        public static final char EARTH_NETWORK_O = '\ueb10';
        public static final char GLOBE_GEAR = '\ueb11';
        public static final char MAP = '\uea53';
        public static final char MAP_O = '\uea54';
        public static final char MAP_POI = '\uea55';
        public static final char WORLD_MAP_ALT = '\uea56';
        public static final char MAP_ROUTE = '\uea57';
        public static final char ROAD_MAP = '\uea58';
        public static final char CADASTRE_MAP = '\uea59';
        public static final char LANDCOVER_MAP = '\uea5a';
        public static final char BUS_MAP = '\uea5b';
        public static final char CONTOUR_MAP = '\uea5c';
        public static final char HYDRO_MAP = '\uea5d';
        public static final char WORLD_MAP = '\uea68';
        public static final char PIRATE_MAP = '\uea6b';
        public static final char STORY_MAP = '\uea6d';
        public static final char MAP_BOOK = '\uea7a';
        public static final char MAP_LEGEND = '\uea85';
        public static final char MAP_LEGEND_O = '\uea86';
        public static final char MAP_OPTIONS = '\uea94';
        public static final char MAP_OPTIONS_ALT = '\uea95';
        public static final char MAP_PRINT = '\uea96';
        public static final char WORLD_MAP_ALT_O = '\ueab1';
        public static final char FLOW_MAP = '\ueab2';
        public static final char MAP_STAT = '\ueab3';
        public static final char STATISTIC_MAP = '\ueab4';
        public static final char VORONOI_MAP = '\ueab7';
        public static final char TRIANGLE_MAP = '\ueab8';
        public static final char PHONE_MAP = '\ueab9';
        public static final char HEX_MAP = '\ueaba';
        public static final char MAP_BOOKMARK = '\ueabd';
        public static final char MAP_TAG = '\ueabf';
        public static final char MAP_TAGS = '\ueac0';
        public static final char COMPARE_MAP = '\uead8';
        public static final char SWIPE_MAP_V = '\uead9';
        public static final char SWIPE_MAP_H = '\ueada';
        public static final char MAGNIFY_MAP = '\ueadb';
        public static final char MAP_SHARE = '\ueae0';
        public static final char MAP_SEND = '\ueae1';
        public static final char MAP_SHARE_ALT = '\ueae2';
        public static final char MAP_ADD = '\ueae9';
        public static final char MAP_RM = '\ueaea';
        public static final char MAP_TIME = '\ueaee';
        public static final char TIME_MAP = '\ueaef';
        public static final char MAP_PLAY = '\ueaf5';
        public static final char MAP_STAR = '\ueaf6';
        public static final char MAP_FAVORITE = '\ueaf7';
        public static final char MAP_SMILEY = '\ueb00';
        public static final char MAP_CONTROL = '\ueb02';
        public static final char MAP_LOCK = '\ueb04';
        public static final char MAP_UNLOCK = '\ueb05';
        public static final char WEATHER_MAP = '\ueb0b';
        public static final char STORY_MAP_O = '\ueb2a';
        public static final char STORY_MAPS = '\ueb2b';
        public static final char MAP_EDIT = '\ueb2c';
        public static final char HEIGHT_MAP = '\ueb40';
        public static final char MAP_USER = '\ueb4b';
        public static final char MAP_USERS = '\ueb4c';
        public static final char MEASURE = '\uea08';
        public static final char MEASURE_LINE = '\uea13';
        public static final char MEASURE_AREA = '\uea14';
        public static final char MEASURE_AREA_ALT = '\uea15';
        public static final char SCALE = '\ueb01';
        public static final char AZIMUTH = '\ueb53';
        public static final char HELP_LARROW = '\uea3e';
        public static final char HELP_RARROW = '\uea3f';
        public static final char HOME = '\ueb14';
        public static final char SATELLITE = '\ueb3a';
        public static final char SATELLITE_EARTH = '\ueb3b';
        public static final char DRONE = '\ueb3f';
        public static final char POI = '\uea16';
        public static final char POI_O = '\uea17';
        public static final char POI_ALT = '\uea18';
        public static final char POI_ALT_O = '\uea19';
        public static final char PIN = '\uea1a';
        public static final char PUSHPIN = '\uea1b';
        public static final char POIS = '\uea1c';
        public static final char POIS_O = '\uea1d';
        public static final char POI_FAVORITE = '\uea1e';
        public static final char POI_FAVORITE_O = '\uea1f';
        public static final char POI_HOME = '\uea20';
        public static final char POI_HOME_O = '\uea21';
        public static final char POI_EARTH = '\uea34';
        public static final char PIN_EARTH = '\uea35';
        public static final char PIRATE_POI = '\uea6c';
        public static final char LOCATION_POI = '\uea83';
        public static final char LOCATION_POI_O = '\uea84';
        public static final char BOOKMARK_POI = '\ueabe';
        public static final char BOOKMARK_POI_B = '\ueacf';
        public static final char POI_MAP = '\uead6';
        public static final char POI_MAP_O = '\uead7';
        public static final char LOCATION_MAN = '\ueb15';
        public static final char LOCATION_MAN_ALT = '\ueb16';
        public static final char POI_INFO = '\ueb1c';
        public static final char POI_INFO_O = '\ueb1d';
        public static final char POSITION = '\ueb22';
        public static final char POSITION_O = '\ueb23';
        public static final char POSITION_MAN = '\ueb24';
        public static final char POI_SLASH = '\ueb4d';
        public static final char POI_SLASH_O = '\ueb4e';
        public static final char ROUTE = '\uea7b';
        public static final char ROUTE_START = '\uea7c';
        public static final char ROUTE_END = '\uea7d';
        public static final char CAR = '\uea7e';
        public static final char BICYCLE = '\uea7f';
        public static final char PEDESTRIAN = '\uea80';
        public static final char HIKER = '\uea81';
        public static final char LOCATION_ARROW = '\uea87';
        public static final char LOCATION_ARROW_O = '\uea88';
        public static final char LOCATION = '\uea89';
        public static final char LOCATION_ON = '\uea8a';
        public static final char DIRECT = '\uea8d';
        public static final char REVERS = '\uea8e';
        public static final char TIMER = '\uea8f';
        public static final char SIGNPOST = '\ueab5';
        public static final char DIRECTION = '\ueab6';
        public static final char FLAG = '\ueac5';
        public static final char FLAG_O = '\ueac6';
        public static final char FLAG_START = '\ueac7';
        public static final char FLAG_START_O = '\ueac8';
        public static final char FLAG_FINISH = '\ueac9';
        public static final char FLAG_B = '\ueaca';
        public static final char FLAB_B_O = '\ueacb';
        public static final char FLAG_START_B = '\ueacc';
        public static final char FLAG_START_B_O = '\ueacd';
        public static final char FLAG_FINISH_B_O = '\ueace';
        public static final char START = '\uead0';
        public static final char START_O = '\uead1';
        public static final char STEP = '\uead2';
        public static final char STEP_O = '\uead3';
        public static final char FINISH = '\uead4';
        public static final char DIRECTIONS = '\ueb03';
        public static final char PHONE_ROUTE = '\ueb08';
        public static final char PHONE_ROUTE_ALT = '\ueb09';
        public static final char PHONE_ROUTE_ALT_R = '\ueb0a';
        public static final char MAP_SEARCH = '\uea5e';
        public static final char SEARCH_MAP = '\uea5f';
        public static final char SEARCH_POI = '\uea60';
        public static final char SEARCH_GLOBE = '\uea61';
        public static final char SEARCH_HOME = '\uea62';
        public static final char SEARCH_ADDRESS = '\uea63';
        public static final char SEARCH_ATTRIBTUES = '\uea64';
        public static final char SEARCH_PROPERTIE = '\uea65';
        public static final char SEARCH_FEATURE = '\uea66';
        public static final char SEARCH_LAYER = '\uea67';
        public static final char SEARCH_COUNTRY = '\uea69';
        public static final char SEARCH_GLOBE_ALT = '\ueafa';
        public static final char SEARCH_COORD = '\ueb12';
        public static final char SEARCH_DATA = '\ueb13';
        public static final char ZOOM_IN = '\ueaa5';
        public static final char ZOOM_OUT = '\ueaa6';
        public static final char FULL_SCREEN = '\ueaa7';
        public static final char SCREEN_DUB = '\ueadc';
        public static final char SCREEN_SPLIT_H = '\ueadd';
        public static final char SCREEN_SPLIT_V = '\ueade';
        public static final char SCREEN_MAG = '\ueadf';
        public static final char COORD_SYSTEM = '\ueb1a';
        public static final char COORD_SYSTEM_3D = '\ueb1b';
        public static final char COORD_SYSTEM_ALT = '\ueb1e';
        public static final char COORD_SYSTEM_3D_ALT = '\ueb1f';
        public static final char GRID = '\ueb20';
        public static final char CUBE_3D = '\ueb21';
        public static final char COORD_GRID = '\ueb25';
        public static final char PHOTOGRAMMETRY = '\ueb3c';
        public static final char D360 = '\ueb3d';
        public static final char TOPOGRAPHY = '\ueb3e';
        public static final char GNSS = '\ueb42';
        public static final char GNSS_ANTENNA = '\ueb43';
        public static final char TACHEOMETER = '\ueb44';
        public static final char THEODOLITE = '\ueb45';
        public static final char PROFILE = '\ueb51';
        public static final char PROFILE_O = '\ueb52';
        public static final char SCREEN_DUB1 = '\ueb54';
        public static final char SCREEN_DUB2 = '\ueb55';
        public static final char SCREEN_DUB_O = '\ueb56';
        public static final char SCREEN_MAG_O = '\ueb57';
        public static final char SCREEN_MAG_ALT = '\ueb58';

        private Code() {
        }
    }
}

