/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals.MetricKey;

public class LastValueTracker<T> {
    private final Map<MetricKey, InstantAndValue<T>> counters = new ConcurrentHashMap<MetricKey, InstantAndValue<T>>();

    public Optional<InstantAndValue<T>> getAndSet(MetricKey metricKey, Instant now, T value) {
        InstantAndValue<T> instantAndValue = new InstantAndValue<T>(now, value);
        InstantAndValue<T> valueOrNull = this.counters.put(metricKey, instantAndValue);
        if (valueOrNull == null) {
            return Optional.empty();
        }
        return Optional.of(valueOrNull);
    }

    public InstantAndValue<T> remove(MetricKey metricKey) {
        return this.counters.remove(metricKey);
    }

    public boolean contains(MetricKey metricKey) {
        return this.counters.containsKey(metricKey);
    }

    public void reset() {
        this.counters.clear();
    }

    public static class InstantAndValue<T> {
        private final Instant intervalStart;
        private final T value;

        public InstantAndValue(Instant intervalStart, T value) {
            this.intervalStart = Objects.requireNonNull(intervalStart);
            this.value = Objects.requireNonNull(value);
        }

        public Instant getIntervalStart() {
            return this.intervalStart;
        }

        public T getValue() {
            return this.value;
        }
    }
}

