/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.InstanceFilter;
import org.apache.sling.discovery.commons.InstancesDiff;
import org.junit.Test;
import org.mockito.Mockito;

public class InstancesDiffTest {
    @Test(expected=IllegalArgumentException.class)
    public void testDuplicatedSlingIds() {
        List<Instance> old = Arrays.asList(new Instance("duplicated"), new Instance("one"), new Instance("duplicated"));
        new InstancesDiff(old, this.empty());
    }

    @Test
    public void testEmptyCollections() {
        InstancesDiff diff = new InstancesDiff(this.empty(), this.empty());
        TestCase.assertEquals((int)0, (int)diff.all(true).get().size());
        TestCase.assertEquals((int)0, (int)diff.added().get().size());
        TestCase.assertEquals((int)0, (int)diff.removed().get().size());
        TestCase.assertEquals((int)0, (int)diff.retained(true).get().size());
    }

    @Test
    public void testAddedFromEmpty() throws Exception {
        InstancesDiff diff = new InstancesDiff(this.empty(), Arrays.asList(new Instance("one"), new Instance("two")));
        TestCase.assertEquals((int)2, (int)diff.added().get().size());
    }

    @Test
    public void testAddedWithEmpty() throws Exception {
        InstancesDiff diff = new InstancesDiff(Arrays.asList(new Instance("one"), new Instance("two")), this.empty());
        TestCase.assertEquals((int)0, (int)diff.added().get().size());
    }

    @Test
    public void testAddedWithoutIntersection() throws Exception {
        InstancesDiff diff = new InstancesDiff(Collections.singletonList(new Instance("one")), Collections.singletonList(new Instance("two")));
        TestCase.assertEquals((int)1, (int)diff.added().get().size());
        TestCase.assertEquals((String)"two", (String)((InstanceDescription)diff.added().get().iterator().next()).getSlingId());
    }

    @Test
    public void testAddedWithIntersection() throws Exception {
        InstancesDiff diff = new InstancesDiff(Arrays.asList(new Instance("one"), new Instance("two")), Arrays.asList(new Instance("two"), new Instance("three")));
        TestCase.assertEquals((int)1, (int)diff.added().get().size());
        TestCase.assertEquals((String)"three", (String)((InstanceDescription)diff.added().get().iterator().next()).getSlingId());
    }

    @Test
    public void testAll() throws Exception {
        InstancesDiff diff = new InstancesDiff(Collections.singletonList(new Instance("one")), Arrays.asList(new Instance("two"), new Instance("three")));
        TestCase.assertEquals((int)3, (int)diff.all(true).get().size());
    }

    @Test
    public void testAllRetainedCollection() throws Exception {
        Instance oldInstance = new Instance("one");
        Instance newInstance = new Instance("one");
        InstancesDiff diff = new InstancesDiff(Collections.singletonList(oldInstance), Collections.singletonList(newInstance));
        TestCase.assertEquals((int)1, (int)diff.all(true).get().size());
        TestCase.assertEquals((Object)newInstance, diff.all(true).get().iterator().next());
        TestCase.assertEquals((int)1, (int)diff.all(false).get().size());
        TestCase.assertEquals((Object)oldInstance, diff.all(false).get().iterator().next());
    }

    @Test
    public void testRemovedFromEmpty() throws Exception {
        InstancesDiff diff = new InstancesDiff(this.empty(), Arrays.asList(new Instance("one"), new Instance("two")));
        TestCase.assertEquals((int)0, (int)diff.removed().get().size());
    }

    @Test
    public void testRemovedWithEmpty() throws Exception {
        InstancesDiff diff = new InstancesDiff(Arrays.asList(new Instance("one"), new Instance("two")), this.empty());
        TestCase.assertEquals((int)2, (int)diff.removed().get().size());
    }

    @Test
    public void testRemovedWithoutIntersection() throws Exception {
        InstancesDiff diff = new InstancesDiff(Collections.singletonList(new Instance("one")), Collections.singletonList(new Instance("two")));
        TestCase.assertEquals((int)1, (int)diff.removed().get().size());
        TestCase.assertEquals((String)"one", (String)((InstanceDescription)diff.removed().get().iterator().next()).getSlingId());
    }

    @Test
    public void testRemovedWithIntersection() throws Exception {
        InstancesDiff diff = new InstancesDiff(Arrays.asList(new Instance("one"), new Instance("two")), Arrays.asList(new Instance("two"), new Instance("three")));
        TestCase.assertEquals((int)1, (int)diff.removed().get().size());
        TestCase.assertEquals((String)"one", (String)((InstanceDescription)diff.removed().get().iterator().next()).getSlingId());
    }

    @Test
    public void testRetainedWithoutIntersection() throws Exception {
        InstancesDiff diff = new InstancesDiff(this.empty(), Arrays.asList(new Instance("one"), new Instance("two")));
        TestCase.assertEquals((int)0, (int)diff.retained(true).get().size());
    }

    @Test
    public void testRetainedWithIntersection() throws Exception {
        InstancesDiff diff = new InstancesDiff(Arrays.asList(new Instance("one"), new Instance("two")), Arrays.asList(new Instance("two"), new Instance("three")));
        TestCase.assertEquals((int)1, (int)diff.retained(true).get().size());
        TestCase.assertEquals((String)"two", (String)((InstanceDescription)diff.retained(true).get().iterator().next()).getSlingId());
    }

    @Test
    public void testRetainedCollection() throws Exception {
        Instance oldInstance = new Instance("one");
        Instance newInstance = new Instance("one");
        InstancesDiff diff = new InstancesDiff(Collections.singletonList(oldInstance), Collections.singletonList(newInstance));
        TestCase.assertEquals((int)1, (int)diff.retained(true).get().size());
        TestCase.assertEquals((Object)newInstance, diff.retained(true).get().iterator().next());
        TestCase.assertEquals((Object)oldInstance, diff.retained(false).get().iterator().next());
    }

    @Test
    public void testRetainedByProperties() throws Exception {
        InstancesDiff diff = new InstancesDiff(Arrays.asList(new Instance("one", Collections.singletonMap("p1", "v1")), new Instance("two", Collections.singletonMap("p1", "v1"))), Arrays.asList(new Instance("one", Collections.singletonMap("p1", "v2")), new Instance("two", Collections.singletonMap("p1", "v1"))));
        TestCase.assertEquals((int)1, (int)diff.retained(true, false).get().size());
        TestCase.assertEquals((String)"two", (String)((InstanceDescription)diff.retained(true, false).get().iterator().next()).getSlingId());
        TestCase.assertEquals((int)1, (int)diff.retained(true, true).get().size());
        TestCase.assertEquals((String)"one", (String)((InstanceDescription)diff.retained(true, true).get().iterator().next()).getSlingId());
    }

    @Test
    public void testEmptyResult() throws Exception {
        Collection instances = new InstancesDiff(Arrays.asList(new Instance("one"), new Instance("two")), this.empty()).all(true).filterWith(new InstanceFilter(){

            public boolean accept(InstanceDescription instanceDescription) {
                return false;
            }
        }).get();
        TestCase.assertEquals((int)0, (int)instances.size());
    }

    @Test
    public void testFilterWith() throws Exception {
        Collection instances = new InstancesDiff(Arrays.asList(new Instance("one"), new Instance("two")), this.empty()).all(true).filterWith(new InstanceFilter(){

            public boolean accept(InstanceDescription instanceDescription) {
                return "one".equals(instanceDescription.getSlingId());
            }
        }).get();
        TestCase.assertEquals((int)1, (int)instances.size());
        TestCase.assertEquals((String)"one", (String)((InstanceDescription)instances.iterator().next()).getSlingId());
    }

    @Test
    public void testIsLeader() throws Exception {
        Collection instances = new InstancesDiff(Arrays.asList(new Instance("one", true, false, Collections.emptyMap(), "viewId"), new Instance("two", false, false, Collections.emptyMap(), "viewId")), this.empty()).all(true).isLeader().get();
        TestCase.assertEquals((int)1, (int)instances.size());
        TestCase.assertEquals((String)"one", (String)((InstanceDescription)instances.iterator().next()).getSlingId());
    }

    @Test
    public void testIsNotLeader() throws Exception {
        Collection instances = new InstancesDiff(Arrays.asList(new Instance("one", true, false, Collections.emptyMap(), "viewId"), new Instance("two", false, false, Collections.emptyMap(), "viewId")), this.empty()).all(true).isNotLeader().get();
        TestCase.assertEquals((int)1, (int)instances.size());
        TestCase.assertEquals((String)"two", (String)((InstanceDescription)instances.iterator().next()).getSlingId());
    }

    @Test
    public void testIsLocal() throws Exception {
        Collection instances = new InstancesDiff(Arrays.asList(new Instance("one", true, false, Collections.emptyMap(), "viewId"), new Instance("two", false, true, Collections.emptyMap(), "viewId")), this.empty()).all(true).isLocal().get();
        TestCase.assertEquals((int)1, (int)instances.size());
        TestCase.assertEquals((String)"two", (String)((InstanceDescription)instances.iterator().next()).getSlingId());
    }

    @Test
    public void testIsNotLocal() throws Exception {
        Collection instances = new InstancesDiff(Arrays.asList(new Instance("one", true, false, Collections.emptyMap(), "viewId"), new Instance("two", false, true, Collections.emptyMap(), "viewId")), this.empty()).all(true).isNotLocal().get();
        TestCase.assertEquals((int)1, (int)instances.size());
        TestCase.assertEquals((String)"one", (String)((InstanceDescription)instances.iterator().next()).getSlingId());
    }

    @Test
    public void testIsInClusterView() throws Exception {
        ClusterView clusterView = this.clusterView("viewId");
        Collection instances = new InstancesDiff(Arrays.asList(new Instance("one", true, false, Collections.emptyMap(), "otherView"), new Instance("two", false, true, Collections.emptyMap(), "viewId")), this.empty()).all(true).isInClusterView(clusterView).get();
        TestCase.assertEquals((int)1, (int)instances.size());
        TestCase.assertEquals((String)"two", (String)((InstanceDescription)instances.iterator().next()).getSlingId());
    }

    @Test
    public void testIsNotInClusterView() throws Exception {
        ClusterView clusterView = this.clusterView("yet-another-view");
        Collection instances = new InstancesDiff(Arrays.asList(new Instance("one", true, false, Collections.emptyMap(), "otherView"), new Instance("two", false, true, Collections.emptyMap(), "viewId")), this.empty()).all(true).isInClusterView(clusterView).get();
        TestCase.assertEquals((int)0, (int)instances.size());
    }

    private List<Instance> empty() {
        return Collections.emptyList();
    }

    private ClusterView clusterView(String clusterViewId) {
        ClusterView clusterView = (ClusterView)Mockito.mock(ClusterView.class);
        Mockito.when((Object)clusterView.getId()).thenReturn((Object)clusterViewId);
        return clusterView;
    }

    private class Instance
    implements InstanceDescription {
        final String slingId;
        final boolean leader;
        final boolean local;
        final Map<String, String> properties;
        final ClusterView clusterView;

        Instance(String slingId) {
            this(slingId, false, false, Collections.emptyMap(), "");
        }

        Instance(String slingId, Map<String, String> properties) {
            this(slingId, false, false, properties, "");
        }

        Instance(String slingId, boolean leader, boolean local, Map<String, String> properties, String clusterViewId) {
            this.slingId = slingId;
            this.leader = leader;
            this.local = local;
            this.properties = properties;
            this.clusterView = InstancesDiffTest.this.clusterView(clusterViewId);
        }

        public ClusterView getClusterView() {
            return this.clusterView;
        }

        public boolean isLeader() {
            return this.leader;
        }

        public boolean isLocal() {
            return this.local;
        }

        public String getSlingId() {
            return this.slingId;
        }

        public String getProperty(String name) {
            return this.properties.get(name);
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }
}

