/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.importer;

import java.io.InputStream;
import java.util.Map;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.impl.importer.RemoteDistributionPackageImporter;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionPackageImporter.class}, property={"webconsole.configurationFactory.nameHint=Importer name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class RemoteDistributionPackageImporterFactory
implements DistributionPackageImporter {
    @Reference(name="transportSecretProvider")
    private DistributionTransportSecretProvider transportSecretProvider;
    private DistributionPackageImporter importer;

    @Activate
    protected void activate(Config conf) {
        Map<String, String> endpoints = SettingsUtils.toUriMap(conf.endpoints());
        String importerName = conf.name();
        DefaultDistributionLog distributionLog = new DefaultDistributionLog(DistributionComponentKind.IMPORTER, importerName, RemoteDistributionPackageImporter.class, DefaultDistributionLog.LogLevel.ERROR);
        HttpConfiguration httpConfiguration = new HttpConfiguration(10000);
        this.importer = new RemoteDistributionPackageImporter(distributionLog, this.transportSecretProvider, endpoints, httpConfiguration);
    }

    @Override
    public void importPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        this.importer.importPackage(resourceResolver, distributionPackage);
    }

    @Override
    @NotNull
    public DistributionPackageInfo importStream(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.importer.importStream(resourceResolver, stream);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Importer - Remote Package Importer Factory")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the importer.")
        public String name();

        @AttributeDefinition(cardinality=100, name="Endpoints", description="The list of endpoints to which the packages will be imported.")
        public String[] endpoints();

        @AttributeDefinition(name="Transport Secret Provider", description="The target reference for the DistributionTransportSecretProvider used to obtain the credentials used for accessing the remote endpoints, e.g. use target=(name=...) to bind to services by name.")
        public String transportSecretProvider_target();
    }
}

