/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RunmodeMapper {
    static final String FILENAME = "runmode.mapping";
    private static final String DEFAULT = "(default)";
    private final File runmodeMappingFile;
    private final Map<String, Set<String>> properties = new HashMap<String, Set<String>>();

    @NotNull
    public static RunmodeMapper open(@NotNull File featureModelsOutputDirectory) throws IOException {
        Properties properties = new Properties();
        File runmodeMappingFile = new File(featureModelsOutputDirectory, FILENAME);
        if (runmodeMappingFile.exists()) {
            try (FileInputStream input = new FileInputStream(runmodeMappingFile);){
                properties.load(input);
            }
        }
        return new RunmodeMapper(runmodeMappingFile, properties);
    }

    private RunmodeMapper(@NotNull File runmodeMappingFile, @NotNull Properties properties) {
        this.runmodeMappingFile = runmodeMappingFile;
        for (String key : properties.stringPropertyNames()) {
            for (String name : properties.getProperty(key).split(",")) {
                this.properties.computeIfAbsent(key, id -> new LinkedHashSet()).add(name);
            }
        }
    }

    public void addOrUpdate(@Nullable String runMode, @NotNull String jsonFileName) {
        if (runMode == null) {
            runMode = DEFAULT;
        }
        this.properties.computeIfAbsent(runMode, id -> new LinkedHashSet()).add(jsonFileName);
    }

    public void save() throws IOException {
        Properties props = new Properties();
        for (Map.Entry<String, Set<String>> entry : this.properties.entrySet()) {
            props.put(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        try (FileOutputStream output = new FileOutputStream(this.runmodeMappingFile);){
            props.store(output, "File edited by the Apache Sling Content Package to Sling Feature converter");
        }
    }
}

