/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Map;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.NamespaceChange;

@Evolving
public interface SupportsNamespaces
extends CatalogPlugin {
    public static final String PROP_LOCATION = "location";
    public static final String PROP_COMMENT = "comment";
    public static final String PROP_OWNER = "owner";

    public String[][] listNamespaces() throws NoSuchNamespaceException;

    public String[][] listNamespaces(String[] var1) throws NoSuchNamespaceException;

    default public boolean namespaceExists(String[] namespace) {
        try {
            this.loadNamespaceMetadata(namespace);
            return true;
        }
        catch (NoSuchNamespaceException e) {
            return false;
        }
    }

    public Map<String, String> loadNamespaceMetadata(String[] var1) throws NoSuchNamespaceException;

    public void createNamespace(String[] var1, Map<String, String> var2) throws NamespaceAlreadyExistsException;

    public void alterNamespace(String[] var1, NamespaceChange ... var2) throws NoSuchNamespaceException;

    public boolean dropNamespace(String[] var1, boolean var2) throws NoSuchNamespaceException, NonEmptyNamespaceException;
}

