/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.ByteArrayPair;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateEncoder$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u000f\u001f\u00015B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003E\u0001\u0011\u0005Q\tC\u0004K\u0001\t\u0007I\u0011B&\t\ry\u0003\u0001\u0015!\u0003M\u0011\u001dy\u0006A1A\u0005\n-Ca\u0001\u0019\u0001!\u0002\u0013a\u0005bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007W\u0002\u0001\u000b\u0011B2\t\u000f1\u0004!\u0019!C\u0005E\"1Q\u000e\u0001Q\u0001\n\rDqA\u001c\u0001C\u0002\u0013%!\r\u0003\u0004p\u0001\u0001\u0006Ia\u0019\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019)\b\u0001)A\u0005e\"9a\u000f\u0001b\u0001\n\u00139\bBB>\u0001A\u0003%\u0001\u0010C\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u0005\r\u0001\u0001)A\u0005}\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\t9\u0003\u0001C!\u0003SAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!9\u0011Q\n\u0001\u0005B\u0005=#!\u0007)sK\u001aL\u0007pS3z'\u000e\fgn\u0015;bi\u0016,enY8eKJT!a\b\u0011\u0002\u000bM$\u0018\r^3\u000b\u0005\u0005\u0012\u0013!C:ue\u0016\fW.\u001b8h\u0015\t\u0019C%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g!\t)d'D\u0001\u001f\u0013\t9dDA\nS_\u000e\\7\u000f\u0012\"Ti\u0006$X-\u00128d_\u0012,'/A\u0005lKf\u001c6\r[3nCB\u0011!(P\u0007\u0002w)\u0011A\bJ\u0001\u0006if\u0004Xm]\u0005\u0003}m\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003-1\u0018\r\\;f'\u000eDW-\\1\u0002!9,XnQ8mgB\u0013XMZ5y\u0017\u0016L\bCA\u0018C\u0013\t\u0019\u0005GA\u0002J]R\fa\u0001P5oSRtD\u0003\u0002$H\u0011&\u0003\"!\u000e\u0001\t\u000ba\"\u0001\u0019A\u001d\t\u000b}\"\u0001\u0019A\u001d\t\u000b\u0001#\u0001\u0019A!\u0002-A\u0014XMZ5y\u0017\u0016Lh)[3mIN<\u0016\u000e\u001e5JIb,\u0012\u0001\u0014\t\u0004\u001bVCfB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\tF&\u0001\u0004=e>|GOP\u0005\u0002c%\u0011A\u000bM\u0001\ba\u0006\u001c7.Y4f\u0013\t1vKA\u0002TKFT!\u0001\u0016\u0019\u0011\t=J6,Q\u0005\u00035B\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u001e]\u0013\ti6HA\u0006TiJ,8\r\u001e$jK2$\u0017a\u00069sK\u001aL\u0007pS3z\r&,G\u000eZ:XSRD\u0017\n\u001a=!\u0003e\u0011X-\\1j]&twmS3z\r&,G\u000eZ:XSRD\u0017\n\u001a=\u00025I,W.Y5oS:<7*Z=GS\u0016dGm],ji\"LE\r\u001f\u0011\u0002'A\u0014XMZ5y\u0017\u0016L\bK]8kK\u000e$\u0018n\u001c8\u0016\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Q\u0012\n\u0001bY1uC2L8\u000f^\u0005\u0003U\u0016\u0014\u0001#\u00168tC\u001a,\u0007K]8kK\u000e$\u0018n\u001c8\u0002)A\u0014XMZ5y\u0017\u0016L\bK]8kK\u000e$\u0018n\u001c8!\u0003Y\u0011X-\\1j]&twmS3z!J|'.Z2uS>t\u0017a\u0006:f[\u0006Lg.\u001b8h\u0017\u0016L\bK]8kK\u000e$\u0018n\u001c8!\u0003Q\u0011Xm\u001d;pe\u0016\\U-\u001f)s_*,7\r^5p]\u0006)\"/Z:u_J,7*Z=Qe>TWm\u0019;j_:\u0004\u0013A\u00046pS:,GMU8x\u001f:\\U-_\u000b\u0002eB\u0011Am]\u0005\u0003i\u0016\u0014\u0011BS8j]\u0016$'k\\<\u0002\u001f)|\u0017N\\3e%><xJ\\&fs\u0002\n\u0001B^1mk\u0016\u0014vn^\u000b\u0002qB\u0011A-_\u0005\u0003u\u0016\u0014\u0011\"\u00168tC\u001a,'k\\<\u0002\u0013Y\fG.^3S_^\u0004\u0013\u0001\u0003:poR+\b\u000f\\3\u0016\u0003y\u0004\"!N@\n\u0007\u0005\u0005aDA\u0007V]N\fg-\u001a*poB\u000b\u0017N]\u0001\ne><H+\u001e9mK\u0002\n\u0011\"\u001a8d_\u0012,7*Z=\u0015\t\u0005%\u0011Q\u0003\t\u0006_\u0005-\u0011qB\u0005\u0004\u0003\u001b\u0001$!B!se\u0006L\bcA\u0018\u0002\u0012%\u0019\u00111\u0003\u0019\u0003\t\tKH/\u001a\u0005\u0007\u0003/)\u0002\u0019\u0001=\u0002\u0007I|w/A\u0006f]\u000e|G-\u001a,bYV,G\u0003BA\u0005\u0003;Aa!a\u0006\u0017\u0001\u0004A\u0018!\u00033fG>$WmS3z)\rA\u00181\u0005\u0005\b\u0003K9\u0002\u0019AA\u0005\u0003!YW-\u001f\"zi\u0016\u001c\u0018a\u00033fG>$WMV1mk\u0016$2\u0001_A\u0016\u0011\u001d\ti\u0003\u0007a\u0001\u0003\u0013\t!B^1mk\u0016\u0014\u0015\u0010^3t\u0003A)\u0007\u0010\u001e:bGR\u0004&/\u001a4jq.+\u0017\u0010F\u0002y\u0003gAa!!\u000e\u001a\u0001\u0004A\u0018aA6fs\u0006yQM\\2pI\u0016\u0004&/\u001a4jq.+\u0017\u0010\u0006\u0003\u0002\n\u0005m\u0002BBA\u001f5\u0001\u0007\u00010A\u0005qe\u00164\u0017\u000e_&fs\u00061A-Z2pI\u0016$2A`A\"\u0011\u001d\t)e\u0007a\u0001\u0003\u000f\naBY=uK\u0006\u0013(/Y=UkBdW\rE\u00026\u0003\u0013J1!a\u0013\u001f\u00055\u0011\u0015\u0010^3BeJ\f\u0017\u0010U1je\u0006!2/\u001e9q_J$\bK]3gSb\\U-_*dC:,\"!!\u0015\u0011\u0007=\n\u0019&C\u0002\u0002VA\u0012qAQ8pY\u0016\fg\u000e")
public class PrefixKeyScanStateEncoder
implements RocksDBStateEncoder {
    private final StructType keySchema;
    private final int numColsPrefixKey;
    private final Seq<Tuple2<StructField, Object>> prefixKeyFieldsWithIdx;
    private final Seq<Tuple2<StructField, Object>> remainingKeyFieldsWithIdx;
    private final UnsafeProjection prefixKeyProjection;
    private final UnsafeProjection remainingKeyProjection;
    private final UnsafeProjection restoreKeyProjection;
    private final JoinedRow joinedRowOnKey;
    private final UnsafeRow valueRow;
    private final UnsafeRowPair rowTuple;

    private Seq<Tuple2<StructField, Object>> prefixKeyFieldsWithIdx() {
        return this.prefixKeyFieldsWithIdx;
    }

    private Seq<Tuple2<StructField, Object>> remainingKeyFieldsWithIdx() {
        return this.remainingKeyFieldsWithIdx;
    }

    private UnsafeProjection prefixKeyProjection() {
        return this.prefixKeyProjection;
    }

    private UnsafeProjection remainingKeyProjection() {
        return this.remainingKeyProjection;
    }

    private UnsafeProjection restoreKeyProjection() {
        return this.restoreKeyProjection;
    }

    private JoinedRow joinedRowOnKey() {
        return this.joinedRowOnKey;
    }

    private UnsafeRow valueRow() {
        return this.valueRow;
    }

    private UnsafeRowPair rowTuple() {
        return this.rowTuple;
    }

    @Override
    public byte[] encodeKey(UnsafeRow row) {
        byte[] prefixKeyEncoded = RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(this.extractPrefixKey(row));
        byte[] remainingEncoded = RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(this.remainingKeyProjection().apply((InternalRow)row));
        byte[] encodedBytes = new byte[prefixKeyEncoded.length + remainingEncoded.length + 4];
        Platform.putInt((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)prefixKeyEncoded.length);
        Platform.copyMemory((Object)prefixKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (long)prefixKeyEncoded.length);
        Platform.copyMemory((Object)remainingEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4 + prefixKeyEncoded.length), (long)remainingEncoded.length);
        return encodedBytes;
    }

    @Override
    public byte[] encodeValue(UnsafeRow row) {
        return RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(row);
    }

    @Override
    public UnsafeRow decodeKey(byte[] keyBytes) {
        int prefixKeyEncodedLen = Platform.getInt((Object)keyBytes, (long)Platform.BYTE_ARRAY_OFFSET);
        byte[] prefixKeyEncoded = new byte[prefixKeyEncodedLen];
        Platform.copyMemory((Object)keyBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (Object)prefixKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (long)prefixKeyEncodedLen);
        int remainingKeyEncodedLen = keyBytes.length - 4 - prefixKeyEncodedLen;
        byte[] remainingKeyEncoded = new byte[remainingKeyEncodedLen];
        Platform.copyMemory((Object)keyBytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4 + prefixKeyEncodedLen), (Object)remainingKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (long)remainingKeyEncodedLen);
        UnsafeRow prefixKeyDecoded = RocksDBStateEncoder$.MODULE$.decodeToUnsafeRow(prefixKeyEncoded, this.numColsPrefixKey);
        UnsafeRow remainingKeyDecoded = RocksDBStateEncoder$.MODULE$.decodeToUnsafeRow(remainingKeyEncoded, this.keySchema.length() - this.numColsPrefixKey);
        return this.restoreKeyProjection().apply((InternalRow)this.joinedRowOnKey().withLeft((InternalRow)prefixKeyDecoded).withRight((InternalRow)remainingKeyDecoded));
    }

    @Override
    public UnsafeRow decodeValue(byte[] valueBytes) {
        return RocksDBStateEncoder$.MODULE$.decodeToUnsafeRow(valueBytes, this.valueRow());
    }

    @Override
    public UnsafeRow extractPrefixKey(UnsafeRow key) {
        return this.prefixKeyProjection().apply((InternalRow)key);
    }

    @Override
    public byte[] encodePrefixKey(UnsafeRow prefixKey) {
        byte[] prefixKeyEncoded = RocksDBStateEncoder$.MODULE$.encodeUnsafeRow(prefixKey);
        byte[] prefix = new byte[prefixKeyEncoded.length + 4];
        Platform.putInt((Object)prefix, (long)Platform.BYTE_ARRAY_OFFSET, (int)prefixKeyEncoded.length);
        Platform.copyMemory((Object)prefixKeyEncoded, (long)Platform.BYTE_ARRAY_OFFSET, (Object)prefix, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (long)prefixKeyEncoded.length);
        return prefix;
    }

    @Override
    public UnsafeRowPair decode(ByteArrayPair byteArrayTuple) {
        return this.rowTuple().withRows(this.decodeKey(byteArrayTuple.key()), this.decodeValue(byteArrayTuple.value()));
    }

    @Override
    public boolean supportPrefixKeyScan() {
        return true;
    }

    public PrefixKeyScanStateEncoder(StructType keySchema, StructType valueSchema, int numColsPrefixKey) {
        this.keySchema = keySchema;
        this.numColsPrefixKey = numColsPrefixKey;
        Predef$.MODULE$.require(keySchema.length() > numColsPrefixKey, (Function0 & Serializable & scala.Serializable)() -> "The number of columns in the key must be greater than the number of columns for prefix key!");
        this.prefixKeyFieldsWithIdx = (Seq)((IterableLike)keySchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).take(numColsPrefixKey);
        this.remainingKeyFieldsWithIdx = (Seq)((IterableLike)keySchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).drop(numColsPrefixKey);
        Seq refs = (Seq)this.prefixKeyFieldsWithIdx().map((Function1 & Serializable & scala.Serializable)x -> new BoundReference(x._2$mcI$sp(), ((StructField)x._1()).dataType(), ((StructField)x._1()).nullable()), Seq$.MODULE$.canBuildFrom());
        this.prefixKeyProjection = UnsafeProjection$.MODULE$.create(refs);
        Seq refs2 = (Seq)this.remainingKeyFieldsWithIdx().map((Function1 & Serializable & scala.Serializable)x -> new BoundReference(x._2$mcI$sp(), ((StructField)x._1()).dataType(), ((StructField)x._1()).nullable()), Seq$.MODULE$.canBuildFrom());
        this.remainingKeyProjection = UnsafeProjection$.MODULE$.create(refs2);
        this.restoreKeyProjection = UnsafeProjection$.MODULE$.create(keySchema);
        this.joinedRowOnKey = new JoinedRow();
        this.valueRow = new UnsafeRow(valueSchema.size());
        this.rowTuple = new UnsafeRowPair(UnsafeRowPair$.MODULE$.$lessinit$greater$default$1(), UnsafeRowPair$.MODULE$.$lessinit$greater$default$2());
    }
}

