/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import org.apache.spark.util.SparkExitCode$;

public final class ExecutorExitCode$ {
    public static ExecutorExitCode$ MODULE$;
    private final int DISK_STORE_FAILED_TO_CREATE_DIR;
    private final int EXTERNAL_BLOCK_STORE_FAILED_TO_INITIALIZE;
    private final int EXTERNAL_BLOCK_STORE_FAILED_TO_CREATE_DIR;
    private final int HEARTBEAT_FAILURE;

    static {
        new ExecutorExitCode$();
    }

    public int DISK_STORE_FAILED_TO_CREATE_DIR() {
        return this.DISK_STORE_FAILED_TO_CREATE_DIR;
    }

    public int EXTERNAL_BLOCK_STORE_FAILED_TO_INITIALIZE() {
        return this.EXTERNAL_BLOCK_STORE_FAILED_TO_INITIALIZE;
    }

    public int EXTERNAL_BLOCK_STORE_FAILED_TO_CREATE_DIR() {
        return this.EXTERNAL_BLOCK_STORE_FAILED_TO_CREATE_DIR;
    }

    public int HEARTBEAT_FAILURE() {
        return this.HEARTBEAT_FAILURE;
    }

    public String explainExitCode(int exitCode) {
        int n = exitCode;
        if (SparkExitCode$.MODULE$.UNCAUGHT_EXCEPTION() == n) {
            return "Uncaught exception";
        }
        if (SparkExitCode$.MODULE$.UNCAUGHT_EXCEPTION_TWICE() == n) {
            return "Uncaught exception, and logging the exception failed";
        }
        if (SparkExitCode$.MODULE$.OOM() == n) {
            return "OutOfMemoryError";
        }
        if (this.DISK_STORE_FAILED_TO_CREATE_DIR() == n) {
            return "Failed to create local directory (bad spark.local.dir?)";
        }
        if (this.EXTERNAL_BLOCK_STORE_FAILED_TO_INITIALIZE() == n) {
            return "ExternalBlockStore failed to initialize.";
        }
        if (this.EXTERNAL_BLOCK_STORE_FAILED_TO_CREATE_DIR() == n) {
            return "ExternalBlockStore failed to create a local temporary directory.";
        }
        if (this.HEARTBEAT_FAILURE() == n) {
            return "Unable to send heartbeats to driver.";
        }
        return new StringBuilder(29).append("Unknown executor exit code (").append(exitCode).append(")").append((Object)(exitCode > 128 ? new StringBuilder(21).append(" (died from signal ").append(exitCode - 128).append("?)").toString() : "")).toString();
    }

    private ExecutorExitCode$() {
        MODULE$ = this;
        this.DISK_STORE_FAILED_TO_CREATE_DIR = 53;
        this.EXTERNAL_BLOCK_STORE_FAILED_TO_INITIALIZE = 54;
        this.EXTERNAL_BLOCK_STORE_FAILED_TO_CREATE_DIR = 55;
        this.HEARTBEAT_FAILURE = 56;
    }
}

