/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.executor.ExecutorLogUrlHandler$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001I4Q!\u0004\b\u0001!YA\u0001b\t\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006g\u0001!\t\u0001\u000e\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u00191\u0005\u0001)A\u0005u!)q\t\u0001C\u0001\u0011\")\u0001\u000b\u0001C\u0005#\")a\u000b\u0001C\u0005/\u001e1AM\u0004E\u0001!\u00154a!\u0004\b\t\u0002A1\u0007\"B\u001a\n\t\u00039\u0007b\u00025\n\u0005\u0004%\t!\u001b\u0005\u0007c&\u0001\u000b\u0011\u00026\u0003+\u0015CXmY;u_JdunZ+sY\"\u000bg\u000e\u001a7fe*\u0011q\u0002E\u0001\tKb,7-\u001e;pe*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xmE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0011\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0012 \u0005\u001daunZ4j]\u001e\fQ\u0002\\8h+Jd\u0007+\u0019;uKJt7\u0001\u0001\t\u00041\u0019B\u0013BA\u0014\u001a\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u0006\r\b\u0003U9\u0002\"aK\r\u000e\u00031R!!\f\u0013\u0002\rq\u0012xn\u001c;?\u0013\ty\u0013$\u0001\u0004Qe\u0016$WMZ\u0005\u0003cI\u0012aa\u0015;sS:<'BA\u0018\u001a\u0003\u0019a\u0014N\\5u}Q\u0011Qg\u000e\t\u0003m\u0001i\u0011A\u0004\u0005\u0006G\t\u0001\r!J\u0001\u001dS:4wN]7fI\u001a{'/T5tg&tw-\u0011;ue&\u0014W\u000f^3t+\u0005Q\u0004CA\u001eE\u001b\u0005a$BA\u001f?\u0003\u0019\tGo\\7jG*\u0011q\bQ\u0001\u000bG>t7-\u001e:sK:$(BA!C\u0003\u0011)H/\u001b7\u000b\u0003\r\u000bAA[1wC&\u0011Q\t\u0010\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002;%tgm\u001c:nK\u00124uN]'jgNLgnZ!uiJL'-\u001e;fg\u0002\nA\"\u00199qYf\u0004\u0016\r\u001e;fe:$2!\u0013'O!\u0011I#\n\u000b\u0015\n\u0005-\u0013$aA'ba\")Q*\u0002a\u0001\u0013\u00069An\\4Ve2\u001c\b\"B(\u0006\u0001\u0004I\u0015AC1uiJL'-\u001e;fg\u0006qAm\\!qa2L\b+\u0019;uKJtG\u0003B%S'RCQ!\u0014\u0004A\u0002%CQa\u0014\u0004A\u0002%CQ!\u0016\u0004A\u0002!\n!\"\u001e:m!\u0006$H/\u001a:o\u0003Uawn\u001a$bS2$vNU3oK^dunZ+sYN$B\u0001W.^EB\u0011\u0001$W\u0005\u00035f\u0011A!\u00168ji\")Al\u0002a\u0001Q\u00051!/Z1t_:DQAX\u0004A\u0002}\u000b1\"\u00197m!\u0006$H/\u001a:ogB\u0019\u0011\u0006\u0019\u0015\n\u0005\u0005\u0014$aA*fi\")1m\u0002a\u0001?\u0006i\u0011\r\u001c7BiR\u0014\u0018NY;uKN\fQ#\u0012=fGV$xN\u001d'pOV\u0013H\u000eS1oI2,'\u000f\u0005\u00027\u0013M\u0011\u0011b\u0006\u000b\u0002K\u0006A2)V*U\u001f6{VK\u0015'`!\u0006#F+\u0012*O?J+u)\u0012-\u0016\u0003)\u0004\"a[8\u000e\u00031T!!\u001c8\u0002\u00115\fGo\u00195j]\u001eT!!Q\r\n\u0005Ad'!\u0002*fO\u0016D\u0018!G\"V'R{UjX+S\u0019~\u0003\u0016\t\u0016+F%:{&+R$F1\u0002\u0002")
public class ExecutorLogUrlHandler
implements Logging {
    private final Option<String> logUrlPattern;
    private final AtomicBoolean informedForMissingAttributes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Regex CUSTOM_URL_PATTERN_REGEX() {
        return ExecutorLogUrlHandler$.MODULE$.CUSTOM_URL_PATTERN_REGEX();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicBoolean informedForMissingAttributes() {
        return this.informedForMissingAttributes;
    }

    public Map<String, String> applyPattern(Map<String, String> logUrls, Map<String, String> attributes) {
        Option<String> option = this.logUrlPattern;
        if (option instanceof Some) {
            Some some = (Some)option;
            String pattern = (String)some.value();
            return this.doApplyPattern(logUrls, attributes, pattern);
        }
        if (None$.MODULE$.equals(option)) {
            return logUrls;
        }
        throw new MatchError(option);
    }

    private Map<String, String> doApplyPattern(Map<String, String> logUrls, Map<String, String> attributes, String urlPattern) {
        Set allAttributeKeys;
        Set allAttributeKeysExceptLogFiles;
        Set allPatterns = ExecutorLogUrlHandler$.MODULE$.CUSTOM_URL_PATTERN_REGEX().findAllMatchIn((CharSequence)urlPattern).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.group(1)).toSet();
        Set allPatternsExceptFileName = (Set)allPatterns.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorLogUrlHandler.$anonfun$doApplyPattern$2(x$2)));
        if (allPatternsExceptFileName.diff((GenSet)(allAttributeKeysExceptLogFiles = (Set)(allAttributeKeys = attributes.keySet()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExecutorLogUrlHandler.$anonfun$doApplyPattern$3(x$3))))).nonEmpty()) {
            this.logFailToRenewLogUrls("some of required attributes are missing in app's event log.", (Set<String>)allPatternsExceptFileName, (Set<String>)allAttributeKeys);
            return logUrls;
        }
        if (allPatterns.contains((Object)"FILE_NAME") && !allAttributeKeys.contains((Object)"LOG_FILES")) {
            this.logFailToRenewLogUrls("'FILE_NAME' parameter is provided, but file information is missing in app's event log.", (Set<String>)allPatternsExceptFileName, (Set<String>)allAttributeKeys);
            return logUrls;
        }
        String updatedUrl = (String)allPatternsExceptFileName.foldLeft((Object)urlPattern, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String orig = (String)tuple2._1();
                String patt = (String)tuple2._2();
                return orig.replace(new StringBuilder(4).append("{{").append(patt).append("}}").toString(), (CharSequence)attributes.apply((Object)patt));
            }
            throw new MatchError((Object)tuple2);
        });
        if (allPatterns.contains((Object)"FILE_NAME")) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)attributes.apply((Object)"LOG_FILES")).split(","))).map((Function1 & Serializable & scala.Serializable)file -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(file), (Object)updatedUrl.replace("{{FILE_NAME}}", (CharSequence)file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log"), (Object)updatedUrl)}));
    }

    private void logFailToRenewLogUrls(String reason, Set<String> allPatterns, Set<String> allAttributes) {
        if (this.informedForMissingAttributes().compareAndSet(false, true)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(106).append("Fail to renew executor log urls: ").append(reason).append(". Required: ").append(allPatterns).append(" / ").append("available: ").append(allAttributes).append(". Falling back to show app's original log urls.").toString());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$doApplyPattern$2(String x$2) {
        String string = x$2;
        String string2 = "FILE_NAME";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$doApplyPattern$3(String x$3) {
        String string = x$3;
        String string2 = "LOG_FILES";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public ExecutorLogUrlHandler(Option<String> logUrlPattern) {
        this.logUrlPattern = logUrlPattern;
        Logging.$init$((Logging)this);
        this.informedForMissingAttributes = new AtomicBoolean(false);
    }
}

