/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.orc.OrcFiltersBase;
import org.apache.spark.sql.execution.datasources.orc.OrcFiltersBase$OrcPrimitiveField$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Not$;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class OrcFilters$
implements OrcFiltersBase {
    public static final OrcFilters$ MODULE$ = new OrcFilters$();
    private static volatile OrcFiltersBase$OrcPrimitiveField$ OrcPrimitiveField$module;

    static {
        OrcFiltersBase.$init$(MODULE$);
    }

    @Override
    public Option<Filter> buildTree(Seq<Filter> filters) {
        return OrcFiltersBase.buildTree$(this, filters);
    }

    @Override
    public Map<String, OrcFiltersBase.OrcPrimitiveField> getSearchableTypeMap(StructType schema, boolean caseSensitive) {
        return OrcFiltersBase.getSearchableTypeMap$(this, schema, caseSensitive);
    }

    @Override
    public OrcFiltersBase$OrcPrimitiveField$ OrcPrimitiveField() {
        if (OrcPrimitiveField$module == null) {
            this.OrcPrimitiveField$lzycompute$1();
        }
        return OrcPrimitiveField$module;
    }

    public Option<SearchArgument> createFilter(StructType schema, Seq<Filter> filters) {
        Map<String, OrcFiltersBase.OrcPrimitiveField> dataTypeMap = this.getSearchableTypeMap(schema, SQLConf$.MODULE$.get().caseSensitiveAnalysis());
        Option<Filter> conjunctionOptional = this.buildTree(this.convertibleFilters(dataTypeMap, filters));
        return conjunctionOptional.map((Function1 & Serializable)conjunction -> MODULE$.buildSearchArgument(dataTypeMap, (Filter)conjunction, SearchArgumentFactory.newBuilder()).build());
    }

    public Seq<Filter> convertibleFilters(Map<String, OrcFiltersBase.OrcPrimitiveField> dataTypeMap, Seq<Filter> filters) {
        return (Seq)filters.flatMap((Function1 & Serializable)filter -> this.convertibleFiltersHelper$1((Filter)filter, true, (Map)dataTypeMap));
    }

    public PredicateLeaf.Type getPredicateLeafType(DataType dataType) {
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return PredicateLeaf.Type.BOOLEAN;
        }
        if (ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (dataType2 instanceof AnsiIntervalType ? true : TimestampNTZType$.MODULE$.equals(dataType2)))))) {
            return PredicateLeaf.Type.LONG;
        }
        if (FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2)) {
            return PredicateLeaf.Type.FLOAT;
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return PredicateLeaf.Type.STRING;
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return PredicateLeaf.Type.DATE;
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return PredicateLeaf.Type.TIMESTAMP;
        }
        if (dataType2 instanceof DecimalType) {
            return PredicateLeaf.Type.DECIMAL;
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedOperationForDataTypeError(dataType);
    }

    private Object castLiteralValue(Object value, DataType dataType) {
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2)))) {
            return BoxesRunTime.boxToLong((long)((Number)value).longValue());
        }
        if (FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToDouble((double)((Number)value).doubleValue());
        }
        if (dataType2 instanceof DecimalType) {
            return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)value)));
        }
        if (dataType2 instanceof DateType && value instanceof LocalDate) {
            return DateTimeUtils$.MODULE$.toJavaDate(DateTimeUtils$.MODULE$.localDateToDays((LocalDate)value));
        }
        if (dataType2 instanceof TimestampType && value instanceof Instant) {
            return DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.instantToMicros((Instant)value));
        }
        if (dataType2 instanceof TimestampNTZType && value instanceof LocalDateTime) {
            return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros((LocalDateTime)value));
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            return BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.periodToMonths((Period)value));
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            return BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros((Duration)value));
        }
        return value;
    }

    private SearchArgument.Builder buildSearchArgument(Map<String, OrcFiltersBase.OrcPrimitiveField> dataTypeMap, Filter expression, SearchArgument.Builder builder) {
        Filter filter = expression;
        if (filter instanceof And) {
            And and = (And)filter;
            Filter left = and.left();
            Filter right = and.right();
            SearchArgument.Builder lhs = this.buildSearchArgument(dataTypeMap, left, builder.startAnd());
            SearchArgument.Builder rhs = this.buildSearchArgument(dataTypeMap, right, lhs);
            return rhs.end();
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            Filter left = or.left();
            Filter right = or.right();
            SearchArgument.Builder lhs = this.buildSearchArgument(dataTypeMap, left, builder.startOr());
            SearchArgument.Builder rhs = this.buildSearchArgument(dataTypeMap, right, lhs);
            return rhs.end();
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            Filter child = not.child();
            return this.buildSearchArgument(dataTypeMap, child, builder.startNot()).end();
        }
        return (SearchArgument.Builder)this.buildLeafSearchArgument(dataTypeMap, filter, builder).getOrElse((Function0 & Serializable)() -> {
            throw QueryExecutionErrors$.MODULE$.inputFilterNotFullyConvertibleError("OrcFilters.buildSearchArgument");
        });
    }

    private Option<SearchArgument.Builder> buildLeafSearchArgument(Map<String, OrcFiltersBase.OrcPrimitiveField> dataTypeMap, Filter expression, SearchArgument.Builder builder) {
        IsNotNull isNotNull;
        String name;
        IsNull isNull;
        String name2;
        Filter filter = expression;
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            String name3 = equalTo.attribute();
            Object value = equalTo.value();
            if (dataTypeMap.contains((Object)name3)) {
                Object castedValue = this.castLiteralValue(value, ((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name3)).fieldType());
                return new Some((Object)builder.startAnd().equals(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name3)).fieldName(), this.getType$1(name3, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            String name4 = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            if (dataTypeMap.contains((Object)name4)) {
                Object castedValue = this.castLiteralValue(value, ((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name4)).fieldType());
                return new Some((Object)builder.startAnd().nullSafeEquals(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name4)).fieldName(), this.getType$1(name4, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            String name5 = lessThan.attribute();
            Object value = lessThan.value();
            if (dataTypeMap.contains((Object)name5)) {
                Object castedValue = this.castLiteralValue(value, ((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name5)).fieldType());
                return new Some((Object)builder.startAnd().lessThan(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name5)).fieldName(), this.getType$1(name5, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            String name6 = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            if (dataTypeMap.contains((Object)name6)) {
                Object castedValue = this.castLiteralValue(value, ((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name6)).fieldType());
                return new Some((Object)builder.startAnd().lessThanEquals(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name6)).fieldName(), this.getType$1(name6, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            String name7 = greaterThan.attribute();
            Object value = greaterThan.value();
            if (dataTypeMap.contains((Object)name7)) {
                Object castedValue = this.castLiteralValue(value, ((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name7)).fieldType());
                return new Some((Object)builder.startNot().lessThanEquals(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name7)).fieldName(), this.getType$1(name7, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            String name8 = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            if (dataTypeMap.contains((Object)name8)) {
                Object castedValue = this.castLiteralValue(value, ((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name8)).fieldType());
                return new Some((Object)builder.startNot().lessThan(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name8)).fieldName(), this.getType$1(name8, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof IsNull && dataTypeMap.contains((Object)(name2 = (isNull = (IsNull)filter).attribute()))) {
            return new Some((Object)builder.startAnd().isNull(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name2)).fieldName(), this.getType$1(name2, dataTypeMap)).end());
        }
        if (filter instanceof IsNotNull && dataTypeMap.contains((Object)(name = (isNotNull = (IsNotNull)filter).attribute()))) {
            return new Some((Object)builder.startNot().isNull(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name)).fieldName(), this.getType$1(name, dataTypeMap)).end());
        }
        if (filter instanceof In) {
            In in = (In)filter;
            String name9 = in.attribute();
            Object[] values = in.values();
            if (dataTypeMap.contains((Object)name9)) {
                Object[] castedValues = (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)values), (Function1 & Serializable)v -> MODULE$.castLiteralValue(v, ((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name9)).fieldType()), ClassTag$.MODULE$.Any());
                return new Some((Object)builder.startAnd().in(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap.apply((Object)name9)).fieldName(), this.getType$1(name9, dataTypeMap), (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)castedValues), (Function1 & Serializable)x$2 -> x$2, ClassTag$.MODULE$.AnyRef())).end());
            }
        }
        return None$.MODULE$;
    }

    private final void OrcPrimitiveField$lzycompute$1() {
        OrcFilters$ orcFilters$ = this;
        synchronized (orcFilters$) {
            if (OrcPrimitiveField$module == null) {
                OrcPrimitiveField$module = new OrcFiltersBase$OrcPrimitiveField$(this);
            }
        }
    }

    private final Option convertibleFiltersHelper$1(Filter filter, boolean canPartialPushDown, Map dataTypeMap$2) {
        Filter filter2 = filter;
        if (filter2 instanceof And) {
            Option rightResultOptional;
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            Option leftResultOptional = this.convertibleFiltersHelper$1(left, canPartialPushDown, dataTypeMap$2);
            Tuple2 tuple2 = new Tuple2((Object)leftResultOptional, (Object)(rightResultOptional = this.convertibleFiltersHelper$1(right, canPartialPushDown, dataTypeMap$2)));
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Filter leftResult = (Filter)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Filter rightResult = (Filter)some2.value();
                        return new Some((Object)new And(leftResult, rightResult));
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Filter leftResult = (Filter)some.value();
                    if (None$.MODULE$.equals(option3) && canPartialPushDown) {
                        return new Some((Object)leftResult);
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                    Some some = (Some)option4;
                    Filter rightResult = (Filter)some.value();
                    if (canPartialPushDown) {
                        return new Some((Object)rightResult);
                    }
                }
            }
            return None$.MODULE$;
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            return this.convertibleFiltersHelper$1(left, canPartialPushDown, dataTypeMap$2).flatMap((Function1 & Serializable)lhs -> this.convertibleFiltersHelper$1(right, canPartialPushDown, dataTypeMap$2).map((Function1 & Serializable)rhs -> new Or(lhs, rhs)));
        }
        if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter pred = not.child();
            Option childResultOptional = this.convertibleFiltersHelper$1(pred, false, dataTypeMap$2);
            return childResultOptional.map((Function1)Not$.MODULE$);
        }
        return this.buildLeafSearchArgument((Map<String, OrcFiltersBase.OrcPrimitiveField>)dataTypeMap$2, filter2, SearchArgumentFactory.newBuilder()).map((Function1 & Serializable)x$1 -> {
            SearchArgument.Builder builder = x$1;
            return filter2;
        });
    }

    private final PredicateLeaf.Type getType$1(String attribute, Map dataTypeMap$3) {
        return this.getPredicateLeafType(((OrcFiltersBase.OrcPrimitiveField)dataTypeMap$3.apply((Object)attribute)).fieldType());
    }

    private OrcFilters$() {
    }
}

