/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.checkpointing;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.checkpointing.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.checkpointing.MetadataLog;
import org.apache.spark.sql.execution.streaming.checkpointing.MetadataVersionUtil$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001dg\u0001B\u00193\u0001\u0005C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"AA\u000e\u0001B\u0002B\u0003-Q\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0004{\u0001\t\u0007I1B>\t\u000f\u0005\u0015\u0001\u0001)A\u0005y\"I\u0011q\u0001\u0001C\u0002\u0013-\u0011\u0011\u0002\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011\u0011\u0006\u0001C\u0002\u0013E\u00111\u0006\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002.!I\u0011Q\u0007\u0001C\u0002\u0013E\u0011q\u0007\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002:!Q\u0011\u0011\t\u0001C\u0002\u0013E\u0001(a\u0011\t\u0011\u0005m\u0003\u0001)A\u0005\u0003\u000bB\u0011\"!\u0018\u0001\u0005\u0004%\t\"a\u0018\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003CBq!a\u001f\u0001\t#\ti\bC\u0004\u0002\u0004\u0002!\t\"!\"\t\u000f\u0005%\u0005\u0001\"\u0005\u0002\f\"9\u0011q\u0012\u0001\u0005\u0012\u0005E\u0005bBAW\u0001\u0011E\u0011q\u0016\u0005\b\u0003w\u0003A\u0011IA_\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bDq!a4\u0001\t\u0003\t\t\u000eC\u0004\u0002X\u0002!\t!!7\t\u0013\u0005u\b!%A\u0005\u0002\u0005}\bb\u0002B\r\u0001\u0011E!1\u0004\u0005\b\u0005K\u0001A\u0011\u0001B\u0014\u0011\u001d\u0011y\u0003\u0001C\u0005\u0005cAq!a1\u0001\t\u0003\u0012)\u0004C\u0004\u0003L\u0001!\tA!\u0014\t\u000f\t=\u0003\u0001\"\u0011\u0003R!9!Q\u000b\u0001\u0005\u0002\t]\u0003\"\u0003B1\u0001\u0001\u0007I\u0011\u0002B2\u0011%\u0011)\u0007\u0001a\u0001\n\u0013\u00119\u0007\u0003\u0005\u0003n\u0001\u0001\u000b\u0015BA+\u0011\u001d\u0011y\u0007\u0001C!\u0005cBqAa\u001e\u0001\t\u0003\u0011I\bC\u0004\u0003~\u0001!\tBa \t\u000f\t\r\u0005\u0001\"\u0001\u0003\u0000!A!Q\u0011\u0001\u0005\u0002a\u00129\t\u0003\u0005\u0003\u0018\u0002!\t\u0001\u000fBM\u000f\u001d\u0011\tK\rE\u0001\u0005G3a!\r\u001a\t\u0002\t\u0015\u0006BB:/\t\u0003\u00119\u000bC\u0004\u0003*:\"\tAa+\u0003\u001f!#eiU'fi\u0006$\u0017\r^1M_\u001eT!a\r\u001b\u0002\u001b\rDWmY6q_&tG/\u001b8h\u0015\t)d'A\u0005tiJ,\u0017-\\5oO*\u0011q\u0007O\u0001\nKb,7-\u001e;j_:T!!\u000f\u001e\u0002\u0007M\fHN\u0003\u0002<y\u0005)1\u000f]1sW*\u0011QHP\u0001\u0007CB\f7\r[3\u000b\u0003}\n1a\u001c:h\u0007\u0001)\"AQ(\u0014\t\u0001\u0019\u0015*\u0016\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0007)[U*D\u00013\u0013\ta%GA\u0006NKR\fG-\u0019;b\u0019><\u0007C\u0001(P\u0019\u0001!Q\u0001\u0015\u0001C\u0002E\u0013\u0011\u0001V\t\u0003%\u000e\u0003\"\u0001R*\n\u0005Q+%a\u0002(pi\"Lgn\u001a\t\u0003-fk\u0011a\u0016\u0006\u00031j\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00035^\u0013q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002^=6\t\u0001(\u0003\u0002`q\ta1\u000b]1sWN+7o]5p]\u0006!\u0001/\u0019;i!\t\u0011\u0017N\u0004\u0002dOB\u0011A-R\u0007\u0002K*\u0011a\rQ\u0001\u0007yI|w\u000e\u001e \n\u0005!,\u0015A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001[#\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002oc6k\u0011a\u001c\u0006\u0003a\u0016\u000bqA]3gY\u0016\u001cG/\u0003\u0002s_\nA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\u0004kbLHC\u0001<x!\rQ\u0005!\u0014\u0005\u0006Y\u0012\u0001\u001d!\u001c\u0005\u00067\u0012\u0001\r\u0001\u0018\u0005\u0006A\u0012\u0001\r!Y\u0001\bM>\u0014X.\u0019;t+\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u0000}\u00051!n]8oiML1!a\u0001\u007f\u0005\u001d1uN]7biN\f\u0001BZ8s[\u0006$8\u000fI\u0001\t[\u0006t\u0017NZ3tiV\u0011\u00111\u0002\t\u0005]\u00065Q*C\u0002\u0002\u0010=\u0014\u0001\"T1oS\u001a,7\u000f^\u0001\n[\u0006t\u0017NZ3ti\u0002\nA\"\\3uC\u0012\fG/\u0019)bi\",\"!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005\u0011am\u001d\u0006\u0004\u0003Ca\u0014A\u00025bI>|\u0007/\u0003\u0003\u0002&\u0005m!\u0001\u0002)bi\"\fQ\"\\3uC\u0012\fG/\u0019)bi\"\u0004\u0013a\u00034jY\u0016l\u0015M\\1hKJ,\"!!\f\u0011\u0007)\u000by#C\u0002\u00022I\u0012Qc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'/\u0001\u0007gS2,W*\u00198bO\u0016\u0014\b%\u0001\u000bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z#oC\ndW\rZ\u000b\u0003\u0003s\u00012\u0001RA\u001e\u0013\r\ti$\u0012\u0002\b\u0005>|G.Z1o\u0003UiW\r^1eCR\f7)Y2iK\u0016s\u0017M\u00197fI\u0002\n!BY1uG\"\u001c\u0015m\u00195f+\t\t)\u0005E\u0004\u0002H\u0005E\u0013QK'\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\nA!\u001e;jY*\u0011\u0011qJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002T\u0005%#aA'baB\u0019A)a\u0016\n\u0007\u0005eSI\u0001\u0003M_:<\u0017a\u00032bi\u000eD7)Y2iK\u0002\n\u0001CY1uG\"4\u0015\u000e\\3t\r&dG/\u001a:\u0016\u0005\u0005\u0005$CBA2\u0003S\n)H\u0002\u0004\u0002fI\u0001\u0011\u0011\r\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\u0012E\u0006$8\r\u001b$jY\u0016\u001ch)\u001b7uKJ\u0004\u0003\u0003BA6\u0003cj!!!\u001c\u000b\t\u0005=\u0014QJ\u0001\u0005Y\u0006tw-\u0003\u0003\u0002t\u00055$AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002\u001a\u0005]\u0014\u0002BA=\u00037\u0011!\u0002U1uQ\u001aKG\u000e^3s\u00035\u0011\u0017\r^2i\u0013\u0012$v\u000eU1uQR!\u0011qCA@\u0011\u001d\t\ti\u0005a\u0001\u0003+\nqAY1uG\"LE-A\u0007qCRDGk\u001c\"bi\u000eD\u0017\n\u001a\u000b\u0005\u0003+\n9\t\u0003\u0004a)\u0001\u0007\u0011qC\u0001\fSN\u0014\u0015\r^2i\r&dW\r\u0006\u0003\u0002:\u00055\u0005B\u00021\u0016\u0001\u0004\t9\"A\u0005tKJL\u0017\r\\5{KR1\u00111SAM\u0003;\u00032\u0001RAK\u0013\r\t9*\u0012\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u001cZ\u0001\r!T\u0001\t[\u0016$\u0018\rZ1uC\"9\u0011q\u0014\fA\u0002\u0005\u0005\u0016aA8viB!\u00111UAU\u001b\t\t)K\u0003\u0003\u0002(\u00065\u0013AA5p\u0013\u0011\tY+!*\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\u001b\u0006E\u0006bBAZ/\u0001\u0007\u0011QW\u0001\u0003S:\u0004B!a)\u00028&!\u0011\u0011XAS\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u0007\u0005$G\r\u0006\u0004\u0002:\u0005}\u0016\u0011\u0019\u0005\b\u0003\u0003C\u0002\u0019AA+\u0011\u0019\tY\n\u0007a\u0001\u001b\u0006\u0019q-\u001a;\u0015\t\u0005\u001d\u0017Q\u001a\t\u0005\t\u0006%W*C\u0002\u0002L\u0016\u0013aa\u00149uS>t\u0007bBAA3\u0001\u0007\u0011QK\u0001\u0018O\u0016$\bK]3w\u0005\u0006$8\r\u001b$s_6\u001cFo\u001c:bO\u0016$B!a5\u0002VB)A)!3\u0002V!9\u0011\u0011\u0011\u000eA\u0002\u0005U\u0013AF1qa2LhI\u001c+p\u0005\u0006$8\r\u001b\"z'R\u0014X-Y7\u0016\t\u0005m\u0017\u0011\u001d\u000b\u0007\u0003;\f90!?\u0015\t\u0005}\u0017Q\u001e\t\u0004\u001d\u0006\u0005HaBAr7\t\u0007\u0011Q\u001d\u0002\u0004%\u0016#\u0016c\u0001*\u0002hB\u0019A)!;\n\u0007\u0005-XIA\u0002B]fDq!a<\u001c\u0001\u0004\t\t0\u0001\u0002g]B9A)a=\u00026\u0006}\u0017bAA{\u000b\nIa)\u001e8di&|g.\r\u0005\b\u0003\u0003[\u0002\u0019AA+\u0011%\tYp\u0007I\u0001\u0002\u0004\tI$A\ttW&\u0004X\t_5ti&twm\u00115fG.\f\u0001%\u00199qYf4e\u000eV8CCR\u001c\u0007NQ=TiJ,\u0017-\u001c\u0013eK\u001a\fW\u000f\u001c;%eU!!\u0011\u0001B\f+\t\u0011\u0019A\u000b\u0003\u0002:\t\u00151F\u0001B\u0004!\u0011\u0011IAa\u0005\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tEQ)\u0001\u0006b]:|G/\u0019;j_:LAA!\u0006\u0003\f\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005\rHD1\u0001\u0002f\u0006)qO]5uKR1\u00111\u0013B\u000f\u0005CAqAa\b\u001e\u0001\u0004\t9\"A\tcCR\u001c\u0007.T3uC\u0012\fG/\u0019$jY\u0016Dq!a<\u001e\u0001\u0004\u0011\u0019\u0003E\u0004E\u0003g\f\t+a%\u0002'\u0005$GMT3x\u0005\u0006$8\r\u001b\"z'R\u0014X-Y7\u0015\t\t%\"Q\u0006\u000b\u0005\u0003s\u0011Y\u0003C\u0004\u0002pz\u0001\rAa\t\t\u000f\u0005\u0005e\u00041\u0001\u0002V\u0005\u0001r-\u001a;Fq&\u001cH/\u001b8h\u0005\u0006$8\r\u001b\u000b\u0004\u001b\nM\u0002bBAA?\u0001\u0007\u0011Q\u000b\u000b\u0007\u0005o\u0011\u0019Ea\u0012\u0011\u000b\u0011\u0013ID!\u0010\n\u0007\tmRIA\u0003BeJ\f\u0017\u0010\u0005\u0004E\u0005\u007f\t)&T\u0005\u0004\u0005\u0003*%A\u0002+va2,'\u0007C\u0004\u0003F\u0001\u0002\r!a5\u0002\u000fM$\u0018M\u001d;JI\"9!\u0011\n\u0011A\u0002\u0005M\u0017!B3oI&#\u0017\u0001E4fi2\u000bG/Z:u\u0005\u0006$8\r[%e)\t\t\u0019.A\u0005hKRd\u0015\r^3tiR\u0011!1\u000b\t\u0006\t\u0006%'QH\u0001\u0015O\u0016$xJ\u001d3fe\u0016$')\u0019;dQ\u001aKG.Z:\u0015\u0005\te\u0003#\u0002#\u0003:\tm\u0003\u0003BA\r\u0005;JAAa\u0018\u0002\u001c\tQa)\u001b7f'R\fG/^:\u0002#1\f7\u000f\u001e)ve\u001e,GMQ1uG\"LE-\u0006\u0002\u0002V\u0005)B.Y:u!V\u0014x-\u001a3CCR\u001c\u0007.\u00133`I\u0015\fH\u0003BAJ\u0005SB\u0011Ba\u001b&\u0003\u0003\u0005\r!!\u0016\u0002\u0007a$\u0013'\u0001\nmCN$\b+\u001e:hK\u0012\u0014\u0015\r^2i\u0013\u0012\u0004\u0013!\u00029ve\u001e,G\u0003BAJ\u0005gBqA!\u001e(\u0001\u0004\t)&\u0001\tuQJ,7\u000f[8mI\n\u000bGo\u00195JI\u0006Q\u0001/\u001e:hK\u00063G/\u001a:\u0015\t\u0005M%1\u0010\u0005\b\u0005kB\u0003\u0019AA+\u0003-a\u0017n\u001d;CCR\u001c\u0007.Z:\u0016\u0005\t\u0005\u0005#\u0002#\u0003:\u0005U\u0013!\u00057jgR\u0014\u0015\r^2iKN|e\u000eR5tW\u0006ya/\u00197jI\u0006$XMV3sg&|g\u000e\u0006\u0004\u0003\n\n=%1\u0013\t\u0004\t\n-\u0015b\u0001BG\u000b\n\u0019\u0011J\u001c;\t\r\tE5\u00061\u0001b\u0003\u0011!X\r\u001f;\t\u000f\tU5\u00061\u0001\u0003\n\u0006\u0019R.\u0019=TkB\u0004xN\u001d;fIZ+'o]5p]\u0006Ib/\u00197jI\u0006$XMV3sg&|g.\u0012=bGRl\u0015\r^2i)\u0019\u0011IIa'\u0003\u001e\"1!\u0011\u0013\u0017A\u0002\u0005DqAa(-\u0001\u0004\u0011I)\u0001\u0007nCR\u001c\u0007NV3sg&|g.A\bI\t\u001a\u001bV*\u001a;bI\u0006$\u0018\rT8h!\tQef\u0005\u0002/\u0007R\u0011!1U\u0001\u000fm\u0016\u0014\u0018NZ=CCR\u001c\u0007.\u00133t)!\t\u0019J!,\u0003D\n\u0015\u0007b\u0002BXa\u0001\u0007!\u0011W\u0001\tE\u0006$8\r[%egB1!1\u0017B_\u0003+rAA!.\u0003::\u0019AMa.\n\u0003\u0019K1Aa/F\u0003\u001d\u0001\u0018mY6bO\u0016LAAa0\u0003B\n\u00191+Z9\u000b\u0007\tmV\tC\u0004\u0003FA\u0002\r!a5\t\u000f\t%\u0003\u00071\u0001\u0002T\u0002")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final String path;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final boolean metadataCacheEnabled;
    private final Map<Object, T> batchCache;
    private final PathFilter batchFilesFilter;
    private long lastPurgedBatchId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> batchIds, Option<Object> startId, Option<Object> endId) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(batchIds, startId, endId);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public boolean metadataCacheEnabled() {
        return this.metadataCacheEnabled;
    }

    public Map<Object, T> batchCache() {
        return this.batchCache;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), Long.toString(batchId));
    }

    public long pathToBatchId(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable)() -> "'null' metadata cannot written to a metadata log");
        boolean res = this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            this.serialize(metadata, output);
            return BoxedUnit.UNIT;
        });
        Object object = this.metadataCacheEnabled() && res ? this.batchCache().put(BoxesRunTime.boxToLong((long)batchId), metadata) : BoxedUnit.UNIT;
        return res;
    }

    @Override
    public Option<T> get(long batchId) {
        None$ none$;
        if (this.metadataCacheEnabled() && this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            T metadata = this.batchCache().get(BoxesRunTime.boxToLong((long)batchId));
            Predef$.MODULE$.assert(metadata != null);
            return new Some(metadata);
        }
        try {
            none$ = (Option)this.applyFnToBatchByStream(batchId, this.applyFnToBatchByStream$default$2(), (Function1 & Serializable)input -> new Some(this.deserialize((InputStream)input)));
        }
        catch (FileNotFoundException fne) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> fne.getMessage());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Object> getPrevBatchFromStorage(long batchId) {
        Option option;
        Object object = new Object();
        try {
            long[] batchFiles = this.listBatchesOnDisk();
            ObjectRef prev = ObjectRef.create((Object)None$.MODULE$);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(batchFiles), (Ordering)Ordering.Long$.MODULE$)), (Function1)(JFunction1.mcVJ.sp & Serializable)file -> {
                if (file >= batchId) {
                    throw new NonLocalReturnControl(object, (Object)((Option)prev$1.elem));
                }
                prev$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file));
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public <RET> RET applyFnToBatchByStream(long batchId, boolean skipExistingCheck, Function1<InputStream, RET> fn) {
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (skipExistingCheck || this.fileManager().exists(batchMetadataFile)) {
            Object object;
            FSDataInputStream input = this.fileManager().open(batchMetadataFile);
            try {
                try {
                    object = fn.apply((Object)input);
                }
                catch (IllegalStateException ise) {
                    throw new IllegalStateException("Failed to read log file " + batchMetadataFile + ". " + ise.getMessage(), ise);
                }
            }
            finally {
                Utils$.MODULE$.closeQuietly((Closeable)input);
            }
            return (RET)object;
        }
        throw QueryExecutionErrors$.MODULE$.batchMetadataFileNotFoundError(batchMetadataFile);
    }

    public <RET> boolean applyFnToBatchByStream$default$2() {
        return false;
    }

    public void write(Path batchMetadataFile, Function1<OutputStream, BoxedUnit> fn) {
        CheckpointFileManager.CancellableFSDataOutputStream output = this.fileManager().createAtomic(batchMetadataFile, false);
        try {
            fn.apply((Object)output);
            output.close();
        }
        catch (FileAlreadyExistsException e) {
            throw QueryExecutionErrors$.MODULE$.multiStreamingQueriesUsingPathConcurrentlyError(this.path, e);
        }
        finally {
            output.cancel();
        }
    }

    public boolean addNewBatchByStream(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.metadataCacheEnabled() && this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId)) || this.fileManager().exists(batchMetadataFile)) {
            return false;
        }
        this.write(batchMetadataFile, fn);
        return true;
    }

    private T getExistingBatch(long batchId) {
        T metadata = this.batchCache().get(BoxesRunTime.boxToLong((long)batchId));
        if (metadata == null) {
            return (T)this.applyFnToBatchByStream(batchId, true, (Function1 & Serializable)input -> this.deserialize((InputStream)input));
        }
        return metadata;
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        long[] batchIds = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> !(!endId.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)endId.get()) || !startId.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)startId.get())))), (Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)batchIds).toImmutableArraySeq(), startId, endId);
        return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(batchIds), (Function1 & Serializable)batchId -> HDFSMetadataLog.$anonfun$get$4(this, BoxesRunTime.unboxToLong((Object)batchId)), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Option<Object> getLatestBatchId() {
        return ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Ordering)Ordering.Long$.MODULE$)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        return ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Ordering)Ordering.Long$.MODULE$))).map((Function1 & Serializable)batchId -> HDFSMetadataLog.$anonfun$getLatest$1(this, BoxesRunTime.unboxToLong((Object)batchId)));
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (Ordering)Ordering.Long$.MODULE$)));
    }

    private long lastPurgedBatchId() {
        return this.lastPurgedBatchId;
    }

    private void lastPurgedBatchId_$eq(long x$1) {
        this.lastPurgedBatchId = x$1;
    }

    @Override
    public void purge(long thresholdBatchId) {
        NumericRange.Exclusive possibleTargetBatchIds = new RichLong(Predef$.MODULE$.longWrapper(this.lastPurgedBatchId() + 1L)).until((Object)BoxesRunTime.boxToLong((long)thresholdBatchId));
        if (possibleTargetBatchIds.length() <= 3) {
            possibleTargetBatchIds.foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Removed metadata log file: " + path);
            });
        } else {
            ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> batchId < thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Removed metadata log file: " + path);
            });
        }
        this.lastPurgedBatchId_$eq(thresholdBatchId - 1L);
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long());
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.longArrayOps(batchIds), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> batchId > thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Removed metadata log file: " + path);
        });
    }

    public long[] listBatches() {
        long[] lArray;
        Map<Object, T> map = this.batchCache();
        synchronized (map) {
            lArray = (long[])CollectionConverters$.MODULE$.SetHasAsScala(this.batchCache().keySet()).asScala().toArray((ClassTag)ClassTag$.MODULE$.Long());
        }
        long[] batchIds = (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.isFile()))), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Object)lArray, (ClassTag)ClassTag$.MODULE$.Long());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"BatchIds found from listing: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(batchIds), (Ordering)Ordering.Long$.MODULE$)).mkString(", "))}))));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(batchIds))) {
            return (long[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Long());
        }
        return (long[])new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(batchIds).min((Ordering)Ordering.Long$.MODULE$)))).to(Predef$.MODULE$.wrapLongArray(batchIds).max((Ordering)Ordering.Long$.MODULE$)).toArray((ClassTag)ClassTag$.MODULE$.Long());
    }

    public long[] listBatchesOnDisk() {
        return (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$);
    }

    public int validateVersion(String text, int maxSupportedVersion) {
        return MetadataVersionUtil$.MODULE$.validateVersion(text, maxSupportedVersion);
    }

    public int validateVersionExactMatch(String text, int matchVersion) {
        return MetadataVersionUtil$.MODULE$.validateVersionExactMatch(text, matchVersion);
    }

    public static final /* synthetic */ Tuple2 $anonfun$get$4(HDFSMetadataLog $this, long batchId) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.getExistingBatch(batchId));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getLatest$1(HDFSMetadataLog $this, long batchId) {
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Getting latest batch ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)batchId))}))));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.getExistingBatch(batchId));
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.path = path;
        Logging.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz == null ? clazz2 != null : !clazz.equals(clazz2), (Function0 & Serializable)() -> "Should not create a log with type Seq, use Arrays instead - see SPARK-17372");
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.metadataCacheEnabled = BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_METADATA_CACHE_ENABLED()));
        this.batchCache = Collections.synchronizedMap(new LinkedHashMap<Object, T>(null){

            public boolean removeEldestEntry(Map.Entry<Object, T> e) {
                return this.size() > 2;
            }
        });
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.lastPurgedBatchId = -1L;
    }
}

