/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.feature.TargetEncoder$;
import org.apache.spark.ml.feature.TargetEncoderBase;
import org.apache.spark.ml.feature.TargetEncoderModel$;
import org.apache.spark.ml.feature.TargetEncoderModel$TargetEncoderModelReader$;
import org.apache.spark.ml.feature.TargetEncoderModel$TargetEncoderModelWriter$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasHandleInvalid;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasInputCols;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCols;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rec\u0001\u0002\"D\u00019C\u0001B\u0018\u0001\u0003\u0006\u0004%\te\u0018\u0005\tm\u0002\u0011\t\u0011)A\u0005A\"I\u0001\u0010\u0001BC\u0002\u0013\u0005Q)\u001f\u0005\n\u0003#\u0001!\u0011!Q\u0001\niD\u0001\"!\u0006\u0001\t\u0003)\u0015q\u0003\u0005\t\u0003+\u0001A\u0011A#\u0002\"!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBA_\u0001\u0011\u0005\u0013q\u0018\u0005\b\u0003'\u0004A\u0011IAk\u0011\u001d\ty\u000e\u0001C!\u0003C<q!a:D\u0011\u0003\tIO\u0002\u0004C\u0007\"\u0005\u00111\u001e\u0005\b\u0003+\u0019B\u0011\u0001B\u0005\r\u001d\u0011Ya\u0005!F\u0005\u001bA!Ba\t\u0016\u0005+\u0007I\u0011\u0001B\u0013\u0011)\u0011i#\u0006B\tB\u0003%!q\u0005\u0005\u000b\u0005_)\"Q3A\u0005\u0002\tE\u0002B\u0003B\u001b+\tE\t\u0015!\u0003\u00034!Q!qG\u000b\u0003\u0016\u0004%\tA!\r\t\u0015\teRC!E!\u0002\u0013\u0011\u0019\u0004C\u0005y+\tU\r\u0011\"\u0001\u00032!Q\u0011\u0011C\u000b\u0003\u0012\u0003\u0006IAa\r\t\u000f\u0005UQ\u0003\"\u0001\u0003<!I\u0011QX\u000b\u0002\u0002\u0013\u0005!\u0011\n\u0005\n\u0005'*\u0012\u0013!C\u0001\u0005+B\u0011B!\u001b\u0016#\u0003%\tAa\u001b\t\u0013\t=T#%A\u0005\u0002\t-\u0004\"\u0003B9+E\u0005I\u0011\u0001B6\u0011%\u0011\u0019(FA\u0001\n\u0003\u0012)\bC\u0005\u0003\u0002V\t\t\u0011\"\u0001\u0003&!I!1Q\u000b\u0002\u0002\u0013\u0005!Q\u0011\u0005\n\u0005\u0017+\u0012\u0011!C!\u0005\u001bC\u0011Ba'\u0016\u0003\u0003%\tA!(\t\u0013\t\u001dV#!A\u0005B\t%\u0006\"\u0003BW+\u0005\u0005I\u0011\tBX\u0011%\ty.FA\u0001\n\u0003\u0012\t\fC\u0005\u00034V\t\t\u0011\"\u0011\u00036\u001eQ!\u0011X\n\u0002\u0002#\u0005QIa/\u0007\u0015\t-1#!A\t\u0002\u0015\u0013i\fC\u0004\u0002\u00169\"\tAa3\t\u0013\u0005}g&!A\u0005F\tE\u0006\"\u0003Bg]\u0005\u0005I\u0011\u0011Bh\u0011%\u0011INLA\u0001\n\u0003\u0013Y\u000eC\u0005\u0003n:\n\t\u0011\"\u0003\u0003p\"A!q_\n\u0005\u0002\u0015\u0013I\u0010\u0003\u0005\u0004\u0010M!\t!RB\t\r\u001d\u0019ib\u0005\u0001\u0014\u0007?A\u0011b!\t7\u0005\u0003\u0005\u000b\u0011B*\t\u000f\u0005Ua\u0007\"\u0001\u0004$!91\u0011\u0006\u001c\u0005R\r-bABB\u0019'\u0011\u0019\u0019\u0004C\u0004\u0002\u0016i\"\taa\u000f\t\u0013\r}\"H1A\u0005\n\tU\u0004\u0002CB!u\u0001\u0006IAa\u001e\t\u000f\r\r#\b\"\u0011\u0004F!91\u0011J\n\u0005B\r-\u0003bBB\"'\u0011\u00053q\n\u0005\n\u0005[\u001c\u0012\u0011!C\u0005\u0005_\u0014!\u0003V1sO\u0016$XI\\2pI\u0016\u0014Xj\u001c3fY*\u0011A)R\u0001\bM\u0016\fG/\u001e:f\u0015\t1u)\u0001\u0002nY*\u0011\u0001*S\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015.\u000ba!\u00199bG\",'\"\u0001'\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001yU\u000b\u0017\t\u0004!F\u001bV\"A#\n\u0005I+%!B'pI\u0016d\u0007C\u0001+\u0001\u001b\u0005\u0019\u0005C\u0001+W\u0013\t96IA\tUCJ<W\r^#oG>$WM\u001d\"bg\u0016\u0004\"!\u0017/\u000e\u0003iS!aW#\u0002\tU$\u0018\u000e\\\u0005\u0003;j\u0013!\"\u0014'Xe&$\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u0002AB\u0011\u0011M\u001b\b\u0003E\"\u0004\"a\u00194\u000e\u0003\u0011T!!Z'\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0017!B:dC2\f\u0017BA5g\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%4\u0007fA\u0001oiB\u0011qN]\u0007\u0002a*\u0011\u0011oR\u0001\u000bC:tw\u000e^1uS>t\u0017BA:q\u0005\u0015\u0019\u0016N\\2fC\u0005)\u0018!\u0002\u001b/a9\u0002\u0014\u0001B;jI\u0002B3A\u00018u\u0003\u0015\u0019H/\u0019;t+\u0005Q\bcA>}}6\ta-\u0003\u0002~M\n)\u0011I\u001d:bsB1\u0011m`A\u0002\u0003\u0013I1!!\u0001m\u0005\ri\u0015\r\u001d\t\u0004w\u0006\u0015\u0011bAA\u0004M\n1Ai\\;cY\u0016\u0004ra_A\u0006\u0003\u0007\t\u0019!C\u0002\u0002\u000e\u0019\u0014a\u0001V;qY\u0016\u0014\u0004fA\u0002oi\u000611\u000f^1ug\u0002B3\u0001\u00028u\u0003\u0019a\u0014N\\5u}Q)1+!\u0007\u0002\u001e!)a,\u0002a\u0001A\"\"\u0011\u0011\u00048u\u0011\u0015AX\u00011\u0001{Q\u0011\tiB\u001c;\u0015\u0003M\u000b1b]3u\u0013:\u0004X\u000f^\"pYR!\u0011qEA\u0015\u001b\u0005\u0001\u0001BBA\u0016\u000f\u0001\u0007\u0001-A\u0003wC2,X\rK\u0002\b]R\fAb]3u\u001fV$\b/\u001e;D_2$B!a\n\u00024!1\u00111\u0006\u0005A\u0002\u0001D3\u0001\u00038u\u00031\u0019X\r^%oaV$8i\u001c7t)\u0011\t9#a\u000f\t\u000f\u0005u\u0012\u00021\u0001\u0002@\u00051a/\u00197vKN\u00042a\u001f?aQ\rIa\u000e^\u0001\u000eg\u0016$x*\u001e;qkR\u001cu\u000e\\:\u0015\t\u0005\u001d\u0012q\t\u0005\b\u0003{Q\u0001\u0019AA Q\rQa\u000e^\u0001\u0011g\u0016$\b*\u00198eY\u0016LeN^1mS\u0012$B!a\n\u0002P!1\u00111F\u0006A\u0002\u0001D3a\u00038u\u00031\u0019X\r^*n_>$\b.\u001b8h)\u0011\t9#a\u0016\t\u000f\u0005-B\u00021\u0001\u0002\u0004!\u001aAB\u001c;\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!a\u0018\u0002pA!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014!\u0002;za\u0016\u001c(bAA5\u000f\u0006\u00191/\u001d7\n\t\u00055\u00141\r\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA9\u001b\u0001\u0007\u0011qL\u0001\u0007g\u000eDW-\\1)\u00075qG/A\u0005ue\u0006t7OZ8s[R!\u0011\u0011PAL!\u0011\tY(!%\u000f\t\u0005u\u0014Q\u0012\b\u0005\u0003\u007f\nYI\u0004\u0003\u0002\u0002\u0006%e\u0002BAB\u0003\u000fs1aYAC\u0013\u0005a\u0015B\u0001&L\u0013\tA\u0015*C\u0002\u0002j\u001dKA!a$\u0002h\u00059\u0001/Y2lC\u001e,\u0017\u0002BAJ\u0003+\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005=\u0015q\r\u0005\b\u00033s\u0001\u0019AAN\u0003\u001d!\u0017\r^1tKR\u0004D!!(\u0002*B1\u0011qTAQ\u0003Kk!!a\u001a\n\t\u0005\r\u0016q\r\u0002\b\t\u0006$\u0018m]3u!\u0011\t9+!+\r\u0001\u0011a\u00111VAL\u0003\u0003\u0005\tQ!\u0001\u0002.\n\u0019q\f\n\u001a\u0012\t\u0005=\u0016Q\u0017\t\u0004w\u0006E\u0016bAAZM\n9aj\u001c;iS:<\u0007cA>\u00028&\u0019\u0011\u0011\u00184\u0003\u0007\u0005s\u0017\u0010K\u0002\u000f]R\fAaY8qsR\u00191+!1\t\u000f\u0005\rw\u00021\u0001\u0002F\u0006)Q\r\u001f;sCB!\u0011qYAg\u001b\t\tIMC\u0002\u0002L\u0016\u000bQ\u0001]1sC6LA!a4\u0002J\nA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\u0010]R\fQa\u001e:ji\u0016,\"!a6\u0011\u0007e\u000bI.C\u0002\u0002\\j\u0013\u0001\"\u0014'Xe&$XM\u001d\u0015\u0004!9$\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0001D3!\u00058uQ\r\u0001a\u000e^\u0001\u0013)\u0006\u0014x-\u001a;F]\u000e|G-\u001a:N_\u0012,G\u000e\u0005\u0002U'M91#!<\u0002t\u0006e\bcA>\u0002p&\u0019\u0011\u0011\u001f4\u0003\r\u0005s\u0017PU3g!\u0011I\u0016Q_*\n\u0007\u0005](L\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004B!a?\u0003\u00065\u0011\u0011Q \u0006\u0005\u0003\u007f\u0014\t!\u0001\u0002j_*\u0011!1A\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\b\u0005u(\u0001D*fe&\fG.\u001b>bE2,GCAAu\u0005\u0011!\u0015\r^1\u0014\u000fU\tiOa\u0004\u0003\u0016A\u00191P!\u0005\n\u0007\tMaMA\u0004Qe>$Wo\u0019;\u0011\t\t]!q\u0004\b\u0005\u00053\u0011iBD\u0002d\u00057I\u0011aZ\u0005\u0004\u0003\u001f3\u0017\u0002\u0002B\u0004\u0005CQ1!a$g\u0003\u0015Ig\u000eZ3y+\t\u00119\u0003E\u0002|\u0005SI1Aa\u000bg\u0005\rIe\u000e^\u0001\u0007S:$W\r\u001f\u0011\u0002\u0015\r\fG/Z4pe&,7/\u0006\u0002\u00034A!1\u0010`A\u0002\u0003-\u0019\u0017\r^3h_JLWm\u001d\u0011\u0002\r\r|WO\u001c;t\u0003\u001d\u0019w.\u001e8ug\u0002\"\"B!\u0010\u0003B\t\r#Q\tB$!\r\u0011y$F\u0007\u0002'!9!1\u0005\u0010A\u0002\t\u001d\u0002b\u0002B\u0018=\u0001\u0007!1\u0007\u0005\b\u0005oq\u0002\u0019\u0001B\u001a\u0011\u0019Ah\u00041\u0001\u00034QQ!Q\bB&\u0005\u001b\u0012yE!\u0015\t\u0013\t\rr\u0004%AA\u0002\t\u001d\u0002\"\u0003B\u0018?A\u0005\t\u0019\u0001B\u001a\u0011%\u00119d\bI\u0001\u0002\u0004\u0011\u0019\u0004\u0003\u0005y?A\u0005\t\u0019\u0001B\u001a\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0016+\t\t\u001d\"\u0011L\u0016\u0003\u00057\u0002BA!\u0018\u0003f5\u0011!q\f\u0006\u0005\u0005C\u0012\u0019'A\u0005v]\u000eDWmY6fI*\u0011\u0011OZ\u0005\u0005\u0005O\u0012yFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003n)\"!1\u0007B-\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005o\u0002BA!\u001f\u0003\u00005\u0011!1\u0010\u0006\u0005\u0005{\u0012\t!\u0001\u0003mC:<\u0017bA6\u0003|\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA[\u0005\u000fC\u0011B!#'\u0003\u0003\u0005\rAa\n\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\t\u0005\u0004\u0003\u0012\n]\u0015QW\u0007\u0003\u0005'S1A!&g\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00053\u0013\u0019J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BP\u0005K\u00032a\u001fBQ\u0013\r\u0011\u0019K\u001a\u0002\b\u0005>|G.Z1o\u0011%\u0011I\tKA\u0001\u0002\u0004\t),\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B<\u0005WC\u0011B!#*\u0003\u0003\u0005\rAa\n\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\n\u0015\u0005\t]\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003 \n]\u0006\"\u0003BEY\u0005\u0005\t\u0019AA[\u0003\u0011!\u0015\r^1\u0011\u0007\t}bfE\u0003/\u0005\u007f\u000bI\u0010\u0005\b\u0003B\n\u001d'q\u0005B\u001a\u0005g\u0011\u0019D!\u0010\u000e\u0005\t\r'b\u0001BcM\u00069!/\u001e8uS6,\u0017\u0002\u0002Be\u0005\u0007\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\u0011Y,A\u0003baBd\u0017\u0010\u0006\u0006\u0003>\tE'1\u001bBk\u0005/DqAa\t2\u0001\u0004\u00119\u0003C\u0004\u00030E\u0002\rAa\r\t\u000f\t]\u0012\u00071\u0001\u00034!1\u00010\ra\u0001\u0005g\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003^\n%\b#B>\u0003`\n\r\u0018b\u0001BqM\n1q\n\u001d;j_:\u00042b\u001fBs\u0005O\u0011\u0019Da\r\u00034%\u0019!q\u001d4\u0003\rQ+\b\u000f\\35\u0011%\u0011YOMA\u0001\u0002\u0004\u0011i$A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!=\u0011\t\te$1_\u0005\u0005\u0005k\u0014YH\u0001\u0004PE*,7\r^\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016$\u0015\r^1\u0015\r\tm8\u0011AB\u0003!\rY(Q`\u0005\u0004\u0005\u007f4'\u0001B+oSRDqaa\u00015\u0001\u0004\u0011i$\u0001\u0003eCR\f\u0007bBB\u0004i\u0001\u00071\u0011B\u0001\u0004I>\u001c\b\u0003BA~\u0007\u0017IAa!\u0004\u0002~\n\u0001B)\u0019;b\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\u0010I\u0016\u001cXM]5bY&TX\rR1uCR!!QHB\n\u0011\u001d\u0019)\"\u000ea\u0001\u0007/\t1\u0001Z5t!\u0011\tYp!\u0007\n\t\rm\u0011Q \u0002\u0010\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\nAB+\u0019:hKR,enY8eKJlu\u000eZ3m/JLG/\u001a:\u0014\u0007Y\n9.\u0001\u0005j]N$\u0018M\\2f)\u0011\u0019)ca\n\u0011\u0007\t}b\u0007\u0003\u0004\u0004\"a\u0002\raU\u0001\tg\u00064X-S7qYR!!1`B\u0017\u0011\u0019\u0019y#\u000fa\u0001A\u0006!\u0001/\u0019;i\u0005a!\u0016M]4fi\u0016s7m\u001c3fe6{G-\u001a7SK\u0006$WM]\n\u0004u\rU\u0002\u0003B-\u00048MK1a!\u000f[\u0005!iEJU3bI\u0016\u0014HCAB\u001f!\r\u0011yDO\u0001\nG2\f7o\u001d(b[\u0016\f!b\u00197bgNt\u0015-\\3!\u0003\u0011aw.\u00193\u0015\u0007M\u001b9\u0005\u0003\u0004\u00040y\u0002\r\u0001Y\u0001\u0005e\u0016\fG-\u0006\u0002\u00046!\u001aqH\u001c;\u0015\u0007M\u001b\t\u0006\u0003\u0004\u00040\u0001\u0003\r\u0001\u0019\u0015\u0004\u0001:$\bfA\noi\"\u001a!C\u001c;")
public class TargetEncoderModel
extends Model<TargetEncoderModel>
implements TargetEncoderBase,
MLWritable {
    private final String uid;
    private final Map<Object, Tuple2<Object, Object>>[] stats;
    private Param<String> handleInvalid;
    private Param<String> targetType;
    private DoubleParam smoothing;
    private StringArrayParam outputCols;
    private Param<String> outputCol;
    private StringArrayParam inputCols;
    private Param<String> inputCol;
    private Param<String> labelCol;

    public static TargetEncoderModel load(String path) {
        return TargetEncoderModel$.MODULE$.load(path);
    }

    public static MLReader<TargetEncoderModel> read() {
        return TargetEncoderModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getTargetType() {
        return TargetEncoderBase.getTargetType$(this);
    }

    @Override
    public final double getSmoothing() {
        return TargetEncoderBase.getSmoothing$(this);
    }

    @Override
    public String[] inputFeatures() {
        return TargetEncoderBase.inputFeatures$(this);
    }

    @Override
    public String[] outputFeatures() {
        return TargetEncoderBase.outputFeatures$(this);
    }

    @Override
    public StructType validateSchema(StructType schema, boolean fitting) {
        return TargetEncoderBase.validateSchema$(this, schema, fitting);
    }

    @Override
    public final String getHandleInvalid() {
        return HasHandleInvalid.getHandleInvalid$(this);
    }

    @Override
    public final String[] getOutputCols() {
        return HasOutputCols.getOutputCols$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String[] getInputCols() {
        return HasInputCols.getInputCols$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public Param<String> handleInvalid() {
        return this.handleInvalid;
    }

    @Override
    public Param<String> targetType() {
        return this.targetType;
    }

    @Override
    public DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public void org$apache$spark$ml$feature$TargetEncoderBase$_setter_$handleInvalid_$eq(Param<String> x$1) {
        this.handleInvalid = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$TargetEncoderBase$_setter_$targetType_$eq(Param<String> x$1) {
        this.targetType = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$TargetEncoderBase$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasHandleInvalid$_setter_$handleInvalid_$eq(Param<String> x$1) {
    }

    @Override
    public final StringArrayParam outputCols() {
        return this.outputCols;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCols$_setter_$outputCols_$eq(StringArrayParam x$1) {
        this.outputCols = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final StringArrayParam inputCols() {
        return this.inputCols;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCols$_setter_$inputCols_$eq(StringArrayParam x$1) {
        this.inputCols = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Map<Object, Tuple2<Object, Object>>[] stats() {
        return this.stats;
    }

    public TargetEncoderModel setInputCol(String value) {
        return (TargetEncoderModel)this.set(this.inputCol(), value);
    }

    public TargetEncoderModel setOutputCol(String value) {
        return (TargetEncoderModel)this.set(this.outputCol(), value);
    }

    public TargetEncoderModel setInputCols(String[] values) {
        return (TargetEncoderModel)this.set(this.inputCols(), values);
    }

    public TargetEncoderModel setOutputCols(String[] values) {
        return (TargetEncoderModel)this.set(this.outputCols(), values);
    }

    public TargetEncoderModel setHandleInvalid(String value) {
        return (TargetEncoderModel)this.set(this.handleInvalid(), value);
    }

    public TargetEncoderModel setSmoothing(double value) {
        return (TargetEncoderModel)this.set(this.smoothing(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        if (this.outputFeatures().length == this.stats().length) {
            return (StructType)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.outputFeatures()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TargetEncoderModel.$anonfun$transformSchema$1(x$2)))), (Object)this.validateSchema(schema, false), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    StructType newSchema = (StructType)tuple2._1();
                    String outputField = (String)tuple2._2();
                    return newSchema.add(new StructField(outputField, (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        throw new SparkException("The number of features does not match the number of encodings in the model (" + this.stats().length + "). Found " + this.outputFeatures().length + " features)");
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        Map[] encodings = (Map[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.stats()), (Function1 & Serializable)stat -> {
            Tuple2 tuple2 = (Tuple2)stat.get((Object)BoxesRunTime.boxToDouble((double)TargetEncoder$.MODULE$.UNSEEN_CATEGORY())).get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double global_count = tuple2._1$mcD$sp();
            double global_stat = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(global_count, global_stat);
            double global_count2 = sp2._1$mcD$sp();
            double global_stat2 = sp2._2$mcD$sp();
            return (Map)stat.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    double cat = tuple2._1$mcD$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        double d;
                        double class_count = tuple22._1$mcD$sp();
                        double class_stat = tuple22._2$mcD$sp();
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)cat));
                        double weight = class_count / (class_count + BoxesRunTime.unboxToDouble((Object)this.$(this.smoothing())));
                        String string = this.$(this.targetType());
                        String string2 = TargetEncoder$.MODULE$.TARGET_BINARY();
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            d = weight * (class_stat / class_count) + (1.0 - weight) * (global_stat2 / global_count2);
                        } else {
                            String string4 = TargetEncoder$.MODULE$.TARGET_CONTINUOUS();
                            String string5 = string;
                            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                                d = weight * class_stat + (1.0 - weight) * global_stat2;
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxesRunTime.boxToDouble((double)d));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
        }, ClassTag$.MODULE$.apply(Map.class));
        Column[] newCols = (Column[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputFeatures()), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.outputFeatures()))), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])encodings))), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Map mapping = (Map)tuple2._2();
                if (tuple22 != null) {
                    Column column;
                    String featureIn = (String)tuple22._1();
                    String featureOut = (String)tuple22._2();
                    String unseenErrMsg = "Unseen value %s in feature " + featureIn + ". To handle unseen values, set Param handleInvalid to " + TargetEncoder$.MODULE$.KEEP_INVALID() + ".";
                    Column unseenErrCol = functions$.MODULE$.raise_error(functions$.MODULE$.printf(functions$.MODULE$.lit((Object)unseenErrMsg), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featureIn).cast((DataType)StringType$.MODULE$)})));
                    String string = this.$(this.handleInvalid());
                    String string2 = TargetEncoder$.MODULE$.KEEP_INVALID();
                    String string3 = string;
                    Column fillUnseenCol = !(string2 != null ? !string2.equals(string3) : string3 != null) ? functions$.MODULE$.lit(mapping.apply((Object)BoxesRunTime.boxToDouble((double)TargetEncoder$.MODULE$.UNSEEN_CATEGORY()))) : unseenErrCol;
                    Option option = mapping.get((Object)BoxesRunTime.boxToDouble((double)TargetEncoder$.MODULE$.NULL_CATEGORY()));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        double code = BoxesRunTime.unboxToDouble((Object)some.value());
                        column = functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)code));
                    } else {
                        column = fillUnseenCol;
                    }
                    Column fillNullCol = column;
                    Map filteredMapping = (Map)mapping.filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TargetEncoderModel.$anonfun$transform$4(x0$3)));
                    Column castedCol = functions$.MODULE$.col(featureIn).cast((DataType)DoubleType$.MODULE$);
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TargetEncoderModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_feature_TargetEncoderModel$$typecreator1$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                        }

                        public Org_apache_spark_ml_feature_TargetEncoderModel$$typecreator1$1(TargetEncoderModel $outer) {
                        }
                    }
                    Column targetCol = functions$.MODULE$.try_element_at(functions$.MODULE$.typedlit((Object)filteredMapping, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_TargetEncoderModel$$typecreator1$1(null))), castedCol);
                    return functions$.MODULE$.when(castedCol.isNull(), (Object)fillNullCol).when(targetCol.isNull().unary_$bang(), (Object)targetCol).otherwise((Object)fillUnseenCol).as(featureOut, NominalAttribute$.MODULE$.defaultAttr().withName(featureOut).withNumValues(mapping.values().toSet().size()).withValues((String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps((double[])mapping.values().toSet().toArray((ClassTag)ClassTag$.MODULE$.Double())), (Function1 & Serializable)x$4 -> TargetEncoderModel.$anonfun$transform$5(BoxesRunTime.unboxToDouble((Object)x$4)), ClassTag$.MODULE$.apply(String.class))).toMetadata());
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Column.class));
        return dataset.withColumns((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.outputFeatures())), (Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])newCols)));
    }

    @Override
    public TargetEncoderModel copy(ParamMap extra) {
        TargetEncoderModel copied = new TargetEncoderModel(this.uid(), this.stats());
        return (TargetEncoderModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new TargetEncoderModelWriter(this);
    }

    @Override
    public String toString() {
        return "TargetEncoderModel: uid=" + this.uid() + ", handleInvalid=" + this.$(this.handleInvalid()) + ", targetType=" + this.$(this.targetType()) + ", numInputCols=" + this.inputFeatures().length + ", numOutputCols=" + this.outputFeatures().length + ", smoothing=" + this.$(this.smoothing());
    }

    public static final /* synthetic */ boolean $anonfun$transformSchema$1(String x$2) {
        return x$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$transform$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            double k = tuple2._1$mcD$sp();
            return k != TargetEncoder$.MODULE$.UNSEEN_CATEGORY() && k != TargetEncoder$.MODULE$.NULL_CATEGORY();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$transform$5(double x$4) {
        return Double.toString(x$4);
    }

    public TargetEncoderModel(String uid, Map<Object, Tuple2<Object, Object>>[] stats) {
        this.uid = uid;
        this.stats = stats;
        HasLabelCol.$init$(this);
        HasInputCol.$init$(this);
        HasInputCols.$init$(this);
        HasOutputCol.$init$(this);
        HasOutputCols.$init$(this);
        HasHandleInvalid.$init$(this);
        TargetEncoderBase.$init$(this);
        MLWritable.$init$(this);
        Statics.releaseFence();
    }

    public TargetEncoderModel() {
        this("", (Map[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Map.class)));
    }

    public static class Data
    implements Product,
    Serializable {
        private final int index;
        private final double[] categories;
        private final double[] counts;
        private final double[] stats;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int index() {
            return this.index;
        }

        public double[] categories() {
            return this.categories;
        }

        public double[] counts() {
            return this.counts;
        }

        public double[] stats() {
            return this.stats;
        }

        public Data copy(int index, double[] categories, double[] counts, double[] stats) {
            return new Data(index, categories, counts, stats);
        }

        public int copy$default$1() {
            return this.index();
        }

        public double[] copy$default$2() {
            return this.categories();
        }

        public double[] copy$default$3() {
            return this.counts();
        }

        public double[] copy$default$4() {
            return this.stats();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.index());
                }
                case 1: {
                    return this.categories();
                }
                case 2: {
                    return this.counts();
                }
                case 3: {
                    return this.stats();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "index";
                }
                case 1: {
                    return "categories";
                }
                case 2: {
                    return "counts";
                }
                case 3: {
                    return "stats";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2122698);
            n = Statics.mix((int)n, (int)this.index());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.categories()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.counts()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.stats()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.index() != data.index()) return false;
            if (this.categories() != data.categories()) return false;
            if (this.counts() != data.counts()) return false;
            if (this.stats() != data.stats()) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(int index, double[] categories, double[] counts, double[] stats) {
            this.index = index;
            this.categories = categories;
            this.counts = counts;
            this.stats = stats;
            Product.$init$((Product)this);
        }
    }

    private static class TargetEncoderModelReader
    extends MLReader<TargetEncoderModel> {
        private final String className = TargetEncoderModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public TargetEncoderModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TargetEncoderModelReader.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_TargetEncoderModel$TargetEncoderModelReader$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.TargetEncoderModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_TargetEncoderModel$TargetEncoderModelReader$$typecreator1$3(TargetEncoderModelReader $outer) {
                }
            }
            Data[] datum = (Data[])ReadWriteUtils$.MODULE$.loadArray(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> TargetEncoderModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_TargetEncoderModel$TargetEncoderModelReader$$typecreator1$3(null)));
            Map[] stats = (Map[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])datum), (Function1 & Serializable)data -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)data.index()), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(data.categories()), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(data.counts()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(data.stats()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)), (Function1 & Serializable)x$8 -> (Map)x$8._2(), ClassTag$.MODULE$.apply(Map.class));
            TargetEncoderModel model = new TargetEncoderModel(metadata.uid(), stats);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class TargetEncoderModelWriter
    extends MLWriter {
        private final TargetEncoderModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_feature_TargetEncoderModel$TargetEncoderModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.TargetEncoderModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_TargetEncoderModel$TargetEncoderModelWriter$$typecreator1$2(TargetEncoderModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Seq datum = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])this.instance.stats())).zipWithIndex().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Map stat = (Map)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = stat.toSeq().unzip(Predef$.MODULE$.$conforms());
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Seq _categories = (Seq)tuple22._1();
                    Seq _countsAndStats = (Seq)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)_categories, (Object)_countsAndStats);
                    Seq _categories2 = (Seq)tuple23._1();
                    Seq _countsAndStats2 = (Seq)tuple23._2();
                    Tuple2 tuple24 = _countsAndStats2.unzip(Predef$.MODULE$.$conforms());
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    Seq _counts = (Seq)tuple24._1();
                    Seq _stats = (Seq)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)_counts, (Object)_stats);
                    Seq _counts2 = (Seq)tuple25._1();
                    Seq _stats2 = (Seq)tuple25._2();
                    return new Data(index, (double[])_categories2.toArray((ClassTag)ClassTag$.MODULE$.Double()), (double[])_counts2.toArray((ClassTag)ClassTag$.MODULE$.Double()), (double[])_stats2.toArray((ClassTag)ClassTag$.MODULE$.Double()));
                }
                throw new MatchError((Object)tuple2);
            }).toSeq();
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TargetEncoderModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveArray(dataPath, datum.toArray(ClassTag$.MODULE$.apply(Data.class)), this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                TargetEncoderModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ReadWriteUtils$.MODULE$.saveArray$default$5(), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_TargetEncoderModel$TargetEncoderModelWriter$$typecreator1$2(null)));
        }

        public TargetEncoderModelWriter(TargetEncoderModel instance) {
            this.instance = instance;
        }
    }
}

