/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.FMRegressionModel$;
import org.apache.spark.ml.regression.FMRegressionModel$FMRegressionModelReader$;
import org.apache.spark.ml.regression.FMRegressionModel$FMRegressionModelWriter$;
import org.apache.spark.ml.regression.FMRegressorParams;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.ml.regression.FactorizationMachinesParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t5h\u0001B A\u0001-C\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t%\u0019\u0005\tq\u0002\u0011\t\u0011)A\u0005E\"A!\u0010\u0001BC\u0002\u0013\u00051\u0010C\u0005\u0002\u0004\u0001\u0011\t\u0011)A\u0005y\"Q\u0011q\u0001\u0001\u0003\u0006\u0004%\t!!\u0003\t\u0013\u00055\u0001A!A!\u0002\u0013\u0001\u0006BCA\t\u0001\t\u0015\r\u0011\"\u0001\u0002\u0014!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!!\u0006\t\u0011\u0005\u0005\u0002\u0001\"\u0001A\u0003GA\u0001\"!\t\u0001\t\u0003\u0011\u0015Q\u0007\u0005\n\u0003o\u0001!\u0019!C!\u0003sA\u0001\"a\u0011\u0001A\u0003%\u00111\b\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\t\t\u0006\u0001C!\u0003'B\u0001\"a\u001a\u0001\t\u0003\"\u0015\u0011\u000e\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\ti\b\u0001C!\u0003\u007f:q!a!A\u0011\u0003\t)I\u0002\u0004@\u0001\"\u0005\u0011q\u0011\u0005\b\u0003C\u0019B\u0011AAS\r\u001d\t9k\u0005!C\u0003SC\u0001B_\u000b\u0003\u0016\u0004%\ta\u001f\u0005\n\u0003\u0007)\"\u0011#Q\u0001\nqD!\"a\u0002\u0016\u0005+\u0007I\u0011AA\u0005\u0011%\ti!\u0006B\tB\u0003%\u0001\u000b\u0003\u0006\u0002\u0012U\u0011)\u001a!C\u0001\u0003'A!\"!\b\u0016\u0005#\u0005\u000b\u0011BA\u000b\u0011\u001d\t\t#\u0006C\u0001\u0003\u0003D\u0011\"!\u0015\u0016\u0003\u0003%\t!!4\t\u0013\u0005UW#%A\u0005\u0002\u0005]\u0007\"CAv+E\u0005I\u0011AAw\u0011%\t\t0FI\u0001\n\u0003\t\u0019\u0010C\u0005\u0002xV\t\t\u0011\"\u0011\u0002z\"I!QA\u000b\u0002\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0005\u000f)\u0012\u0011!C\u0001\u0005\u0013A\u0011B!\u0006\u0016\u0003\u0003%\tEa\u0006\t\u0013\t\u0015R#!A\u0005\u0002\t\u001d\u0002\"\u0003B\u0019+\u0005\u0005I\u0011\tB\u001a\u0011%\u00119$FA\u0001\n\u0003\u0012I\u0004C\u0005\u0002~U\t\t\u0011\"\u0011\u0003<!I!QH\u000b\u0002\u0002\u0013\u0005#qH\u0004\u000b\u0005\u0007\u001a\u0012\u0011!E\u0001\u0005\n\u0015cACAT'\u0005\u0005\t\u0012\u0001\"\u0003H!9\u0011\u0011E\u0016\u0005\u0002\tU\u0003\"CA?W\u0005\u0005IQ\tB\u001e\u0011%\u00119fKA\u0001\n\u0003\u0013I\u0006C\u0005\u0003b-\n\t\u0011\"!\u0003d!I!QO\u0016\u0002\u0002\u0013%!q\u000f\u0005\t\u0005\u007f\u001aB\u0011\u0001\"\u0003\u0002\"A!qS\n\u0005\u0002\t\u0013I\nC\u0004\u0003&N!\tEa*\t\u000f\tE6\u0003\"\u0011\u00034\u001a9!1X\n\u0001'\tu\u0006\"\u0003Bfk\t\u0005\t\u0015!\u0003W\u0011\u001d\t\t#\u000eC\u0001\u0005\u001bDqAa56\t#\u0012)N\u0002\u0004\u0003ZN!!1\u001c\u0005\b\u0003CID\u0011\u0001Bo\u0011%\u0011\t/\u000fb\u0001\n\u0013\tI\u0010\u0003\u0005\u0003df\u0002\u000b\u0011BA~\u0011\u001d\u0011\t,\u000fC!\u0005KD\u0011B!\u001e\u0014\u0003\u0003%IAa\u001e\u0003#\u0019k%+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002B\u0005\u0006Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\r#\u0015AA7m\u0015\t)e)A\u0003ta\u0006\u00148N\u0003\u0002H\u0011\u00061\u0011\r]1dQ\u0016T\u0011!S\u0001\u0004_J<7\u0001A\n\u0005\u00011;&\f\u0005\u0003N\u001dB3V\"\u0001!\n\u0005=\u0003%a\u0004*fOJ,7o]5p]6{G-\u001a7\u0011\u0005E#V\"\u0001*\u000b\u0005M\u0013\u0015A\u00027j]\u0006dw-\u0003\u0002V%\n1a+Z2u_J\u0004\"!\u0014\u0001\u0011\u00055C\u0016BA-A\u0005E1UJU3he\u0016\u001c8o\u001c:QCJ\fWn\u001d\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\n\u000bA!\u001e;jY&\u0011q\f\u0018\u0002\u000b\u001b2;&/\u001b;bE2,\u0017aA;jIV\t!\r\u0005\u0002dY:\u0011AM\u001b\t\u0003K\"l\u0011A\u001a\u0006\u0003O*\u000ba\u0001\u0010:p_Rt$\"A5\u0002\u000bM\u001c\u0017\r\\1\n\u0005-D\u0017A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a\u001b5)\u0007\u0005\u0001h\u000f\u0005\u0002ri6\t!O\u0003\u0002t\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005U\u0014(!B*j]\u000e,\u0017%A<\u0002\u000bMr\u0003G\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005A4\u0018!C5oi\u0016\u00148-\u001a9u+\u0005a\bCA?\u007f\u001b\u0005A\u0017BA@i\u0005\u0019!u.\u001e2mK\"\u001a1\u0001\u001d<\u0002\u0015%tG/\u001a:dKB$\b\u0005K\u0002\u0005aZ\fa\u0001\\5oK\u0006\u0014X#\u0001))\u0007\u0015\u0001h/A\u0004mS:,\u0017M\u001d\u0011)\u0007\u0019\u0001h/A\u0004gC\u000e$xN]:\u0016\u0005\u0005U\u0001cA)\u0002\u0018%\u0019\u0011\u0011\u0004*\u0003\r5\u000bGO]5yQ\r9\u0001O^\u0001\tM\u0006\u001cGo\u001c:tA!\u001a\u0001\u0002\u001d<\u0002\rqJg.\u001b;?)%1\u0016QEA\u0015\u0003[\t\t\u0004C\u0003a\u0013\u0001\u0007!\r\u000b\u0003\u0002&A4\b\"\u0002>\n\u0001\u0004a\b\u0006BA\u0015aZDa!a\u0002\n\u0001\u0004\u0001\u0006\u0006BA\u0017aZDq!!\u0005\n\u0001\u0004\t)\u0002\u000b\u0003\u00022A4H#\u0001,\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0003\u0003w\u00012!`A\u001f\u0013\r\ty\u0004\u001b\u0002\u0004\u0013:$\bfA\u0006qm\u0006aa.^7GK\u0006$XO]3tA!\u001aA\u0002\u001d<\u0002\u000fA\u0014X\rZ5diR\u0019A0a\u0013\t\r\u00055S\u00021\u0001Q\u0003!1W-\u0019;ve\u0016\u001c\bfA\u0007qm\u0006!1m\u001c9z)\r1\u0016Q\u000b\u0005\b\u0003/r\u0001\u0019AA-\u0003\u0015)\u0007\u0010\u001e:b!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0\u0005\u0006)\u0001/\u0019:b[&!\u00111MA/\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\bqm\u0006iQm\u001d;j[\u0006$X\rZ*ju\u0016,\"!a\u001b\u0011\u0007u\fi'C\u0002\u0002p!\u0014A\u0001T8oO\u0006)qO]5uKV\u0011\u0011Q\u000f\t\u00047\u0006]\u0014bAA=9\nAQ\nT,sSR,'\u000fK\u0002\u0011aZ\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002E\"\u001a\u0001\u0001\u001d<\u0002#\u0019k%+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002N'M91#!#\u0002\u0010\u0006U\u0005cA?\u0002\f&\u0019\u0011Q\u00125\u0003\r\u0005s\u0017PU3g!\u0011Y\u0016\u0011\u0013,\n\u0007\u0005MEL\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004B!a&\u0002\"6\u0011\u0011\u0011\u0014\u0006\u0005\u00037\u000bi*\u0001\u0002j_*\u0011\u0011qT\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002$\u0006e%\u0001D*fe&\fG.\u001b>bE2,GCAAC\u0005\u0011!\u0015\r^1\u0014\u000fU\tI)a+\u00022B\u0019Q0!,\n\u0007\u0005=\u0006NA\u0004Qe>$Wo\u0019;\u0011\t\u0005M\u0016Q\u0018\b\u0005\u0003k\u000bILD\u0002f\u0003oK\u0011![\u0005\u0004\u0003wC\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003G\u000byLC\u0002\u0002<\"$\u0002\"a1\u0002H\u0006%\u00171\u001a\t\u0004\u0003\u000b,R\"A\n\t\u000bid\u0002\u0019\u0001?\t\r\u0005\u001dA\u00041\u0001Q\u0011\u001d\t\t\u0002\ba\u0001\u0003+!\u0002\"a1\u0002P\u0006E\u00171\u001b\u0005\buv\u0001\n\u00111\u0001}\u0011!\t9!\bI\u0001\u0002\u0004\u0001\u0006\"CA\t;A\u0005\t\u0019AA\u000b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!7+\u0007q\fYn\u000b\u0002\u0002^B!\u0011q\\At\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018!C;oG\",7m[3e\u0015\t\u0019\b.\u0003\u0003\u0002j\u0006\u0005(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAxU\r\u0001\u00161\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t)P\u000b\u0003\u0002\u0016\u0005m\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002|B!\u0011Q B\u0002\u001b\t\tyP\u0003\u0003\u0003\u0002\u0005u\u0015\u0001\u00027b]\u001eL1!\\A\u0000\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0003\u0003\u0012A\u0019QP!\u0004\n\u0007\t=\u0001NA\u0002B]fD\u0011Ba\u0005$\u0003\u0003\u0005\r!a\u000f\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u0002\u0005\u0004\u0003\u001c\t\u0005\"1B\u0007\u0003\u0005;Q1Aa\bi\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005G\u0011iB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0015\u0005_\u00012! B\u0016\u0013\r\u0011i\u0003\u001b\u0002\b\u0005>|G.Z1o\u0011%\u0011\u0019\"JA\u0001\u0002\u0004\u0011Y!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA~\u0005kA\u0011Ba\u0005'\u0003\u0003\u0005\r!a\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u000f\u0015\u0005\u0005m\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0003*\t\u0005\u0003\"\u0003B\nS\u0005\u0005\t\u0019\u0001B\u0006\u0003\u0011!\u0015\r^1\u0011\u0007\u0005\u00157fE\u0003,\u0005\u0013\n)\n\u0005\u0006\u0003L\tEC\u0010UA\u000b\u0003\u0007l!A!\u0014\u000b\u0007\t=\u0003.A\u0004sk:$\u0018.\\3\n\t\tM#Q\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDC\u0001B#\u0003\u0015\t\u0007\u000f\u001d7z)!\t\u0019Ma\u0017\u0003^\t}\u0003\"\u0002>/\u0001\u0004a\bBBA\u0004]\u0001\u0007\u0001\u000bC\u0004\u0002\u00129\u0002\r!!\u0006\u0002\u000fUt\u0017\r\u001d9msR!!Q\rB9!\u0015i(q\rB6\u0013\r\u0011I\u0007\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fu\u0014i\u0007 )\u0002\u0016%\u0019!q\u000e5\u0003\rQ+\b\u000f\\34\u0011%\u0011\u0019hLA\u0001\u0002\u0004\t\u0019-A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u001f\u0011\t\u0005u(1P\u0005\u0005\u0005{\nyP\u0001\u0004PE*,7\r^\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016$\u0015\r^1\u0015\r\t\r%\u0011\u0012BG!\ri(QQ\u0005\u0004\u0005\u000fC'\u0001B+oSRDqAa#2\u0001\u0004\t\u0019-\u0001\u0003eCR\f\u0007b\u0002BHc\u0001\u0007!\u0011S\u0001\u0004I>\u001c\b\u0003BAL\u0005'KAA!&\u0002\u001a\n\u0001B)\u0019;b\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\u0010I\u0016\u001cXM]5bY&TX\rR1uCR!\u00111\u0019BN\u0011\u001d\u0011iJ\ra\u0001\u0005?\u000b1\u0001Z5t!\u0011\t9J!)\n\t\t\r\u0016\u0011\u0014\u0002\u0010\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\u0006!!/Z1e+\t\u0011I\u000b\u0005\u0003\\\u0005W3\u0016b\u0001BW9\nAQ\n\u0014*fC\u0012,'\u000fK\u00024aZ\fA\u0001\\8bIR\u0019aK!.\t\r\t]F\u00071\u0001c\u0003\u0011\u0001\u0018\r\u001e5)\u0007Q\u0002hOA\fG\u001bJ+wM]3tg&|g.T8eK2<&/\u001b;feN)Q'!\u001e\u0003@B!!\u0011\u0019Bd\u001b\t\u0011\u0019MC\u0002\u0003F\u0012\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0005\u0013\u0014\u0019MA\u0004M_\u001e<\u0017N\\4\u0002\u0011%t7\u000f^1oG\u0016$BAa4\u0003RB\u0019\u0011QY\u001b\t\r\t-w\u00071\u0001W\u0003!\u0019\u0018M^3J[BdG\u0003\u0002BB\u0005/DaAa.9\u0001\u0004\u0011'a\u0006$N%\u0016<'/Z:tS>tWj\u001c3fYJ+\u0017\rZ3s'\rI$\u0011\u0016\u000b\u0003\u0005?\u00042!!2:\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0006dY\u0006\u001c8OT1nK\u0002\"2A\u0016Bt\u0011\u0019\u00119,\u0010a\u0001E\"\u001a1\u0003\u001d<)\u0007I\u0001h\u000f")
public class FMRegressionModel
extends RegressionModel<Vector, FMRegressionModel>
implements FMRegressorParams,
MLWritable {
    private final String uid;
    private final double intercept;
    private final Vector linear;
    private final Matrix factors;
    private final int numFeatures;
    private IntParam factorSize;
    private BooleanParam fitLinear;
    private DoubleParam miniBatchFraction;
    private DoubleParam initStd;
    private Param<String> solver;
    private Param<String> weightCol;
    private DoubleParam regParam;
    private BooleanParam fitIntercept;
    private LongParam seed;
    private DoubleParam tol;
    private DoubleParam stepSize;
    private IntParam maxIter;

    public static FMRegressionModel load(String path) {
        return FMRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<FMRegressionModel> read() {
        return FMRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final int getFactorSize() {
        return FactorizationMachinesParams.getFactorSize$(this);
    }

    @Override
    public final boolean getFitLinear() {
        return FactorizationMachinesParams.getFitLinear$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return FactorizationMachinesParams.getMiniBatchFraction$(this);
    }

    @Override
    public final double getInitStd() {
        return FactorizationMachinesParams.getInitStd$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam factorSize() {
        return this.factorSize;
    }

    @Override
    public final BooleanParam fitLinear() {
        return this.fitLinear;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final DoubleParam initStd() {
        return this.initStd;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$factorSize_$eq(IntParam x$1) {
        this.factorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$fitLinear_$eq(BooleanParam x$1) {
        this.fitLinear = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$initStd_$eq(DoubleParam x$1) {
        this.initStd = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double intercept() {
        return this.intercept;
    }

    public Vector linear() {
        return this.linear;
    }

    public Matrix factors() {
        return this.factors;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public double predict(Vector features) {
        return FactorizationMachines$.MODULE$.getRawPrediction(features, this.intercept(), this.linear(), this.factors());
    }

    @Override
    public FMRegressionModel copy(ParamMap extra) {
        return this.copyValues(new FMRegressionModel(this.uid(), this.intercept(), this.linear(), this.factors()), extra);
    }

    @Override
    public long estimatedSize() {
        long size;
        block1: {
            size = this.estimateMatadataSize();
            if (this.linear() != null) {
                size += this.linear().getSizeInBytes();
            }
            if (this.factors() == null) break block1;
            size += this.factors().getSizeInBytes();
        }
        return size;
    }

    @Override
    public MLWriter write() {
        return new FMRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return "FMRegressionModel: uid=" + Identifiable.toString$(this) + ", numFeatures=" + this.numFeatures() + ", factorSize=" + this.$(this.factorSize()) + ", fitLinear=" + this.$(this.fitLinear()) + ", fitIntercept=" + this.$(this.fitIntercept());
    }

    public FMRegressionModel(String uid, double intercept, Vector linear, Matrix factors) {
        this.uid = uid;
        this.intercept = intercept;
        this.linear = linear;
        this.factors = factors;
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasTol.$init$(this);
        HasSolver.$init$(this);
        HasSeed.$init$(this);
        HasFitIntercept.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        FactorizationMachinesParams.$init$(this);
        MLWritable.$init$(this);
        this.numFeatures = linear.size();
        Statics.releaseFence();
    }

    public FMRegressionModel() {
        this("", Double.NaN, (Vector)Vectors$.MODULE$.empty(), (Matrix)Matrices$.MODULE$.empty());
    }

    public static class Data
    implements Product,
    Serializable {
        private final double intercept;
        private final Vector linear;
        private final Matrix factors;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double intercept() {
            return this.intercept;
        }

        public Vector linear() {
            return this.linear;
        }

        public Matrix factors() {
            return this.factors;
        }

        public Data copy(double intercept, Vector linear, Matrix factors) {
            return new Data(intercept, linear, factors);
        }

        public double copy$default$1() {
            return this.intercept();
        }

        public Vector copy$default$2() {
            return this.linear();
        }

        public Matrix copy$default$3() {
            return this.factors();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this.intercept());
                }
                case 1: {
                    return this.linear();
                }
                case 2: {
                    return this.factors();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "intercept";
                }
                case 1: {
                    return "linear";
                }
                case 2: {
                    return "factors";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2122698);
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.linear()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.factors()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.intercept() != data.intercept()) return false;
            Vector vector = this.linear();
            Vector vector2 = data.linear();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            Matrix matrix = this.factors();
            Matrix matrix2 = data.factors();
            if (matrix == null) {
                if (matrix2 != null) {
                    return false;
                }
            } else if (!matrix.equals(matrix2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(double intercept, Vector linear, Matrix factors) {
            this.intercept = intercept;
            this.linear = linear;
            this.factors = factors;
            Product.$init$((Product)this);
        }
    }

    private static class FMRegressionModelReader
    extends MLReader<FMRegressionModel> {
        private final String className = FMRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public FMRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMRegressionModelReader.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelReader$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.regression.FMRegressionModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelReader$$typecreator1$2(FMRegressionModelReader $outer) {
                }
            }
            Data data = (Data)ReadWriteUtils$.MODULE$.loadObject(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> FMRegressionModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelReader$$typecreator1$2(null)));
            FMRegressionModel model = new FMRegressionModel(metadata.uid(), data.intercept(), data.linear(), data.factors());
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class FMRegressionModelWriter
    extends MLWriter {
        private final FMRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.regression.FMRegressionModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelWriter$$typecreator1$1(FMRegressionModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Data data2 = new Data(this.instance.intercept(), this.instance.linear(), this.instance.factors());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMRegressionModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveObject(dataPath, data2, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                FMRegressionModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelWriter$$typecreator1$1(null)));
        }

        public FMRegressionModelWriter(FMRegressionModel instance) {
            this.instance = instance;
        }
    }
}

