/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005-c!B\u000e\u001d\u0001\u00012\u0003\"C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u001a8\u0011!A\u0004A!b\u0001\n\u0003I\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011!\u0003!Q1A\u0005\u0002eB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0015\u0002\u0011)\u0019!C\u0001\u0017\"Aa\f\u0001B\u0001B\u0003%A\n\u0003\u0005`\u0001\t\u0015\r\u0011\"\u0001a\u0011!!\u0007A!A!\u0002\u0013\t\u0007\"B3\u0001\t\u00031\u0007\"B7\u0001\t\u0003q\u0007b\u0002:\u0001\u0005\u0004%\t%\u000f\u0005\u0007g\u0002\u0001\u000b\u0011\u0002\u001e\t\u000bQ\u0004A\u0011\t8\t\u000bU\u0004A\u0011\t8\t\u000bY\u0004A\u0011\t8\t\u000b]\u0004A\u0011\t8\t\u000ba\u0004A\u0011\t8\t\u000be\u0004A\u0011\t>\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!1\u0011Q\u0003\u0001\u0005BeBq!a\u0006\u0001\t\u0013\tIb\u0002\u0006\u0002&q\t\t\u0011#\u0001!\u0003O1\u0011b\u0007\u000f\u0002\u0002#\u0005\u0001%!\u000b\t\r\u0015DB\u0011AA\u0019\u0011%\t\u0019\u0004GI\u0001\n\u0003\t)D\u0001\fLk\n,'O\\3uKN,\u00050Z2vi>\u00148i\u001c8g\u0015\tib$A\u0002lqMT!a\b\u0011\u0002\r\u0011,\u0007\u000f\\8z\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7c\u0001\u0001(WA\u0011\u0001&K\u0007\u00029%\u0011!\u0006\b\u0002\u000f\u0017V\u0014WM\u001d8fi\u0016\u001c8i\u001c8g!\tas&D\u0001.\u0015\tq\u0003%\u0001\u0005j]R,'O\\1m\u0013\t\u0001TFA\u0004M_\u001e<\u0017N\\4\u0002\u0013M\u0004\u0018M]6D_:47\u0001\u0001\t\u0003iUj\u0011\u0001I\u0005\u0003m\u0001\u0012\u0011b\u00159be.\u001cuN\u001c4\n\u0005EJ\u0013!B1qa&#W#\u0001\u001e\u0011\u0005m\"eB\u0001\u001fC!\ti\u0004)D\u0001?\u0015\ty$'\u0001\u0004=e>|GO\u0010\u0006\u0002\u0003\u0006)1oY1mC&\u00111\tQ\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002D\u0001\u00061\u0011\r\u001d9JI\u0002\n!\"\u001a=fGV$xN]%e\u0003-)\u00070Z2vi>\u0014\u0018\n\u001a\u0011\u0002\u0013\u0011\u0014\u0018N^3s!>$W#\u0001'\u0011\u00075s\u0005+D\u0001A\u0013\ty\u0005I\u0001\u0004PaRLwN\u001c\t\u0003#rk\u0011A\u0015\u0006\u0003'R\u000bQ!\\8eK2T!!\u0016,\u0002\u0007\u0005\u0004\u0018N\u0003\u0002X1\u0006Q1.\u001e2fe:,G/Z:\u000b\u0005eS\u0016a\u00024bEJL7\r\u000f\u0006\u00027\u0006\u0011\u0011n\\\u0005\u0003;J\u00131\u0001U8e\u0003)!'/\u001b<feB{G\rI\u0001\u0012e\u0016\u001cx.\u001e:dKB\u0013xNZ5mK&#W#A1\u0011\u00055\u0013\u0017BA2A\u0005\rIe\u000e^\u0001\u0013e\u0016\u001cx.\u001e:dKB\u0013xNZ5mK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0007O\"L'n\u001b7\u0011\u0005!\u0002\u0001\"B\u0019\u000b\u0001\u0004\u0019\u0004\"\u0002\u001d\u000b\u0001\u0004Q\u0004\"\u0002%\u000b\u0001\u0004Q\u0004\"\u0002&\u000b\u0001\u0004a\u0005bB0\u000b!\u0003\u0005\r!Y\u0001\u0015Kb,7-\u001e;pe:{G-Z*fY\u0016\u001cGo\u001c:\u0016\u0003=\u0004Ba\u000f9;u%\u0011\u0011O\u0012\u0002\u0004\u001b\u0006\u0004\u0018A\u0005:fg>,(oY3OC6,\u0007K]3gSb\f1C]3t_V\u00148-\u001a(b[\u0016\u0004&/\u001a4jq\u0002\na\u0001\\1cK2\u001c\u0018aC3om&\u0014xN\\7f]R\f1\"\u00198o_R\fG/[8og\u000692/Z2sKRt\u0015-\\3t)>lu.\u001e8u!\u0006$\bn]\u0001\u0018g\u0016\u001c'/\u001a;F]Zt\u0015-\\3t)>\\U-\u001f*fMN\fqA^8mk6,7/F\u0001|!\u0015a\u00181AA\u0005\u001d\tixP\u0004\u0002>}&\t\u0011)C\u0002\u0002\u0002\u0001\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0006\u0005\u001d!aA*fc*\u0019\u0011\u0011\u0001!\u0011\u0007!\nY!C\u0002\u0002\u000eq\u0011AcS;cKJtW\r^3t->dW/\\3Ta\u0016\u001c\u0017!D:dQ\u0016$W\u000f\\3s\u001d\u0006lW-\u0006\u0002\u0002\u0014A\u0019QJ\u0014\u001e\u0002\u000b%l\u0017mZ3\u0002'\rDWmY6Fq\u0016\u001cW\u000f^8s\u000b:48*Z=\u0015\t\u0005m\u0011\u0011\u0005\t\u0004\u001b\u0006u\u0011bAA\u0010\u0001\n9!i\\8mK\u0006t\u0007BBA\u0012-\u0001\u0007!(A\u0002lKf\facS;cKJtW\r^3t\u000bb,7-\u001e;pe\u000e{gN\u001a\t\u0003Qa\u00192\u0001GA\u0016!\ri\u0015QF\u0005\u0004\u0003_\u0001%AB!osJ+g\r\u0006\u0002\u0002(\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!a\u000e+\u0007\u0005\fId\u000b\u0002\u0002<A!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013!C;oG\",7m[3e\u0015\r\t)\u0005Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA%\u0003\u007f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class KubernetesExecutorConf
extends KubernetesConf
implements Logging {
    private final String appId;
    private final String executorId;
    private final Option<Pod> driverPod;
    private final int resourceProfileId;
    private final String resourceNamePrefix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int $lessinit$greater$default$5() {
        return KubernetesExecutorConf$.MODULE$.$lessinit$greater$default$5();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String appId() {
        return this.appId;
    }

    public String executorId() {
        return this.executorId;
    }

    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    public int resourceProfileId() {
        return this.resourceProfileId;
    }

    public scala.collection.immutable.Map<String, String> executorNodeSelector() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_NODE_SELECTOR_PREFIX());
    }

    @Override
    public String resourceNamePrefix() {
        return this.resourceNamePrefix;
    }

    @Override
    public scala.collection.immutable.Map<String, String> labels() {
        scala.collection.immutable.Map presetLabels = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_VERSION_LABEL()), (Object)package$.MODULE$.SPARK_VERSION()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Object)this.executorId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_NAME_LABEL()), (Object)KubernetesConf$.MODULE$.getAppNameLabel(this.appName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()), (Object)Integer.toString(this.resourceProfileId()))}));
        scala.collection.immutable.Map executorCustomLabels = (scala.collection.immutable.Map)KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_LABEL_PREFIX()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, this.appId(), this.executorId()));
            }
            throw new MatchError((Object)tuple2);
        });
        presetLabels.keys().foreach((Function1 & Serializable)key -> {
            Predef$.MODULE$.require(!executorCustomLabels.contains((Object)key), (Function0 & Serializable)() -> "Custom executor labels cannot contain " + key + " as it is reserved for Spark.");
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)executorCustomLabels.$plus$plus((IterableOnce)presetLabels);
    }

    @Override
    public scala.collection.immutable.Map<String, String> environment() {
        return ((IterableOnceOps)super.sparkConf().getExecutorEnv().filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)this.checkExecutorEnvKey((String)p._1())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public scala.collection.immutable.Map<String, String> annotations() {
        return (scala.collection.immutable.Map)KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, this.appId(), this.executorId()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public scala.collection.immutable.Map<String, String> secretNamesToMountPaths() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_SECRETS_PREFIX());
    }

    @Override
    public scala.collection.immutable.Map<String, String> secretEnvNamesToKeyRefs() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX());
    }

    @Override
    public Seq<KubernetesVolumeSpec> volumes() {
        return KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(super.sparkConf(), Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX());
    }

    @Override
    public Option<String> schedulerName() {
        return Option$.MODULE$.apply(((Option)this.get(Config$.MODULE$.KUBERNETES_EXECUTOR_SCHEDULER_NAME())).getOrElse((Function0 & Serializable)() -> (String)((Option)this.get(Config$.MODULE$.KUBERNETES_SCHEDULER_NAME())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    @Override
    public String image() {
        return (String)this.get(Config$.MODULE$.EXECUTOR_CONTAINER_IMAGE()).map((Function1 & Serializable)opt -> Utils$.MODULE$.substituteSparkVersion(opt)).getOrElse((Function0 & Serializable)() -> {
            throw new SparkException("Must specify the executor container image");
        });
    }

    private boolean checkExecutorEnvKey(String key) {
        Regex executorEnvRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[-._a-zA-Z][-._a-zA-Z0-9]*"));
        if (executorEnvRegex.pattern().matcher(key).matches()) {
            return true;
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid key: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CONFIG, key)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a valid environment variable name must consist of alphabetic characters, "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"digits, '_', '-', or '.', and must not start with a digit. "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Regex used for validation is '", "'"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EXECUTOR_ENV_REGEX, executorEnvRegex)})))));
        return false;
    }

    public KubernetesExecutorConf(SparkConf sparkConf, String appId, String executorId, Option<Pod> driverPod, int resourceProfileId) {
        this.appId = appId;
        this.executorId = executorId;
        this.driverPod = driverPod;
        this.resourceProfileId = resourceProfileId;
        super(sparkConf);
        Logging.$init$((Logging)this);
        this.resourceNamePrefix = (String)((Option)this.get(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX())).getOrElse((Function0 & Serializable)() -> KubernetesConf$.MODULE$.getResourceNamePrefix(this.appName()));
    }
}

