/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$BooleanConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$ByteConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$DateConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$DoubleConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$FloatConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$InstantConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$IntConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$LocalDateConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$LongConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$ShortConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$StringConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$TimeConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$TimestampConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$TimestampNTZConverter$;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArraySeq;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CatalystTypeConverters$ {
    public static final CatalystTypeConverters$ MODULE$ = new CatalystTypeConverters$();

    public boolean isPrimitive(DataType dataType) {
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return true;
        }
        return DoubleType$.MODULE$.equals(dataType2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public CatalystTypeConverters.CatalystTypeConverter<Object, Object, Object> org$apache$spark$sql$catalyst$CatalystTypeConverters$$getConverterForType(DataType dataType) {
        block30: {
            block42: {
                block41: {
                    block40: {
                        block39: {
                            block38: {
                                block37: {
                                    block36: {
                                        block35: {
                                            block34: {
                                                block33: {
                                                    block32: {
                                                        block31: {
                                                            block29: {
                                                                var5_2 = false;
                                                                var6_3 = null;
                                                                var7_4 = false;
                                                                var8_5 = null;
                                                                var9_6 = false;
                                                                var10_7 = null;
                                                                var11_8 = dataType;
                                                                if (!(var11_8 instanceof UserDefinedType)) break block29;
                                                                var12_9 = (UserDefinedType)var11_8;
                                                                v0 /* !! */  = new CatalystTypeConverters.UDTConverter<A>(var12_9);
                                                                break block30;
                                                            }
                                                            if (!(var11_8 instanceof ArrayType)) break block31;
                                                            var13_10 = (ArrayType)var11_8;
                                                            v0 /* !! */  = new CatalystTypeConverters.ArrayConverter(var13_10.elementType());
                                                            break block30;
                                                        }
                                                        if (!(var11_8 instanceof MapType)) break block32;
                                                        var14_11 = (MapType)var11_8;
                                                        v0 /* !! */  = new CatalystTypeConverters.MapConverter(var14_11.keyType(), var14_11.valueType());
                                                        break block30;
                                                    }
                                                    if (!(var11_8 instanceof StructType)) break block33;
                                                    var15_12 = (StructType)var11_8;
                                                    v0 /* !! */  = new CatalystTypeConverters.StructConverter(var15_12);
                                                    break block30;
                                                }
                                                if (!(var11_8 instanceof CharType)) break block34;
                                                var16_13 = (CharType)var11_8;
                                                length = var16_13.length();
                                                v0 /* !! */  = new CatalystTypeConverters.CharConverter(length);
                                                break block30;
                                            }
                                            if (!(var11_8 instanceof VarcharType)) break block35;
                                            var18_15 = (VarcharType)var11_8;
                                            length = var18_15.length();
                                            v0 /* !! */  = new CatalystTypeConverters.VarcharConverter(length);
                                            break block30;
                                        }
                                        if (!(var11_8 instanceof StringType)) break block36;
                                        v0 /* !! */  = CatalystTypeConverters$StringConverter$.MODULE$;
                                        break block30;
                                    }
                                    if ((var11_8 instanceof GeographyType != false ? true : var11_8 instanceof GeometryType != false) && !SQLConf$.MODULE$.get().geospatialEnabled()) {
                                        throw new AnalysisException("UNSUPPORTED_FEATURE.GEOSPATIAL_DISABLED", Map$.MODULE$.empty());
                                    }
                                    if (!(var11_8 instanceof GeographyType)) break block37;
                                    var20_17 = (GeographyType)var11_8;
                                    v0 /* !! */  = new CatalystTypeConverters.GeographyConverter(var20_17);
                                    break block30;
                                }
                                if (!(var11_8 instanceof GeometryType)) break block38;
                                var21_18 = (GeometryType)var11_8;
                                v0 /* !! */  = new CatalystTypeConverters.GeometryConverter(var21_18);
                                break block30;
                            }
                            if (!DateType$.MODULE$.equals(var11_8)) break block39;
                            var5_2 = true;
                            var6_3 = var11_8;
                            if (!SQLConf$.MODULE$.get().datetimeJava8ApiEnabled()) break block39;
                            v0 /* !! */  = CatalystTypeConverters$LocalDateConverter$.MODULE$;
                            break block30;
                        }
                        if (!var5_2) break block40;
                        v0 /* !! */  = CatalystTypeConverters$DateConverter$.MODULE$;
                        break block30;
                    }
                    if (!(var11_8 instanceof TimeType)) break block41;
                    var7_4 = true;
                    var8_5 = (TimeType)var11_8;
                    if (SQLConf$.MODULE$.get().isTimeTypeEnabled()) break block41;
                    v0 /* !! */  = QueryCompilationErrors$.MODULE$.unsupportedTimeTypeError();
                    break block30;
                }
                if (!var7_4) break block42;
                v0 /* !! */  = CatalystTypeConverters$TimeConverter$.MODULE$;
                break block30;
            }
            if (!TimestampType$.MODULE$.equals(var11_8)) ** GOTO lbl-1000
            var9_6 = true;
            var10_7 = var11_8;
            if (SQLConf$.MODULE$.get().datetimeJava8ApiEnabled()) {
                v0 /* !! */  = CatalystTypeConverters$InstantConverter$.MODULE$;
            } else if (var9_6) {
                v0 /* !! */  = CatalystTypeConverters$TimestampConverter$.MODULE$;
            } else if (TimestampNTZType$.MODULE$.equals(var11_8)) {
                v0 /* !! */  = CatalystTypeConverters$TimestampNTZConverter$.MODULE$;
            } else if (var11_8 instanceof DecimalType) {
                var22_19 = (DecimalType)var11_8;
                v0 /* !! */  = new CatalystTypeConverters.DecimalConverter(var22_19);
            } else if (BooleanType$.MODULE$.equals(var11_8)) {
                v0 /* !! */  = CatalystTypeConverters$BooleanConverter$.MODULE$;
            } else if (ByteType$.MODULE$.equals(var11_8)) {
                v0 /* !! */  = CatalystTypeConverters$ByteConverter$.MODULE$;
            } else if (ShortType$.MODULE$.equals(var11_8)) {
                v0 /* !! */  = CatalystTypeConverters$ShortConverter$.MODULE$;
            } else if (IntegerType$.MODULE$.equals(var11_8)) {
                v0 /* !! */  = CatalystTypeConverters$IntConverter$.MODULE$;
            } else if (LongType$.MODULE$.equals(var11_8)) {
                v0 /* !! */  = CatalystTypeConverters$LongConverter$.MODULE$;
            } else if (FloatType$.MODULE$.equals(var11_8)) {
                v0 /* !! */  = CatalystTypeConverters$FloatConverter$.MODULE$;
            } else if (DoubleType$.MODULE$.equals(var11_8)) {
                v0 /* !! */  = CatalystTypeConverters$DoubleConverter$.MODULE$;
            } else if (var11_8 instanceof DayTimeIntervalType) {
                var23_20 = (DayTimeIntervalType)var11_8;
                endField = var23_20.endField();
                v0 /* !! */  = new CatalystTypeConverters.DurationConverter(endField);
            } else if (var11_8 instanceof YearMonthIntervalType) {
                var25_22 = (YearMonthIntervalType)var11_8;
                endField = var25_22.endField();
                v0 /* !! */  = new CatalystTypeConverters.PeriodConverter(endField);
            } else if (var11_8 != null) {
                var27_24 = var11_8;
                v0 /* !! */  = new CatalystTypeConverters.IdentityConverter(var27_24);
            } else {
                throw new MatchError((Object)var11_8);
            }
        }
        converter = v0 /* !! */ ;
        return converter;
    }

    public void org$apache$spark$sql$catalyst$CatalystTypeConverters$$assertGeospatialEnabled() {
        if (!SQLConf$.MODULE$.get().geospatialEnabled()) {
            throw new AnalysisException("UNSUPPORTED_FEATURE.GEOSPATIAL_DISABLED", Map$.MODULE$.empty());
        }
    }

    public Function1<Object, Object> createToCatalystConverter(DataType dataType) {
        if (this.isPrimitive(dataType)) {
            return (Function1 & Serializable)maybeScalaValue -> CatalystTypeConverters$.convert$1(maybeScalaValue);
        }
        CatalystTypeConverters.CatalystTypeConverter<Object, Object, Object> catalystTypeConverter = this.org$apache$spark$sql$catalyst$CatalystTypeConverters$$getConverterForType(dataType);
        return (Function1 & Serializable)maybeScalaValue -> catalystTypeConverter.toCatalyst(maybeScalaValue);
    }

    public Function1<Object, Object> createToScalaConverter(DataType dataType) {
        if (this.isPrimitive(dataType)) {
            return (Function1 & Serializable)x -> Predef$.MODULE$.identity(x);
        }
        CatalystTypeConverters.CatalystTypeConverter<Object, Object, Object> catalystTypeConverter = this.org$apache$spark$sql$catalyst$CatalystTypeConverters$$getConverterForType(dataType);
        return (Function1 & Serializable)catalystValue -> catalystTypeConverter.toScala(catalystValue);
    }

    public Object convertToCatalyst(Object a2) {
        Object object;
        while (true) {
            if ((object = a2) instanceof String) {
                String string = (String)object;
                return CatalystTypeConverters$StringConverter$.MODULE$.toCatalyst(string);
            }
            if (object instanceof Character) {
                char c = BoxesRunTime.unboxToChar((Object)object);
                return CatalystTypeConverters$StringConverter$.MODULE$.toCatalyst(Character.toString(c));
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                return CatalystTypeConverters$DateConverter$.MODULE$.toCatalyst(date);
            }
            if (object instanceof LocalDate) {
                LocalDate localDate = (LocalDate)object;
                return CatalystTypeConverters$LocalDateConverter$.MODULE$.toCatalyst(localDate);
            }
            if (object instanceof LocalTime) {
                LocalTime localTime = (LocalTime)object;
                return CatalystTypeConverters$TimeConverter$.MODULE$.toCatalyst(localTime);
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                return CatalystTypeConverters$TimestampConverter$.MODULE$.toCatalyst(timestamp);
            }
            if (object instanceof Instant) {
                Instant instant = (Instant)object;
                return CatalystTypeConverters$InstantConverter$.MODULE$.toCatalyst(instant);
            }
            if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                return CatalystTypeConverters$TimestampNTZConverter$.MODULE$.toCatalyst(localDateTime);
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                return new CatalystTypeConverters.DecimalConverter(new DecimalType(Math.max(bigDecimal.precision(), bigDecimal.scale()), bigDecimal.scale())).toCatalyst(bigDecimal);
            }
            if (object instanceof java.math.BigDecimal) {
                java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
                return new CatalystTypeConverters.DecimalConverter(new DecimalType(Math.max(bigDecimal.precision(), bigDecimal.scale()), bigDecimal.scale())).toCatalyst(bigDecimal);
            }
            if (!(object instanceof ArraySeq)) break;
            ArraySeq arraySeq = (ArraySeq)object;
            a2 = arraySeq.array();
        }
        if (object instanceof Seq) {
            Seq seq = (Seq)object;
            return new GenericArrayData((Object[])((IterableOnceOps)seq.map((Function1 & Serializable)a -> MODULE$.convertToCatalyst(a))).toArray(ClassTag$.MODULE$.Any()));
        }
        if (object instanceof Row) {
            Row row = (Row)object;
            return InternalRow$.MODULE$.apply((Seq<Object>)((Seq)row.toSeq().map((Function1 & Serializable)a -> MODULE$.convertToCatalyst(a))));
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return byArray;
        }
        if (object instanceof char[]) {
            char[] cArray = (char[])object;
            return CatalystTypeConverters$StringConverter$.MODULE$.toCatalyst(cArray);
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return new GenericArrayData((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(object2), (Function1 & Serializable)a -> MODULE$.convertToCatalyst(a), ClassTag$.MODULE$.Any()));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ArrayBasedMapData$.MODULE$.apply(map, (Function1<Object, Object>)(Function1 & Serializable)key -> MODULE$.convertToCatalyst(key), (Function1<Object, Object>)(Function1 & Serializable)value -> MODULE$.convertToCatalyst(value));
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return new CatalystTypeConverters.DurationConverter(DayTimeIntervalType$.MODULE$.SECOND()).toCatalyst(duration);
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return new CatalystTypeConverters.PeriodConverter(YearMonthIntervalType$.MODULE$.MONTH()).toCatalyst(period);
        }
        return object;
    }

    public Object convertToScala(Object catalystValue, DataType dataType) {
        return this.createToScalaConverter(dataType).apply(catalystValue);
    }

    private static final Object convert$1(Object maybeScalaValue) {
        Object object = maybeScalaValue;
        if (object instanceof Option) {
            Option option = (Option)object;
            return option.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return maybeScalaValue;
    }

    private CatalystTypeConverters$() {
    }
}

