/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.resolver.CoercesExpressionTypes;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversal;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesExpressionChildren;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.SemiStructuredExtract;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.variant.VariantGet;
import org.apache.spark.sql.catalyst.expressions.variant.VariantGet$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t3AAB\u0004\u0001-!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00035\u0001\u0011\u0005Q\u0007C\u00049\u0001\t\u0007I\u0011B\u001d\t\ru\u0002\u0001\u0015!\u0003;\u0011\u0015q\u0004\u0001\"\u0011@\u0005u\u0019V-\\5TiJ,8\r^;sK\u0012,\u0005\u0010\u001e:bGR\u0014Vm]8mm\u0016\u0014(B\u0001\u0005\n\u0003!\u0011Xm]8mm\u0016\u0014(B\u0001\u0006\f\u0003!\tg.\u00197zg&\u001c(B\u0001\u0007\u000e\u0003!\u0019\u0017\r^1msN$(B\u0001\b\u0010\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0012aA8sO\u000e\u00011#\u0002\u0001\u0018;)j\u0003C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0003\u001f?\u0005:S\"A\u0004\n\u0005\u0001:!\u0001\u0005+sK\u0016tu\u000eZ3SKN|GN^3s!\t\u0011S%D\u0001$\u0015\t!3\"A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001\u0014$\u0005U\u0019V-\\5TiJ,8\r^;sK\u0012,\u0005\u0010\u001e:bGR\u0004\"A\t\u0015\n\u0005%\u001a#AC#yaJ,7o]5p]B\u0011adK\u0005\u0003Y\u001d\u0011!DU3t_24Xm]#yaJ,7o]5p]\u000eC\u0017\u000e\u001c3sK:\u0004\"A\b\u0018\n\u0005=:!AF\"pKJ\u001cWm]#yaJ,7o]5p]RK\b/Z:\u0002%\u0015D\bO]3tg&|gNU3t_24XM\u001d\t\u0003=IJ!aM\u0004\u0003%\u0015C\bO]3tg&|gNU3t_24XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Y:\u0004C\u0001\u0010\u0001\u0011\u0015\u0001$\u00011\u00012\u0003}!\u0018.\\3{_:,\u0017i^1sK\u0016C\bO]3tg&|gNU3t_24XM]\u000b\u0002uA\u0011adO\u0005\u0003y\u001d\u0011q\u0004V5nKj|g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8SKN|GN^3s\u0003\u0001\"\u0018.\\3{_:,\u0017i^1sK\u0016C\bO]3tg&|gNU3t_24XM\u001d\u0011\u0002\u000fI,7o\u001c7wKR\u0011q\u0005\u0011\u0005\u0006\u0003\u0016\u0001\r!I\u0001\u0016g\u0016l\u0017n\u0015;sk\u000e$XO]3e\u000bb$(/Y2u\u0001")
public class SemiStructuredExtractResolver
implements TreeNodeResolver<SemiStructuredExtract, Expression>,
ResolvesExpressionChildren,
CoercesExpressionTypes {
    private final ExpressionResolver expressionResolver;
    private final TimezoneAwareExpressionResolver timezoneAwareExpressionResolver;
    private Seq<Function1<Expression, Expression>> ansiTransformations;
    private Seq<Function1<Expression, Expression>> nonAnsiTransformations;

    @Override
    public Expression coerceExpressionTypes(Expression expression, ExpressionTreeTraversal expressionTreeTraversal) {
        return CoercesExpressionTypes.coerceExpressionTypes$(this, expression, expressionTreeTraversal);
    }

    @Override
    public Expression withResolvedChildren(UnaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(BinaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(TernaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(QuaternaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(Expression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public Seq<Function1<Expression, Expression>> ansiTransformations() {
        return this.ansiTransformations;
    }

    @Override
    public Seq<Function1<Expression, Expression>> nonAnsiTransformations() {
        return this.nonAnsiTransformations;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$ansiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.ansiTransformations = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$nonAnsiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.nonAnsiTransformations = x$1;
    }

    private TimezoneAwareExpressionResolver timezoneAwareExpressionResolver() {
        return this.timezoneAwareExpressionResolver;
    }

    @Override
    public Expression resolve(SemiStructuredExtract semiStructuredExtract) {
        SemiStructuredExtract semiStructuredExtractWithResolvedChildren = (SemiStructuredExtract)this.withResolvedChildren(semiStructuredExtract, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression));
        DataType dataType = semiStructuredExtractWithResolvedChildren.child().dataType();
        if (!(dataType instanceof VariantType)) {
            throw new AnalysisException("COLUMN_IS_NOT_VARIANT_TYPE", Predef$.MODULE$.Map().empty());
        }
        VariantGet extractResult = new VariantGet(semiStructuredExtractWithResolvedChildren.child(), Literal$.MODULE$.apply(UTF8String.fromString((String)semiStructuredExtractWithResolvedChildren.field())), (DataType)VariantType$.MODULE$, true, VariantGet$.MODULE$.apply$default$5());
        Expression semiStructuredExtractWithProperExtractionMethod = this.timezoneAwareExpressionResolver().resolve(extractResult);
        return this.coerceExpressionTypes(semiStructuredExtractWithProperExtractionMethod, this.expressionResolver.getExpressionTreeTraversals().current());
    }

    public SemiStructuredExtractResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesExpressionChildren.$init$(this);
        CoercesExpressionTypes.$init$(this);
        this.timezoneAwareExpressionResolver = expressionResolver.getTimezoneAwareExpressionResolver();
        Statics.releaseFence();
    }
}

