/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayRemove$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array, element) - Remove all elements that equal to element from array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null, 3), 3);\n       [1,2,null]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\tmb\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005%\"Aa\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003S\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015Q\b\u0001\"\u0003d\u0011!Y\b\u0001#b\u0001\n\u0013a\bbBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!a\u0017\u0001\t\u0003\ni\u0006C\u0004\u0002`\u0001!\t&!\u0019\t\u0013\u0005-\u0004!!A\u0005\u0002\u00055\u0004\"CA:\u0001E\u0005I\u0011AA;\u0011%\tY\tAI\u0001\n\u0003\t)\bC\u0005\u0002\u000e\u0002\t\t\u0011\"\u0011\u0002\u0010\"I\u0011q\u0014\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0015\u0005\n\u0003S\u0003\u0011\u0011!C\u0001\u0003WC\u0011\"!-\u0001\u0003\u0003%\t%a-\t\u0013\u0005\u0005\u0007!!A\u0005\u0002\u0005\r\u0007\"CAd\u0001\u0005\u0005I\u0011IAe\u0011%\ti\rAA\u0001\n\u0003\nymB\u0005\u0002t\u000e\n\t\u0011#\u0001\u0002v\u001aA!eIA\u0001\u0012\u0003\t9\u0010\u0003\u0004Y9\u0011\u0005!q\u0002\u0005\n\u0005#a\u0012\u0011!C#\u0005'A\u0011B!\u0006\u001d\u0003\u0003%\tIa\u0006\t\u0013\tuA$!A\u0005\u0002\n}\u0001\"\u0003B\u00199\u0005\u0005I\u0011\u0002B\u001a\u0005-\t%O]1z%\u0016lwN^3\u000b\u0005\u0011*\u0013aC3yaJ,7o]5p]NT!AJ\u0014\u0002\u0011\r\fG/\u00197zgRT!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00196qy\"\u0005C\u0001\u001a4\u001b\u0005\u0019\u0013B\u0001\u001b$\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00023m%\u0011qg\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0011\bP\u0007\u0002u)\u00111hJ\u0001\u0007KJ\u0014xN]:\n\u0005uR$aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\u000fA\u0013x\u000eZ;diB\u0011Q)\u0014\b\u0003\r.s!a\u0012&\u000e\u0003!S!!S\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0015B\u0001'A\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00051\u0003\u0015\u0001\u00027fMR,\u0012A\u0015\t\u0003eMK!\u0001V\u0012\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007i[F\f\u0005\u00023\u0001!)\u0001+\u0002a\u0001%\")a+\u0002a\u0001%\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#A0\u0011\u0005}\u0002\u0017BA1A\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002IB\u0011Q\r[\u0007\u0002M*\u0011qmJ\u0001\u0006if\u0004Xm]\u0005\u0003S\u001a\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00017\u0011\u0007\u0015kw.\u0003\u0002o\u001f\n\u00191+Z9\u0011\u0005\u0015\u0004\u0018BA9g\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001u!\t)\b0D\u0001w\u0015\t9X%\u0001\u0005b]\u0006d\u0017p]5t\u0013\tIhOA\bUsB,7\t[3dWJ+7/\u001e7u\u0003-)G.Z7f]R$\u0016\u0010]3\u0002\u0011=\u0014H-\u001a:j]\u001e,\u0012! \t\u0005\u000bz\f\t!\u0003\u0002\u0000\u001f\nAqJ\u001d3fe&tw\rE\u0002@\u0003\u0007I1!!\u0002A\u0005\r\te.\u001f\u0015\u0004\u0017\u0005%\u0001cA \u0002\f%\u0019\u0011Q\u0002!\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCBA\u0001\u0003'\t9\u0002C\u0004\u0002\u00161\u0001\r!!\u0001\u0002\u0007\u0005\u0014(\u000fC\u0004\u0002\u001a1\u0001\r!!\u0001\u0002\u000bY\fG.^3\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u0010\u0003W\t)\u0004\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)cI\u0001\bG>$WmZ3o\u0013\u0011\tI#a\t\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\f\u000e\u0001\u0004\ty#A\u0002dib\u0004B!!\t\u00022%!\u00111GA\u0012\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\u000e\u000e\u0001\u0004\ty\"\u0001\u0002fm\u0006\u0001r-\u001a8D_\u0012,gi\u001c:SKN,H\u000e\u001e\u000b\r\u0003{\ti%a\u0014\u0002R\u0005U\u0013q\u000b\t\u0005\u0003\u007f\t9E\u0004\u0003\u0002B\u0005\r\u0003CA$A\u0013\r\t)\u0005Q\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00131\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0003\tC\u0004\u0002.9\u0001\r!a\f\t\u000f\u0005]b\u00021\u0001\u0002 !9\u00111\u000b\bA\u0002\u0005u\u0012AC5oaV$\u0018I\u001d:bs\"9\u0011\u0011\u0004\bA\u0002\u0005u\u0002bBA-\u001d\u0001\u0007\u0011QH\u0001\r]\u0016<\u0018I\u001d:bsNK'0Z\u0001\u000baJ,G\u000f^=OC6,WCAA\u001f\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003[\u0003G\n9\u0007\u0003\u0004\u0002fA\u0001\rAU\u0001\b]\u0016<H*\u001a4u\u0011\u0019\tI\u0007\u0005a\u0001%\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#\u0002.\u0002p\u0005E\u0004b\u0002)\u0012!\u0003\u0005\rA\u0015\u0005\b-F\u0001\n\u00111\u0001S\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001e+\u0007I\u000bIh\u000b\u0002\u0002|A!\u0011QPAD\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015!C;oG\",7m[3e\u0015\r\t)\tQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAE\u0003\u007f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000bA\u0001\\1oO*\u0011\u00111T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005U\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAR!\ry\u0014QU\u0005\u0004\u0003O\u0003%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0001\u0003[C\u0011\"a,\u0017\u0003\u0003\u0005\r!a)\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\f\u0005\u0004\u00028\u0006u\u0016\u0011A\u0007\u0003\u0003sS1!a/A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\u000bIL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA0\u0002F\"I\u0011q\u0016\r\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0012\u0006-\u0007\"CAX3\u0005\u0005\t\u0019AAR\u0003\u0019)\u0017/^1mgR\u0019q,!5\t\u0013\u0005=&$!AA\u0002\u0005\u0005\u0001f\u0005\u0001\u0002V\u0006m\u0017Q\\Aq\u0003G\f9/!;\u0002n\u0006=\bc\u0001\u001a\u0002X&\u0019\u0011\u0011\\\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011q\\\u0001O?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0017!K2,W.\u001a8uS\u0001j\u0003EU3n_Z,\u0007%\u00197mA\u0015dW-\\3oiN\u0004C\u000f[1uA\u0015\fX/\u00197!i>\u0004S\r\\3nK:$\bE\u001a:p[\u0002\n'O]1z]\u0005AQ\r_1na2,7/\t\u0002\u0002f\u00061&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e1\u00023\u0007\f\u0011ok2dG\u0006I\u001a*Y\u0001\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012DF\\;mYvS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003W\f1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011_\u0001\u0006e9\"d\u0006M\u0001\f\u0003J\u0014\u0018-\u001f*f[>4X\r\u0005\u000239M)A$!?\u0003\u0006A9\u00111 B\u0001%JSVBAA\u007f\u0015\r\ty\u0010Q\u0001\beVtG/[7f\u0013\u0011\u0011\u0019!!@\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\u0011\u0011Y!!'\u0002\u0005%|\u0017b\u0001(\u0003\nQ\u0011\u0011Q_\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011S\u0001\u0006CB\u0004H.\u001f\u000b\u00065\ne!1\u0004\u0005\u0006!~\u0001\rA\u0015\u0005\u0006-~\u0001\rAU\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tC!\f\u0011\u000b}\u0012\u0019Ca\n\n\u0007\t\u0015\u0002I\u0001\u0004PaRLwN\u001c\t\u0006\u007f\t%\"KU\u0005\u0004\u0005W\u0001%A\u0002+va2,'\u0007\u0003\u0005\u00030\u0001\n\t\u00111\u0001[\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005k\u0001B!a%\u00038%!!\u0011HAK\u0005\u0019y%M[3di\u0002")
public class ArrayRemove
extends BinaryExpression
implements ImplicitCastInputTypes,
QueryErrorsBase,
Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRemove x$0) {
        return ArrayRemove$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRemove> tupled() {
        return ArrayRemove$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRemove>> curried() {
        return ArrayRemove$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    return new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                }
                return (Seq)package$.MODULE$.Seq().empty();
            }
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType && DataTypeUtils$.MODULE$.sameType(e1 = (arrayType = (ArrayType)dataType).elementType(), e2)) {
                return TypeUtils$.MODULE$.checkForOrderingExpr(e2, this.prettyName());
            }
        }
        return new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
    }

    private DataType elementType() {
        return ((ArrayType)this.left().dataType()).elementType();
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayRemove arrayRemove = this;
        synchronized (arrayRemove) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if (!this.bitmap$trans$0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object[] newArray = new Object[((ArrayData)arr).numElements()];
        IntRef pos = IntRef.create((int)0);
        ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
            ArrayRemove.$anonfun$nullSafeEval$12(this, value, newArray, pos, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        return new GenericArrayData((Object[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.genericArrayOps((Object)newArray), 0, pos.elem));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(arr, value) -> {
            String numsToRemove = ctx.freshName("numsToRemove");
            String newArraySize = ctx.freshName("newArraySize");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.elementType(), i);
            String isEqual = ctx.genEqual(this.elementType(), (String)value, getValue);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |int " + numsToRemove + " = 0;\n         |for (int " + i + " = 0; " + i + " < " + arr + ".numElements(); " + i + " ++) {\n         |  if (!" + arr + ".isNullAt(" + i + ") && " + isEqual + ") {\n         |    " + numsToRemove + " = " + numsToRemove + " + 1;\n         |  }\n         |}\n         |int " + newArraySize + " = " + arr + ".numElements() - " + numsToRemove + ";\n         |" + this.genCodeForResult(ctx, ev, (String)arr, (String)value, newArraySize) + "\n       "));
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String value, String newArraySize) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String pos = ctx.freshName("pos");
        String getValue = CodeGenerator$.MODULE$.getValue(inputArray, this.elementType(), i);
        String isEqual = ctx.genEqual(this.elementType(), value, getValue);
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), newArraySize, " " + this.prettyName() + " failed.");
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, pos, i, false);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + allocation + "\n       |int " + pos + " = 0;\n       |for (int " + i + " = 0; " + i + " < " + inputArray + ".numElements(); " + i + " ++) {\n       |  if (" + inputArray + ".isNullAt(" + i + ")) {\n       |    " + values + ".setNullAt(" + pos + ");\n       |    " + pos + " = " + pos + " + 1;\n       |  }\n       |  else {\n       |    if (!(" + isEqual + ")) {\n       |      " + assignment + "\n       |      " + pos + " = " + pos + " + 1;\n       |    }\n       |  }\n       |}\n       |" + ev.value() + " = " + values + ";\n     "));
    }

    @Override
    public String prettyName() {
        return "array_remove";
    }

    @Override
    public ArrayRemove withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayRemove copy(Expression left, Expression right) {
        return new ArrayRemove(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRemove";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRemove;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRemove)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRemove arrayRemove = (ArrayRemove)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRemove.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRemove.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRemove.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$12(ArrayRemove $this, Object value$3, Object[] newArray$1, IntRef pos$1, int i, Object v) {
        if (v == null || !$this.ordering().equiv(v, value$3)) {
            newArray$1[pos$1.elem] = v;
            ++pos$1.elem;
            return;
        }
    }

    public ArrayRemove(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }
}

