/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetRankBase;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetRankDouble$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Extracts a single value from the quantiles sketch representing the\n    desired rank given the input quantile. The desired rank can either be a single value\n    or an array. In the latter case, the function will return an array of results of equal\n    length to the input array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(kll_sketch_agg_double(col), 3.0) > 0.3 FROM VALUES (CAST(1.0 AS DOUBLE)), (CAST(2.0 AS DOUBLE)), (CAST(3.0 AS DOUBLE)), (CAST(4.0 AS DOUBLE)), (CAST(5.0 AS DOUBLE)) tab(col);\n       true\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001B\u000e\u001d\u0001&B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\"Aa\t\u0001BK\u0002\u0013\u0005\u0011\t\u0003\u0005H\u0001\tE\t\u0015!\u0003C\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u001dA\b!!A\u0005\u0002eDq\u0001 \u0001\u0012\u0002\u0013\u0005Q\u0010\u0003\u0005\u0002\u0012\u0001\t\n\u0011\"\u0001~\u0011%\t\u0019\u0002AA\u0001\n\u0003\n)\u0002C\u0005\u0002&\u0001\t\t\u0011\"\u0001\u0002(!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003o\u0001\u0011\u0011!C!\u0003sA\u0011\"a\u0012\u0001\u0003\u0003%\t!!\u0013\t\u0013\u0005M\u0003!!A\u0005B\u0005U\u0003\"CA-\u0001\u0005\u0005I\u0011IA.\u000f%\ty\bHA\u0001\u0012\u0003\t\tI\u0002\u0005\u001c9\u0005\u0005\t\u0012AAB\u0011\u0019AU\u0003\"\u0001\u0002\u001c\"I\u0011QT\u000b\u0002\u0002\u0013\u0015\u0013q\u0014\u0005\n\u0003C+\u0012\u0011!CA\u0003GC\u0011\"!+\u0016\u0003\u0003%\t)a+\t\u0013\u0005uV#!A\u0005\n\u0005}&AF&mYN[W\r^2i\u000f\u0016$(+\u00198l\t>,(\r\\3\u000b\u0005uq\u0012aC3yaJ,7o]5p]NT!a\b\u0011\u0002\u0011\r\fG/\u00197zgRT!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0016/iA\u00111\u0006L\u0007\u00029%\u0011Q\u0006\b\u0002\u0015\u00172d7k[3uG\"<U\r\u001e*b].\u0014\u0015m]3\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\u000fA\u0013x\u000eZ;diB\u0011Q'\u0010\b\u0003mmr!a\u000e\u001e\u000e\u0003aR!!\u000f\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014B\u0001\u001f1\u0003\u001d\u0001\u0018mY6bO\u0016L!AP \u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005q\u0002\u0014\u0001\u00027fMR,\u0012A\u0011\t\u0003W\rK!\u0001\u0012\u000f\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)[E\n\u0005\u0002,\u0001!)\u0001)\u0002a\u0001\u0005\")a)\u0002a\u0001\u0005\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004\u0005>\u000b\u0006\"\u0002)\u0007\u0001\u0004\u0011\u0015a\u00028fo2+g\r\u001e\u0005\u0006%\u001a\u0001\rAQ\u0001\t]\u0016<(+[4ii\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003U\u0003\"A\u0016.\u000f\u0005]C\u0006CA\u001c1\u0013\tI\u0006'\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-1\u00035Ig\u000e];u\t\u0006$\u0018\rV=qKV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002cA\u0005)A/\u001f9fg&\u0011A-\u0019\u0002\t\t\u0006$\u0018\rV=qK\u0006\u00012\u000e\u001c7TW\u0016$8\r[$fiJ\u000bgn\u001b\u000b\u0004O*\u001c\bCA\u0018i\u0013\tI\u0007G\u0001\u0004E_V\u0014G.\u001a\u0005\u0006W&\u0001\r\u0001\\\u0001\u0007[\u0016lwN]=\u0011\u00055\fX\"\u00018\u000b\u0005-|'B\u00019%\u00031!\u0017\r^1tW\u0016$8\r[3t\u0013\t\u0011hN\u0001\u0004NK6|'/\u001f\u0005\u0006i&\u0001\r!^\u0001\tcV\fg\u000e^5mKB\u0011qF^\u0005\u0003oB\u00121!\u00118z\u0003\u0011\u0019w\u000e]=\u0015\u0007)S8\u0010C\u0004A\u0015A\u0005\t\u0019\u0001\"\t\u000f\u0019S\u0001\u0013!a\u0001\u0005\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001@+\u0005\t{8FAA\u0001!\u0011\t\u0019!!\u0004\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0001'\u0001\u0006b]:|G/\u0019;j_:LA!a\u0004\u0002\u0006\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005!A.\u00198h\u0015\t\t\t#\u0001\u0003kCZ\f\u0017bA.\u0002\u001c\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0006\t\u0004_\u0005-\u0012bAA\u0017a\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q/a\r\t\u0013\u0005Ur\"!AA\u0002\u0005%\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002<A)\u0011QHA\"k6\u0011\u0011q\b\u0006\u0004\u0003\u0003\u0002\u0014AC2pY2,7\r^5p]&!\u0011QIA \u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-\u0013\u0011\u000b\t\u0004_\u00055\u0013bAA(a\t9!i\\8mK\u0006t\u0007\u0002CA\u001b#\u0005\u0005\t\u0019A;\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003/\t9\u0006C\u0005\u00026I\t\t\u00111\u0001\u0002*\u00051Q-];bYN$B!a\u0013\u0002^!A\u0011QG\n\u0002\u0002\u0003\u0007Q\u000fK\n\u0001\u0003C\n9'!\u001b\u0002n\u0005=\u00141OA;\u0003s\nY\bE\u0002,\u0003GJ1!!\u001a\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u001b\u0002\u0005OR\u0001\u0005\t\u0011!?\u001a+fjQ0)Y\u00164G\u000f\f\u0011sS\u001eDG/\u000b\u0011.A\u0015CHO]1diN\u0004\u0013\rI:j]\u001edW\r\t<bYV,\u0007E\u001a:p[\u0002\"\b.\u001a\u0011rk\u0006tG/\u001b7fg\u0002\u001a8.\u001a;dQ\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hAQDWM\u0003\u0011!A\u0001\"Wm]5sK\u0012\u0004#/\u00198lA\u001dLg/\u001a8!i\",\u0007%\u001b8qkR\u0004\u0013/^1oi&dWM\f\u0011UQ\u0016\u0004C-Z:je\u0016$\u0007E]1oW\u0002\u001a\u0017M\u001c\u0011fSRDWM\u001d\u0011cK\u0002\n\u0007e]5oO2,\u0007E^1mk\u0016T\u0001\u0005\t\u0011!_J\u0004\u0013M\u001c\u0011beJ\f\u0017P\f\u0011J]\u0002\"\b.\u001a\u0011mCR$XM\u001d\u0011dCN,G\u0006\t;iK\u00022WO\\2uS>t\u0007e^5mY\u0002\u0012X\r^;s]\u0002\ng\u000eI1se\u0006L\be\u001c4!e\u0016\u001cX\u000f\u001c;tA=4\u0007%Z9vC2T\u0001\u0005\t\u0011!Y\u0016tw\r\u001e5!i>\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011beJ\f\u0017P\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002r\u0005\t)M\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015lY2|6o[3uG\"|\u0016mZ4`I>,(\r\\3)G>d\u0017\u0006\f\u00114]AJ\u0003E\u0010\u00111]M\u0002cIU(NAY\u000bE*V#TA!\u001a\u0015i\u0015+)c9\u0002\u0004%Q*!\t>+&\tT#*S1\u0002\u0003fQ!T)\"\u0012d\u0006\r\u0011B'\u0002\"u*\u0016\"M\u000b&JC\u0006\t\u0015D\u0003N#\u0006f\r\u00181A\u0005\u001b\u0006\u0005R(V\u00052+\u0015&\u000b\u0017!Q\r\u000b5\u000b\u0016\u00155]A\u0002\u0013i\u0015\u0011E\u001fV\u0013E*R\u0015*Y\u0001B3)Q*UQUr\u0003\u0007I!TA\u0011{UK\u0011'FS%\u0002C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005]\u0014AC7jg\u000e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011QP\u0001\u0006i9\nd\u0006M\u0001\u0017\u00172d7k[3uG\"<U\r\u001e*b].$u.\u001e2mKB\u00111&F\n\u0006+\u0005\u0015\u0015\u0011\u0013\t\b\u0003\u000f\u000biI\u0011\"K\u001b\t\tIIC\u0002\u0002\fB\nqA];oi&lW-\u0003\u0003\u0002\u0010\u0006%%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u00111SAM\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006}\u0011AA5p\u0013\rq\u0014Q\u0013\u000b\u0003\u0003\u0003\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003/\tQ!\u00199qYf$RASAS\u0003OCQ\u0001\u0011\rA\u0002\tCQA\u0012\rA\u0002\t\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002.\u0006e\u0006#B\u0018\u00020\u0006M\u0016bAAYa\t1q\n\u001d;j_:\u0004RaLA[\u0005\nK1!a.1\u0005\u0019!V\u000f\u001d7fe!A\u00111X\r\u0002\u0002\u0003\u0007!*A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!1\u0011\t\u0005e\u00111Y\u0005\u0005\u0003\u000b\fYB\u0001\u0004PE*,7\r\u001e")
public class KllSketchGetRankDouble
extends KllSketchGetRankBase
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(KllSketchGetRankDouble x$0) {
        return KllSketchGetRankDouble$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, KllSketchGetRankDouble> tupled() {
        return KllSketchGetRankDouble$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, KllSketchGetRankDouble>> curried() {
        return KllSketchGetRankDouble$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public String prettyName() {
        return "kll_sketch_get_rank_double";
    }

    @Override
    public DataType inputDataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public double kllSketchGetRank(Memory memory, Object quantile) {
        return BoxesRunTime.unboxToDouble(this.withRankErrorHandling((JFunction0.mcD.sp & Serializable)() -> KllDoublesSketch.wrap((Memory)memory).getRank(BoxesRunTime.unboxToDouble((Object)quantile))));
    }

    public KllSketchGetRankDouble copy(Expression left, Expression right) {
        return new KllSketchGetRankDouble(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "KllSketchGetRankDouble";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllSketchGetRankDouble;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllSketchGetRankDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllSketchGetRankDouble kllSketchGetRankDouble = (KllSketchGetRankDouble)x$1;
        Expression expression = this.left();
        Expression expression2 = kllSketchGetRankDouble.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = kllSketchGetRankDouble.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!kllSketchGetRankDouble.canEqual(this)) return false;
        return true;
    }

    public KllSketchGetRankDouble(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

