/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MakeTimestampLTZExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(year, month, day, hour, min, sec[, timezone]) - Create the current timestamp with local time zone from year, month, day, hour, min, sec and (optional) timezone fields. If the configuration `spark.sql.ansi.enabled` is false, the function returns NULL on invalid inputs. Otherwise, it will throw an error instead.\n\n    _FUNC_(date, time[, timezone]) - Create a local date-time from date, time and (optional) timezone fields.\n    ", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n      * date - a date to represent, from 0001-01-01 to 9999-12-31\n      * time - a local time to represent, from 00:00:00 to 23:59:59.999999\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887');\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887', 'CET');\n       2014-12-27 21:30:45.887\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005Q;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\n\u0011%T1lKRKW.Z:uC6\u0004H\n\u0016.FqB\u0014Xm]:j_:\u0014U/\u001b7eKJT!AB\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0011%\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001\u0001\t\u0003'\u0005i\u0011!\u0002\u0002\"\u001b\u0006\\W\rV5nKN$\u0018-\u001c9M)j+\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\n\u0004\u0003Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eA5\taD\u0003\u0002 \u000f\u0005A\u0011M\\1msNL7/\u0003\u0002\"=\t\tR\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0002\rqJg.\u001b;?)\u0005\u0011\u0012!\u00022vS2$Gc\u0001\u0014*mA\u00111cJ\u0005\u0003Q\u0015\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015Q3\u00011\u0001,\u0003!1WO\\2OC6,\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/15\tqF\u0003\u00021#\u00051AH]8pizJ!A\r\r\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eaAQAB\u0002A\u0002]\u00022\u0001O\u001f'\u001d\tI4H\u0004\u0002/u%\t\u0011$\u0003\u0002=1\u00059\u0001/Y2lC\u001e,\u0017B\u0001 @\u0005\r\u0019V-\u001d\u0006\u0003yaAC\"A!E\u000b\u001eC%jS'O!F\u0003\"a\u0005\"\n\u0005\r+!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0002\r\u0006\u0019yG\u0003\u0011!A\u0001zf)\u0016(D?\"JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u0017\u0010\f\u0011i_V\u0014H\u0006I7j]2\u00023/Z2\\Y\u0001\"\u0018.\\3{_:,W,\u000b\u0011.A\r\u0013X-\u0019;fAQDW\rI2veJ,g\u000e\u001e\u0011uS6,7\u000f^1na\u0002:\u0018\u000e\u001e5!Y>\u001c\u0017\r\u001c\u0011uS6,\u0007E_8oK\u00022'o\\7!s\u0016\f'\u000f\f\u0011n_:$\b\u000e\f\u0011eCfd\u0003\u0005[8ve2\u0002S.\u001b8-AM,7\rI1oI\u0002Bs\u000e\u001d;j_:\fG.\u000b\u0011uS6,'p\u001c8fA\u0019LW\r\u001c3t]\u0001Je\r\t;iK\u0002\u001awN\u001c4jOV\u0014\u0018\r^5p]\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u00022\u0017\r\\:fY\u0001\"\b.\u001a\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002rU\u000b\u0014'!_:\u0004\u0013N\u001c<bY&$\u0007%\u001b8qkR\u001ch\u0006I(uQ\u0016\u0014x/[:fY\u0001JG\u000fI<jY2\u0004C\u000f\u001b:po\u0002\ng\u000eI3se>\u0014\b%\u001b8ti\u0016\fGM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006Z1uK2\u0002C/[7f72\u0002C/[7fu>tW-X\u0015![\u0001\u001a%/Z1uK\u0002\n\u0007\u0005\\8dC2\u0004C-\u0019;f[QLW.\u001a\u0011ge>l\u0007\u0005Z1uK2\u0002C/[7fA\u0005tG\r\t\u0015paRLwN\\1mS\u0001\"\u0018.\\3{_:,\u0007EZ5fY\u0012\u001chF\u0003\u0011!A\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0003%\u000baQ\u0001\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+Ae,\u0017M\u001d\u0011.AQDW\rI=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002Co\u001c\u0011:seJ$\u0002\t\u0011!A\u0001\u0002#\u0006I7p]RD\u0007%\f\u0011uQ\u0016\u0004Sn\u001c8uQ6zg-L=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002\u0003FS1ok\u0006\u0014\u00180\u000b\u0011u_\u0002\n$\u0007\t\u0015EK\u000e,WNY3sS)\u0001\u0003\u0005\t\u0011!A)\u0002C-Y=![\u0001\"\b.\u001a\u0011eCflsNZ\u0017n_:$\b\u000e\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAM\n$\u0002\t\u0011!A\u0001\u0002#\u0006\t5pkJ\u0004S\u0006\t;iK\u0002Bw.\u001e:._\u001alC-Y=!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000e\t\u0019!i>\u0004#g\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016![&t\u0007%\f\u0011uQ\u0016\u0004S.\u001b8vi\u0016lsNZ\u0017i_V\u0014\b\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\u0002\u0004\u0005^8!keR\u0001\u0005\t\u0011!A\u0001R\u0003e]3dA5\u0002C\u000f[3!g\u0016\u001cwN\u001c3._\u001alS.\u001b8vi\u0016\u0004\u0013M\u001c3!SR\u001c\b%\\5de>lcM]1di&|g\u000e\t;pAI,\u0007O]3tK:$H\u0006\t4s_6T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0007\t;pAY\u0002d\u0006I%gAQDW\rI:fG\u0002\n'oZ;nK:$\b%Z9vC2\u001c\b\u0005^8!mAb\u0003\u0005\u001e5fAM,7m\u001c8eg\u00022\u0017.\u001a7eA%\u001c\be]3u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQ|\u0007\u0005\r\u0011b]\u0012\u0004\u0013\u0007I7j]V$X\rI5tA\u0005$G-\u001a3!i>\u0004C\u000f[3!M&t\u0017\r\u001c\u0011uS6,7\u000f^1na:R\u0001\u0005\t\u0011!A\u0001R\u0003\u0005^5nKj|g.\u001a\u0011.AQDW\r\t;j[\u0016\u0004#p\u001c8fA%$WM\u001c;jM&,'O\f\u0011G_J\u0004S\r_1na2,G\u0006I\"F)2\u0002S\u000bV\"!C:$\u0007%\u001a;d])\u0001\u0003\u0005\t\u0011!A)\u0002C-\u0019;fA5\u0002\u0013\r\t3bi\u0016\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAA\u0002\u0004'M\u00171c5\u0002\u0014\u0007\t;pAeJ\u0014(O\u00172e5\u001a\u0014G\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011uS6,\u0007%\f\u0011bA1|7-\u00197!i&lW\r\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0003\u0007\r\u001e1ai\u0002\u0004\u0007\t;pAI\u001a$(N\u001d;ker\u0013(O\u001d:seR\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\nA*\u0001C\u0002\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'\r\u001b-AE\u0012D\u0006\t\u001a9Y\u00012D\u0006I\u001a1Y\u0001\"TG\f\u001d9o%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192i5\n$'\f\u001a9AA2$h\r\u0019;iUr\u0003\bO\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QI\u0002\u0014\u0007\u000e\u0017!cIb\u0003E\r\u001d-AYb\u0003e\r\u0019-AQ*d\u0006\u000f\u001d8Y\u0001:3)\u0012+(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00195[E\u0012TFM\u001c!eER4\u0007\r\u001e5k9B\u0004h\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eA\n\u0014\b\f\u00117Y\u0001\u001a\u0004\u0007\f\u00113g1\u0002S'\u000f\u0017!mAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cej\u0003gN\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b8vY2d\u0003e\u000e\u0017!eIb\u0003%M\u001b-AM\u0002D\u0006\t\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0011\u000bE+R\u00143aE\"T&\r\u001a.ea:C\u0006\t+J\u001b\u0016;cGO\u001a1uQ*d\u0006\u000f\u001d8O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192i5\n$'\f\u001a9AA2$h\r\u0019;iUr\u0003\bO\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0011\u000bE+R\u00143aE\"T&\r\u001a.ea:C\u0006\t+J\u001b\u0016;cGO\u001a1uQ*d\u0006\u000f\u001d8O1\u0002seQ#UO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192i5\n$'\f\u001a8AI\n$h\r\u0019;iUr\u0003\bO\u001c\u000bA\u0001\nQa\u001a:pkB\f\u0013aT\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\u0005\u0011\u0016!B\u001a/i9\u0002\u0004\u0006\u0004\u0001B\t\u0016;\u0005JS&N\u001dB\u000b\u0006")
public final class MakeTimestampLTZExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return MakeTimestampLTZExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return MakeTimestampLTZExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return MakeTimestampLTZExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }

    public static Option<FunctionSignature> functionSignature() {
        return MakeTimestampLTZExpressionBuilder$.MODULE$.functionSignature();
    }
}

