/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeExpression;
import org.apache.spark.sql.catalyst.expressions.ToTime$;
import org.apache.spark.sql.catalyst.expressions.ToTimeParser;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.TimeType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str[, format]) - Parses the `str` expression with the `format` expression to a time.\n    If `format` is malformed or its application does not result in a well formed time, the function\n    raises an error. By default, it follows casting rules to a time if the `format` is omitted.\n  ", arguments="\n    Arguments:\n      * str - A string to be parsed to time.\n      * format - Time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n                 time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('00:12:00');\n       00:12:00\n      > SELECT _FUNC_('12.10.05', 'HH.mm.ss');\n       12:10:05\n  ", group="datetime_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001B\u0011#\u0001>B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t#\u0002\u0011\t\u0012)A\u0005a!A!\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003U\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015A\u0006\u0001\"\u0001^\u0011\u0015A\u0006\u0001\"\u0001a\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0011\u001d!\b!%A\u0005\nUD\u0011\"!\u0001\u0001#\u0003%I!a\u0001\t\u0013\u0005\u001d\u0001\u0001#b\u0001\n\u0003\u0002\u0006bBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\ty\u0002\u0001C!\u0003CAq!a\t\u0001\t#\n)\u0003C\u0005\u00022\u0001\t\t\u0011\"\u0001\u00024!I\u0011\u0011\b\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u007f\u0001\u0011\u0013!C\u0001\u0003\u0003B\u0011\"!\u0012\u0001\u0003\u0003%\t%a\u0012\t\u0013\u0005]\u0003!!A\u0005\u0002\u0005e\u0003\"CA1\u0001\u0005\u0005I\u0011AA2\u0011%\ty\u0007AA\u0001\n\u0003\n\t\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0001\u0002\u0002\"I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0013Q\u0012\u0005\n\u0003#\u0003\u0011\u0011!C!\u0003';\u0011\"a/#\u0003\u0003E\t!!0\u0007\u0011\u0005\u0012\u0013\u0011!E\u0001\u0003\u007fCa\u0001W\u000e\u0005\u0002\u0005]\u0007\"CAm7\u0005\u0005IQIAn\u0011%\tinGA\u0001\n\u0003\u000by\u000eC\u0005\u0002fn\t\t\u0011\"!\u0002h\"I\u0011Q_\u000e\u0002\u0002\u0013%\u0011q\u001f\u0002\u0007)>$\u0016.\\3\u000b\u0005\r\"\u0013aC3yaJ,7o]5p]NT!!\n\u0014\u0002\u0011\r\fG/\u00197zgRT!a\n\u0015\u0002\u0007M\fHN\u0003\u0002*U\u0005)1\u000f]1sW*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001\u0019r\u0001\u0001\u00195oij4\t\u0005\u00022e5\t!%\u0003\u00024E\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E*\u0014B\u0001\u001c#\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005EB\u0014BA\u001d#\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003cmJ!\u0001\u0010\u0012\u0003\u001dQKW.Z#yaJ,7o]5p]B\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t9\u0001K]8ek\u000e$\bC\u0001#M\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002I]\u00051AH]8pizJ\u0011\u0001Q\u0005\u0003\u0017~\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\na1+\u001a:jC2L'0\u00192mK*\u00111jP\u0001\u0004gR\u0014X#\u0001\u0019\u0002\tM$(\u000fI\u0001\u0007M>\u0014X.\u0019;\u0016\u0003Q\u00032AP+1\u0013\t1vH\u0001\u0004PaRLwN\\\u0001\bM>\u0014X.\u0019;!\u0003\u0019a\u0014N\\5u}Q\u0019!l\u0017/\u0011\u0005E\u0002\u0001\"B(\u0006\u0001\u0004\u0001\u0004\"\u0002*\u0006\u0001\u0004!Fc\u0001._?\")qJ\u0002a\u0001a!)!K\u0002a\u0001aQ\u0011!,\u0019\u0005\u0006\u001f\u001e\u0001\r\u0001M\u0001\rS:4xn[3QCJ\u001cXM\u001d\u000b\u0004a\u0011|\u0007bB3\t!\u0003\u0005\rAZ\u0001\u0004M6$\bc\u0001 VOB\u0011\u0001\u000e\u001c\b\u0003S*\u0004\"AR \n\u0005-|\u0014A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a[ \t\u000fAD\u0001\u0013!a\u0001c\u0006I\u0011M]4v[\u0016tGo\u001d\t\u0004\tJ\u0004\u0014BA:O\u0005\r\u0019V-]\u0001\u0017S:4xn[3QCJ\u001cXM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\taO\u000b\u0002go.\n\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003{~\n!\"\u00198o_R\fG/[8o\u0013\ty(PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa#\u001b8w_.,\u0007+\u0019:tKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000bQ#!]<\u0002\u0017I,\u0007\u000f\\1dK6,g\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\u0007!\u0011!%/a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006'\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI\"a\u0005\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\tq-\u0001\u0005dQ&dGM]3o+\u0005\t\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r\u0001\u0014q\u0005\u0005\b\u0003Sy\u0001\u0019AA\u0016\u0003-qWm^\"iS2$'/\u001a8\u0011\t\u0011\u000bi\u0003M\u0005\u0004\u0003_q%AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\u0015Q\u0016QGA\u001c\u0011\u001dy\u0005\u0003%AA\u0002ABqA\u0015\t\u0011\u0002\u0003\u0007A+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u\"F\u0001\u0019x\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0011+\u0005Q;\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001\u00027b]\u001eT!!a\u0015\u0002\t)\fg/Y\u0005\u0004[\u00065\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA.!\rq\u0014QL\u0005\u0004\u0003?z$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA3\u0003W\u00022APA4\u0013\r\tIg\u0010\u0002\u0004\u0003:L\b\"CA7+\u0005\u0005\t\u0019AA.\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000f\t\u0007\u0003k\nY(!\u001a\u000e\u0005\u0005]$bAA=\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0014q\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0004\u0006%\u0005c\u0001 \u0002\u0006&\u0019\u0011qQ \u0003\u000f\t{w\u000e\\3b]\"I\u0011QN\f\u0002\u0002\u0003\u0007\u0011QM\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002J\u0005=\u0005\"CA71\u0005\u0005\t\u0019AA.\u0003\u0019)\u0017/^1mgR!\u00111QAK\u0011%\ti'GA\u0001\u0002\u0004\t)\u0007\u000b\f\u0001\u00033\u000by*!)q\u0003K\u000bI+a+\u00020\u0006E\u0016QWA\\!\r\t\u00141T\u0005\u0004\u0003;\u0013#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003G\u000b!q\n\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:\\Y\u00012wN]7bivK\u0003%\f\u0011QCJ\u001cXm\u001d\u0011uQ\u0016\u0004\u0003m\u001d;sA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xSRD\u0007\u0005\u001e5fA\u00014wN]7bi\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!i>\u0004\u0013\r\t;j[\u0016t#\u0002\t\u0011!A%3\u0007\u0005\u00194pe6\fG\u000f\u0019\u0011jg\u0002j\u0017\r\u001c4pe6,G\rI8sA%$8\u000fI1qa2L7-\u0019;j_:\u0004Cm\\3tA9|G\u000f\t:fgVdG\u000fI5oA\u0005\u0004s/\u001a7mA\u0019|'/\\3eAQLW.\u001a\u0017!i\",\u0007EZ;oGRLwN\u001c\u0006!A\u0001\u0002#/Y5tKN\u0004\u0013M\u001c\u0011feJ|'O\f\u0011Cs\u0002\"WMZ1vYRd\u0003%\u001b;!M>dGn\\<tA\r\f7\u000f^5oO\u0002\u0012X\u000f\\3tAQ|\u0007%\u0019\u0011uS6,\u0007%\u001b4!i\",\u0007\u0005\u00194pe6\fG\u000f\u0019\u0011jg\u0002zW.\u001b;uK\u0012t#\u0002\t\u0011\"\u0005\u0005\u001d\u0016Aa\u0004\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00033\u000f\u001e:j]\u001e\u0004Co\u001c\u0011cK\u0002\u0002\u0018M]:fI\u0002\"x\u000e\t;j[\u0016t#\u0002\t\u0011!A\u0001\u0002#\u0006\t4pe6\fG\u000fI\u0017!)&lW\r\t4pe6\fG\u000f\t9biR,'O\u001c\u0011u_\u00022w\u000e\u001c7po:\u00023+Z3!y\u0005\u0004\u0003N]3g{\tBG\u000f\u001e9tu=z3\u000f]1sW:\n\u0007/Y2iK:z'oZ\u0018e_\u000e\u001cx\u0006\\1uKN$xf]9m[I,g-\f3bi\u0016$\u0018.\\3.a\u0006$H/\u001a:o]!$X\u000e\u001c\u0012?\t\u0006$X\r^5nK\u0002\u0002\u0016\r\u001e;fe:\u001cHhL1?A\u0019|'\u000f\t<bY&$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u00055\u0016!a\u0002\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0002\u0004GO\u00193uA\u0002t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!aAR\u0014G\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a/cAr\u0003'N\u0014-A\u001dB\u0005JL7n]M\u001cx%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cIR\u0014\u0007\r\u001e1k)\u0001\u0003%A\u0003he>,\b/\t\u0002\u00024\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAA]\u0003\u0015!d&\r\u00181\u0003\u0019!v\u000eV5nKB\u0011\u0011gG\n\u00067\u0005\u0005\u0017Q\u001a\t\b\u0003\u0007\fI\r\r+[\u001b\t\t)MC\u0002\u0002H~\nqA];oi&lW-\u0003\u0003\u0002L\u0006\u0015'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011qZAk\u001b\t\t\tN\u0003\u0003\u0002T\u0006E\u0013AA5p\u0013\ri\u0015\u0011\u001b\u000b\u0003\u0003{\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0013\nQ!\u00199qYf$RAWAq\u0003GDQa\u0014\u0010A\u0002ABQA\u0015\u0010A\u0002Q\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002j\u0006E\b\u0003\u0002 V\u0003W\u0004RAPAwaQK1!a<@\u0005\u0019!V\u000f\u001d7fe!A\u00111_\u0010\u0002\u0002\u0003\u0007!,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!?\u0011\t\u0005-\u00131`\u0005\u0005\u0003{\fiE\u0001\u0004PE*,7\r\u001e")
public class ToTime
extends Expression
implements RuntimeReplaceable,
ExpectsInputTypes,
TimeExpression,
Serializable {
    private Expression replacement;
    private final Expression str;
    private final Option<Expression> format;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(ToTime x$0) {
        return ToTime$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Option<Expression>>, ToTime> tupled() {
        return ToTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, ToTime>> curried() {
        return ToTime$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$TimeExpression$$super$checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TimeExpression.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ToTime toTime = this;
        synchronized (toTime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression str() {
        return this.str;
    }

    public Option<Expression> format() {
        return this.format;
    }

    private Expression invokeParser(Option<String> fmt, Seq<Expression> arguments) {
        return new Invoke(Literal$.MODULE$.create(new ToTimeParser(fmt), (DataType)new ObjectType(ToTimeParser.class)), "parse", (DataType)TimeType$.MODULE$.apply(), arguments, (Seq<AbstractDataType>)((Seq)arguments.map((Function1 & Serializable)x$1 -> x$1.dataType())), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    private Option<String> invokeParser$default$1() {
        return None$.MODULE$;
    }

    private Seq<Expression> invokeParser$default$2() {
        return this.children();
    }

    private Expression replacement$lzycompute() {
        ToTime toTime = this;
        synchronized (toTime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Some some;
                Expression expr;
                Option<Expression> option = this.format();
                this.replacement = None$.MODULE$.equals(option) ? this.invokeParser(this.invokeParser$default$1(), this.invokeParser$default$2()) : (option instanceof Some && (expr = (Expression)(some = (Some)option).value()).foldable() ? (Expression)Option$.MODULE$.apply(expr.eval(expr.eval$default$1())).map((Function1 & Serializable)f -> this.invokeParser((Option<String>)new Some((Object)f.toString()), (Seq<Expression>)new .colon.colon((Object)this.str(), (List)Nil$.MODULE$))).getOrElse((Function0 & Serializable)() -> new Literal(null, expr.dataType())) : this.invokeParser(this.invokeParser$default$1(), this.invokeParser$default$2()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$).$plus$plus((IterableOnce)this.format().map((Function1 & Serializable)x$2 -> StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())));
    }

    @Override
    public String prettyName() {
        return "to_time";
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.format().isDefined()) {
            return this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()));
        }
        return this.copy((Expression)newChildren.head(), this.copy$default$2());
    }

    public ToTime copy(Expression str, Option<Expression> format) {
        return new ToTime(str, format);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    @Override
    public String productPrefix() {
        return "ToTime";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.format();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToTime;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "format";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToTime toTime = (ToTime)x$1;
        Expression expression = this.str();
        Expression expression2 = toTime.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = toTime.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!toTime.canEqual(this)) return false;
        return true;
    }

    public ToTime(Expression str, Option<Expression> format) {
        this.str = str;
        this.format = format;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeExpression.$init$(this);
        Statics.releaseFence();
    }

    public ToTime(Expression str, Expression format) {
        this(str, (Option<Expression>)Option$.MODULE$.apply((Object)format));
    }

    public ToTime(Expression str) {
        this(str, (Option<Expression>)None$.MODULE$);
    }
}

