/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAggregateBuffer;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAggregateBuffer$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKCombine$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CombineInternal;
import org.apache.spark.sql.catalyst.expressions.aggregate.CombineInternal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(state, maxItemsTracked) - Combines multiple sketches into a single sketch.\n      `maxItemsTracked` An optional positive INTEGER literal with upper limit of 1000000. If maxItemsTracked is specified, it will be set for the combined sketch. If maxItemsTracked is not specified, the input sketches must have the same maxItemsTracked value, otherwise an error will be thrown. The output sketch will use the same value from the input sketches.\n  ", examples="\n    Examples:\n      > SELECT approx_top_k_estimate(_FUNC_(sketch, 10000), 5) FROM (SELECT approx_top_k_accumulate(expr) AS sketch FROM VALUES (0), (0), (1), (1) AS tab(expr) UNION ALL SELECT approx_top_k_accumulate(expr) AS sketch FROM VALUES (2), (3), (4), (4) AS tab(expr));\n       [{\"item\":0,\"count\":2},{\"item\":4,\"count\":2},{\"item\":1,\"count\":2},{\"item\":2,\"count\":1},{\"item\":3,\"count\":1}]\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\tUf\u0001B\u001c9\u0001\u001eC\u0001\"\u001d\u0001\u0003\u0016\u0004%\tA\u001d\u0005\tg\u0002\u0011\t\u0012)A\u0005?\"AA\u000f\u0001BK\u0002\u0013\u0005!\u000f\u0003\u0005v\u0001\tE\t\u0015!\u0003`\u0011!1\bA!f\u0001\n\u00039\b\u0002C>\u0001\u0005#\u0005\u000b\u0011\u0002=\t\u0011q\u0004!Q3A\u0005\u0002]D\u0001\" \u0001\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\u0006}\u0002!\ta \u0005\u0007}\u0002!\t!a\u0003\t\ry\u0004A\u0011AA\n\u0011\u0019q\b\u0001\"\u0001\u0002\u001a!Q\u0011Q\u0004\u0001\t\u0006\u0004%I!a\b\t\u0013\u00055\u0002\u0001#b\u0001\n\u00139\bBCA\u0018\u0001!\u0015\r\u0011\"\u0003\u00022!1\u0011\u0011\b\u0001\u0005BIDa!a\u000f\u0001\t\u0003\u0012\bbBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\ti\u0006\u0001C!\u0003?Aq!a\u0018\u0001\t\u0003\n\t\u0007C\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\ti\n\u0001C)\u0003?Cq!!+\u0001\t\u0003\nY\u000bC\u0004\u00028\u0002!\t%!/\t\u000f\u0005}\u0006\u0001\"\u0011\u00022!9\u0011\u0011\u0019\u0001\u0005B\u0005\r\u0007\"CAk\u0001\u0005\u0005I\u0011AAl\u0011%\t\t\u000fAI\u0001\n\u0003\t\u0019\u000fC\u0005\u0002z\u0002\t\n\u0011\"\u0001\u0002d\"I\u00111 \u0001\u0012\u0002\u0013\u0005\u0011Q \u0005\n\u0005\u0003\u0001\u0011\u0013!C\u0001\u0003{D\u0011Ba\u0001\u0001\u0003\u0003%\tE!\u0002\t\u0011\tU\u0001!!A\u0005\u0002]D\u0011Ba\u0006\u0001\u0003\u0003%\tA!\u0007\t\u0013\t}\u0001!!A\u0005B\t\u0005\u0002\"\u0003B\u0018\u0001\u0005\u0005I\u0011\u0001B\u0019\u0011%\u0011)\u0004AA\u0001\n\u0003\u00129\u0004C\u0005\u0003<\u0001\t\t\u0011\"\u0011\u0003>\u001dI!\u0011\r\u001d\u0002\u0002#\u0005!1\r\u0004\toa\n\t\u0011#\u0001\u0003f!1a0\fC\u0001\u0005{B\u0011Ba .\u0003\u0003%)E!!\t\u0013\t\rU&!A\u0005\u0002\n\u0015\u0005\"\u0003BH[E\u0005I\u0011AA\u007f\u0011%\u0011\t*LI\u0001\n\u0003\ti\u0010C\u0005\u0003\u00146\n\t\u0011\"!\u0003\u0016\"I!qU\u0017\u0012\u0002\u0013\u0005\u0011Q \u0005\n\u0005Sk\u0013\u0013!C\u0001\u0003{D\u0011Ba+.\u0003\u0003%IA!,\u0003#\u0005\u0003\bO]8y)>\u00048jQ8nE&tWM\u0003\u0002:u\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003wq\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QHP\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\bQ\u0001\u0004gFd'BA!C\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019E)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000b\u0006\u0019qN]4\u0004\u0001M1\u0001\u0001S+ZE\u0016\u00042!\u0013&M\u001b\u0005A\u0014BA&9\u0005a!\u0016\u0010]3e\u00136\u0004XM]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0004\u00136{\u0015B\u0001(9\u0005=\u0019u.\u001c2j]\u0016Le\u000e^3s]\u0006d\u0007C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&aA!osB\u0011akV\u0007\u0002u%\u0011\u0001L\u000f\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0019!,X0\u000e\u0003mS!\u0001\u0018\u001f\u0002\u000bQ\u0014X-Z:\n\u0005y[&A\u0003\"j]\u0006\u0014\u0018\u0010T5lKB\u0011a\u000bY\u0005\u0003Cj\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t\u00016-\u0003\u0002e#\n9\u0001K]8ek\u000e$\bC\u00014o\u001d\t9GN\u0004\u0002iW6\t\u0011N\u0003\u0002k\r\u00061AH]8pizJ\u0011AU\u0005\u0003[F\u000bq\u0001]1dW\u0006<W-\u0003\u0002pa\na1+\u001a:jC2L'0\u00192mK*\u0011Q.U\u0001\u0006gR\fG/Z\u000b\u0002?\u000611\u000f^1uK\u0002\nq\"\\1y\u0013R,Wn\u001d+sC\u000e\\W\rZ\u0001\u0011[\u0006D\u0018\n^3ngR\u0013\u0018mY6fI\u0002\na#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u000b\u0002qB\u0011\u0001+_\u0005\u0003uF\u00131!\u00138u\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003\u0019a\u0014N\\5u}QQ\u0011\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0011\u0005%\u0003\u0001\"B9\n\u0001\u0004y\u0006\"\u0002;\n\u0001\u0004y\u0006b\u0002<\n!\u0003\u0005\r\u0001\u001f\u0005\by&\u0001\n\u00111\u0001y)\u0019\t\t!!\u0004\u0002\u0012!1\u0011q\u0002\u0006A\u0002}\u000bQa\u00195jY\u0012DQ\u0001\u001e\u0006A\u0002}#b!!\u0001\u0002\u0016\u0005]\u0001BBA\b\u0017\u0001\u0007q\fC\u0003u\u0017\u0001\u0007\u0001\u0010\u0006\u0003\u0002\u0002\u0005m\u0001BBA\b\u0019\u0001\u0007q,A\u000bv]\u000eDWmY6fI&#X-\u001c#bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001db(A\u0003usB,7/\u0003\u0003\u0002,\u0005\u0015\"\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002%5\f\u00070\u0013;f[N$&/Y2lK\u00124\u0016\r\\\u0001\u0015G>l'-\u001b8f'&TXm\u00159fG&4\u0017.\u001a3\u0016\u0005\u0005M\u0002c\u0001)\u00026%\u0019\u0011qG)\u0003\u000f\t{w\u000e\\3b]\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003\u0003\u0002RAZA\"\u0003\u000fJ1!!\u0012q\u0005\r\u0019V-\u001d\t\u0005\u0003G\tI%\u0003\u0003\u0002L\u0005\u0015\"\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9\u0006P\u0001\tC:\fG._:jg&!\u00111LA+\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0002/\r\u0014X-\u0019;f\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014H#\u0001'\u0002\rU\u0004H-\u0019;f)\u0015a\u0015qMA6\u0011\u0019\tIG\u0006a\u0001\u0019\u00061!-\u001e4gKJDq!!\u001c\u0017\u0001\u0004\ty'A\u0003j]B,H\u000f\u0005\u0003\u0002r\u0005MT\"\u0001\u001f\n\u0007\u0005UDHA\u0006J]R,'O\\1m%><\u0018!B7fe\u001e,G#\u0002'\u0002|\u0005u\u0004BBA5/\u0001\u0007A\n\u0003\u0004\u0002n]\u0001\r\u0001T\u0001\u0005KZ\fG\u000eF\u0002P\u0003\u0007Ca!!\u001b\u0019\u0001\u0004a\u0015!C:fe&\fG.\u001b>f)\u0011\tI)!&\u0011\u000bA\u000bY)a$\n\u0007\u00055\u0015KA\u0003BeJ\f\u0017\u0010E\u0002Q\u0003#K1!a%R\u0005\u0011\u0011\u0015\u0010^3\t\r\u0005%\u0014\u00041\u0001M\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u00071\u000bY\nC\u0004\u0002ji\u0001\r!!#\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B0\u0002\"\u0006\u0015\u0006BBAR7\u0001\u0007q,A\u0004oK^dUM\u001a;\t\r\u0005\u001d6\u00041\u0001`\u0003!qWm\u001e*jO\"$\u0018!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u00055\u00161\u0017\t\u0004\u0013\u0006=\u0016bAAYq\t\u0019\u0012*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uK\"1\u0011Q\u0017\u000fA\u0002a\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!!,\u0002<\"1\u0011QX\u000fA\u0002a\fqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002\u00119,H\u000e\\1cY\u0016\f!\u0002\u001d:fiRLh*Y7f+\t\t)\r\u0005\u0003\u0002H\u0006=g\u0002BAe\u0003\u0017\u0004\"\u0001[)\n\u0007\u00055\u0017+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\f\u0019N\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b\f\u0016\u0001B2paf$\"\"!\u0001\u0002Z\u0006m\u0017Q\\Ap\u0011\u001d\t\b\u0005%AA\u0002}Cq\u0001\u001e\u0011\u0011\u0002\u0003\u0007q\fC\u0004wAA\u0005\t\u0019\u0001=\t\u000fq\u0004\u0003\u0013!a\u0001q\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAsU\ry\u0016q]\u0016\u0003\u0003S\u0004B!a;\u0002v6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0A\u0005v]\u000eDWmY6fI*\u0019\u00111_)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002x\u00065(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u007fT3\u0001_At\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0004!\u0011\u0011IAa\u0005\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\tA\u0001\\1oO*\u0011!\u0011C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\n-\u0011\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004\u001f\nm\u0001\u0002\u0003B\u000fO\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\u0003E\u0003\u0003&\t-r*\u0004\u0002\u0003()\u0019!\u0011F)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003.\t\u001d\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\r\u00034!A!QD\u0015\u0002\u0002\u0003\u0007q*\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u0004\u0005sA\u0001B!\b+\u0003\u0003\u0005\r\u0001_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\"q\b\u0005\t\u0005;Y\u0013\u0011!a\u0001\u001f\"\u001a\u0002Aa\u0011\u0003J\t-#q\nB)\u0005+\u00129Fa\u0017\u0003^A\u0019aK!\u0012\n\u0007\t\u001d#HA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t5\u0013a!#\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;bi\u0016d\u0003%\\1y\u0013R,Wn\u001d+sC\u000e\\W\rZ\u0015![\u0001\u001au.\u001c2j]\u0016\u001c\b%\\;mi&\u0004H.\u001a\u0011tW\u0016$8\r[3tA%tGo\u001c\u0011bAMLgn\u001a7fAM\\W\r^2i])\u0001\u0003\u0005\t\u0011!A\u0001l\u0017\r_%uK6\u001cHK]1dW\u0016$\u0007\rI!oA=\u0004H/[8oC2\u0004\u0003o\\:ji&4X\rI%O)\u0016;UI\u0015\u0011mSR,'/\u00197!o&$\b\u000eI;qa\u0016\u0014\b\u0005\\5nSR\u0004sN\u001a\u00112aA\u0002\u0004\u0007\r\u0019/A%3\u0007%\\1y\u0013R,Wn\u001d+sC\u000e\\W\r\u001a\u0011jg\u0002\u001a\b/Z2jM&,G\r\f\u0011ji\u0002:\u0018\u000e\u001c7!E\u0016\u00043/\u001a;!M>\u0014\b\u0005\u001e5fA\r|WNY5oK\u0012\u00043o[3uG\"t\u0003%\u00134![\u0006D\u0018\n^3ngR\u0013\u0018mY6fI\u0002J7\u000f\t8pi\u0002\u001a\b/Z2jM&,G\r\f\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\u001a8.\u001a;dQ\u0016\u001c\b%\\;ti\u0002B\u0017M^3!i\",\u0007e]1nK\u0002j\u0017\r_%uK6\u001cHK]1dW\u0016$\u0007E^1mk\u0016d\u0003e\u001c;iKJ<\u0018n]3!C:\u0004SM\u001d:pe\u0002:\u0018\u000e\u001c7!E\u0016\u0004C\u000f\u001b:po:t\u0003\u0005\u00165fA=,H\u000f];uAM\\W\r^2iA]LG\u000e\u001c\u0011vg\u0016\u0004C\u000f[3!g\u0006lW\r\t<bYV,\u0007E\u001a:p[\u0002\"\b.\u001a\u0011j]B,H\u000fI:lKR\u001c\u0007.Z:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tM\u0013a!\u0006\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u0005\u0004\bO]8y?R|\u0007oX6`KN$\u0018.\\1uK\"zf)\u0016(D?\"\u001a8.\u001a;dQ2\u0002\u0013\u0007\r\u00191a%b\u0003%N\u0015!\rJ{U\n\t\u0015T\u000b2+5\t\u0016\u0011baB\u0014x\u000e_0u_B|6nX1dGVlW\u000f\\1uK\"*\u0007\u0010\u001d:*A\u0005\u001b\u0006e]6fi\u000eD\u0007E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0003'\u000b\u0017!QAJC\u0006\t\u00152S1\u0002\u0003&M\u0015!\u0003N\u0003C/\u00192)Kb\u0004(/\u000b\u0011V\u001d&{e\nI!M\u0019\u0002\u001aV\tT#D)\u0002\n\u0007\u000f\u001d:pq~#x\u000e]0l?\u0006\u001c7-^7vY\u0006$X\rK3yaJL\u0003%Q*!g.,Go\u00195!\rJ{U\n\t,B\u0019V+5\u000b\t\u00153S1\u0002\u0003fM\u0015-A!\"\u0014\u0006\f\u0011)i%\u0002\u0013i\u0015\u0011uC\nDS\r\u001f9sS%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW>#SR,WN\t\u001e1Y\t\u001aw.\u001e8uEi\u0012T\u0010L>#SR,WN\t\u001e5Y\t\u001aw.\u001e8uEi\u0012T\u0010L>#SR,WN\t\u001e2Y\t\u001aw.\u001e8uEi\u0012T\u0010L>#SR,WN\t\u001e3Y\t\u001aw.\u001e8uEi\nT\u0010L>#SR,WN\t\u001e4Y\t\u001aw.\u001e8uEi\nT0\u0018\u0006!A\u0005)qM]8va\u0006\u0012!\u0011L\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#Aa\u0018\u0002\u000bQr\u0013G\f\u0019\u0002#\u0005\u0003\bO]8y)>\u00048jQ8nE&tW\r\u0005\u0002J[M)QFa\u001a\u0003tAQ!\u0011\u000eB8?~C\b0!\u0001\u000e\u0005\t-$b\u0001B7#\u00069!/\u001e8uS6,\u0017\u0002\u0002B9\u0005W\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\u0011)Ha\u001f\u000e\u0005\t]$\u0002\u0002B=\u0005\u001f\t!![8\n\u0007=\u00149\b\u0006\u0002\u0003d\u0005AAo\\*ue&tw\r\u0006\u0002\u0003\b\u0005)\u0011\r\u001d9msRQ\u0011\u0011\u0001BD\u0005\u0013\u0013YI!$\t\u000bE\u0004\u0004\u0019A0\t\u000bQ\u0004\u0004\u0019A0\t\u000fY\u0004\u0004\u0013!a\u0001q\"9A\u0010\rI\u0001\u0002\u0004A\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0018\n\r\u0006#\u0002)\u0003\u001a\nu\u0015b\u0001BN#\n1q\n\u001d;j_:\u0004r\u0001\u0015BP?~C\b0C\u0002\u0003\"F\u0013a\u0001V;qY\u0016$\u0004\"\u0003BSg\u0005\u0005\t\u0019AA\u0001\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011y\u000b\u0005\u0003\u0003\n\tE\u0016\u0002\u0002BZ\u0005\u0017\u0011aa\u00142kK\u000e$\b")
public class ApproxTopKCombine
extends TypedImperativeAggregate<CombineInternal<Object>>
implements ImplicitCastInputTypes,
BinaryLike<Expression>,
Serializable {
    private DataType uncheckedItemDataType;
    private int maxItemsTrackedVal;
    private boolean combineSizeSpecified;
    private final Expression state;
    private final Expression maxItemsTracked;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$4() {
        return ApproxTopKCombine$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return ApproxTopKCombine$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(ApproxTopKCombine x$0) {
        return ApproxTopKCombine$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return ApproxTopKCombine$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return ApproxTopKCombine$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, ApproxTopKCombine> tupled() {
        return ApproxTopKCombine$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, ApproxTopKCombine>>>> curried() {
        return ApproxTopKCombine$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ApproxTopKCombine approxTopKCombine = this;
        synchronized (approxTopKCombine) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression state() {
        return this.state;
    }

    public Expression maxItemsTracked() {
        return this.maxItemsTracked;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType uncheckedItemDataType$lzycompute() {
        ApproxTopKCombine approxTopKCombine = this;
        synchronized (approxTopKCombine) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.uncheckedItemDataType = ((StructType)this.state().dataType()).apply(2).dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.uncheckedItemDataType;
    }

    private DataType uncheckedItemDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.uncheckedItemDataType$lzycompute();
        }
        return this.uncheckedItemDataType;
    }

    private int maxItemsTrackedVal$lzycompute() {
        ApproxTopKCombine approxTopKCombine = this;
        synchronized (approxTopKCombine) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.maxItemsTrackedVal = BoxesRunTime.unboxToInt((Object)this.maxItemsTracked().eval(this.maxItemsTracked().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.maxItemsTrackedVal;
    }

    private int maxItemsTrackedVal() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.maxItemsTrackedVal$lzycompute();
        }
        return this.maxItemsTrackedVal;
    }

    private boolean combineSizeSpecified$lzycompute() {
        ApproxTopKCombine approxTopKCombine = this;
        synchronized (approxTopKCombine) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.combineSizeSpecified = this.maxItemsTrackedVal() != ApproxTopK$.MODULE$.VOID_MAX_ITEMS_TRACKED();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.combineSizeSpecified;
    }

    private boolean combineSizeSpecified() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.combineSizeSpecified$lzycompute();
        }
        return this.combineSizeSpecified;
    }

    @Override
    public Expression left() {
        return this.state();
    }

    @Override
    public Expression right() {
        return this.maxItemsTracked();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StructType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        TypeCheckResult stateCheck = ApproxTopK$.MODULE$.checkStateFieldAndType(this.state());
        if (stateCheck.isFailure()) {
            return stateCheck;
        }
        if (!this.maxItemsTracked().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("Number of items tracked must be a constant literal");
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return ApproxTopK$.MODULE$.getSketchStateDataType(this.uncheckedItemDataType());
    }

    @Override
    public CombineInternal<Object> createAggregationBuffer() {
        if (this.combineSizeSpecified()) {
            int maxMapSize = ApproxTopK$.MODULE$.calMaxMapSize(this.maxItemsTrackedVal());
            return new CombineInternal<Object>(new ApproxTopKAggregateBuffer(new ItemsSketch(maxMapSize), 0L), null, this.maxItemsTrackedVal());
        }
        int maxMapSize = ApproxTopK$.MODULE$.calMaxMapSize(ApproxTopK$.MODULE$.MAX_ITEMS_TRACKED_LIMIT());
        return new CombineInternal<Object>(new ApproxTopKAggregateBuffer(new ItemsSketch(maxMapSize), 0L), null, ApproxTopK$.MODULE$.VOID_MAX_ITEMS_TRACKED());
    }

    @Override
    public CombineInternal<Object> update(CombineInternal<Object> buffer, InternalRow input) {
        InternalRow inputState = (InternalRow)this.state().eval(input);
        byte[] inputSketchBytes = inputState.getBinary(0);
        int inputMaxItemsTracked = inputState.getInt(1);
        String inputItemDataTypeDDL = inputState.getUTF8String(3).toString();
        DataType inputItemDataType = ApproxTopK$.MODULE$.DDLToDataType(inputItemDataTypeDDL);
        buffer.updateMaxItemsTracked(this.combineSizeSpecified(), inputMaxItemsTracked);
        buffer.updateItemDataType(inputItemDataType);
        ApproxTopKAggregateBuffer<Object> inputSketchWithNullCount = ApproxTopKAggregateBuffer$.MODULE$.deserialize(inputSketchBytes, ApproxTopK$.MODULE$.genSketchSerDe(inputItemDataType));
        buffer.updateSketchWithNullCount(inputSketchWithNullCount);
        return buffer;
    }

    @Override
    public CombineInternal<Object> merge(CombineInternal<Object> buffer, CombineInternal<Object> input) {
        buffer.updateMaxItemsTracked(this.combineSizeSpecified(), input.getMaxItemsTracked());
        buffer.updateItemDataType(input.getItemDataType());
        buffer.getSketchWithNullCount().merge(input.getSketchWithNullCount());
        return buffer;
    }

    @Override
    public Object eval(CombineInternal<Object> buffer) {
        byte[] sketchBytes = buffer.getSketchWithNullCount().serialize(ApproxTopK$.MODULE$.genSketchSerDe(buffer.getItemDataType()));
        int maxItemsTracked = buffer.getMaxItemsTracked();
        String itemDataTypeDDL = ApproxTopK$.MODULE$.dataTypeToDDL(buffer.getItemDataType());
        return InternalRow$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{sketchBytes, BoxesRunTime.boxToInteger((int)maxItemsTracked), null, UTF8String.fromString((String)itemDataTypeDDL)}));
    }

    @Override
    public byte[] serialize(CombineInternal<Object> buffer) {
        return buffer.serialize();
    }

    @Override
    public CombineInternal<Object> deserialize(byte[] buffer) {
        return CombineInternal$.MODULE$.deserialize(buffer);
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "approx_top_k_combine");
    }

    public ApproxTopKCombine copy(Expression state, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproxTopKCombine(state, maxItemsTracked, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.state();
    }

    public Expression copy$default$2() {
        return this.maxItemsTracked();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproxTopKCombine";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.state();
            }
            case 1: {
                return this.maxItemsTracked();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproxTopKCombine;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "state";
            }
            case 1: {
                return "maxItemsTracked";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproxTopKCombine)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproxTopKCombine approxTopKCombine = (ApproxTopKCombine)x$1;
        if (this.mutableAggBufferOffset() != approxTopKCombine.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approxTopKCombine.inputAggBufferOffset()) return false;
        Expression expression = this.state();
        Expression expression2 = approxTopKCombine.state();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.maxItemsTracked();
        Expression expression4 = approxTopKCombine.maxItemsTracked();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!approxTopKCombine.canEqual(this)) return false;
        return true;
    }

    public ApproxTopKCombine(Expression state, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.state = state;
        this.maxItemsTracked = maxItemsTracked;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
    }

    public ApproxTopKCombine(Expression child, Expression maxItemsTracked) {
        this(child, maxItemsTracked, 0, 0);
        ApproxTopK$.MODULE$.checkExpressionNotNull(maxItemsTracked, "maxItemsTracked");
        ApproxTopK$.MODULE$.checkMaxItemsTracked(this.maxItemsTrackedVal());
    }

    public ApproxTopKCombine(Expression child, int maxItemsTracked) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)maxItemsTracked)));
    }

    public ApproxTopKCombine(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.VOID_MAX_ITEMS_TRACKED())), 0, 0);
    }
}

