/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal.types;

import java.util.HashMap;
import java.util.List;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.sql.internal.types.SpatialReferenceSystemInformation;

@Unstable
public class SpatialReferenceSystemCache {
    private static volatile SpatialReferenceSystemCache instance = null;
    private final HashMap<Integer, SpatialReferenceSystemInformation> sridToSrs = new HashMap();
    private final HashMap<String, SpatialReferenceSystemInformation> stringIdToSrs = new HashMap();

    private SpatialReferenceSystemCache() {
        this.populateSpatialReferenceSystemInformationMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpatialReferenceSystemCache getInstance() {
        if (instance != null) return instance;
        Class<SpatialReferenceSystemCache> clazz = SpatialReferenceSystemCache.class;
        synchronized (SpatialReferenceSystemCache.class) {
            if (instance != null) return instance;
            instance = new SpatialReferenceSystemCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void populateSpatialReferenceSystemInformationMapping() {
        List<SpatialReferenceSystemInformation> srsInformationList = List.of(new SpatialReferenceSystemInformation(0, "SRID:0", false), new SpatialReferenceSystemInformation(3857, "EPSG:3857", false), new SpatialReferenceSystemInformation(4326, "OGC:CRS84", true));
        for (SpatialReferenceSystemInformation srsInformation : srsInformationList) {
            this.sridToSrs.put(srsInformation.srid(), srsInformation);
            this.stringIdToSrs.put(srsInformation.stringId(), srsInformation);
        }
    }

    public SpatialReferenceSystemInformation getSrsInfo(int srid) {
        return this.sridToSrs.getOrDefault(srid, null);
    }

    public SpatialReferenceSystemInformation getSrsInfo(String stringId) {
        return this.stringIdToSrs.getOrDefault(stringId, null);
    }
}

