/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;

public class NodeUtils {
    public static <T> void iterateTask(Collection<Task<?>> tasks, Class<T> clazz, Function<T> function) {
        HashSet<Task> visited = new HashSet<Task>();
        for (Task<?> task : tasks) {
            NodeUtils.iterateTask(task, clazz, function, visited);
        }
    }

    private static <T> void iterateTask(Task<?> task, Class<T> clazz, Function<T> function, Set<Task> visited) {
        if (!visited.add(task)) {
            return;
        }
        if (clazz.isInstance(task)) {
            function.apply(clazz.cast(task));
        }
        if (task.getDependentTasks() != null) {
            for (Task<Serializable> dependent : task.getDependentTasks()) {
                NodeUtils.iterateTask(dependent, clazz, function, visited);
            }
        }
    }

    public static <T> void iterate(Collection<? extends Node> nodes, Class<T> clazz, Function<T> function) {
        HashSet<Node> visited = new HashSet<Node>();
        for (Node node : nodes) {
            NodeUtils.iterate(node, clazz, function, visited);
        }
    }

    private static <T> void iterate(Node node, Class<T> clazz, Function<T> function, Set<Node> visited) {
        if (!visited.add(node)) {
            return;
        }
        if (clazz.isInstance(node)) {
            function.apply(clazz.cast(node));
        }
        if (node.getChildren() != null) {
            for (Node node2 : node.getChildren()) {
                NodeUtils.iterate(node2, clazz, function, visited);
            }
        }
    }

    public static interface Function<T> {
        public void apply(T var1);
    }
}

