/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NettyManagedBuffer;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;

public final class OneWayMessage
extends AbstractMessage
implements RequestMessage {
    public OneWayMessage(ManagedBuffer body) {
        super(body, true);
    }

    @Override
    public Message.Type type() {
        return Message.Type.OneWayMessage;
    }

    @Override
    public int encodedLength() {
        return 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeInt((int)this.body().size());
    }

    public static OneWayMessage decode(ByteBuf buf) {
        buf.readInt();
        return new OneWayMessage(new NettyManagedBuffer(buf.retain()));
    }

    public int hashCode() {
        return Objects.hashCode(this.body());
    }

    public boolean equals(Object other) {
        if (other instanceof OneWayMessage) {
            OneWayMessage o = (OneWayMessage)other;
            return super.equals(o);
        }
        return false;
    }

    public String toString() {
        return "OneWayMessage[body=" + String.valueOf(this.body()) + "]";
    }
}

