/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.protocol.AbstractResponseMessage;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.protocol.StreamFailure;

public final class StreamResponse
extends AbstractResponseMessage {
    public final String streamId;
    public final long byteCount;

    public StreamResponse(String streamId, long byteCount, ManagedBuffer buffer) {
        super(buffer, false);
        this.streamId = streamId;
        this.byteCount = byteCount;
    }

    @Override
    public Message.Type type() {
        return Message.Type.StreamResponse;
    }

    @Override
    public int encodedLength() {
        return 8 + Encoders.Strings.encodedLength(this.streamId);
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.Strings.encode(buf, this.streamId);
        buf.writeLong(this.byteCount);
    }

    @Override
    public ResponseMessage createFailureResponse(String error) {
        return new StreamFailure(this.streamId, error);
    }

    public static StreamResponse decode(ByteBuf buf) {
        String streamId = Encoders.Strings.decode(buf);
        long byteCount = buf.readLong();
        return new StreamResponse(streamId, byteCount, null);
    }

    public int hashCode() {
        return Objects.hash(this.byteCount, this.streamId);
    }

    public boolean equals(Object other) {
        if (other instanceof StreamResponse) {
            StreamResponse o = (StreamResponse)other;
            return this.byteCount == o.byteCount && this.streamId.equals(o.streamId);
        }
        return false;
    }

    public String toString() {
        return "StreamResponse[streamId=" + this.streamId + ",byteCount=" + this.byteCount + ",body=" + String.valueOf(this.body()) + "]";
    }
}

