/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channels;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFiles$;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.api.python.PythonWorker;
import org.apache.spark.api.python.PythonWorkerFactory$;
import org.apache.spark.api.python.PythonWorkerLogCapture;
import org.apache.spark.api.python.PythonWorkerLogCapture$;
import org.apache.spark.api.python.PythonWorkerUtils$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.security.SocketAuthHelper;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.WeakHashMap;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\t\u001de!\u0002\"D\u0001\u001dk\u0005\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u001d\u0004!\u0011!Q\u0001\nqC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tS\u0002\u0011\t\u0011)A\u0005U\"AQ\u000e\u0001BC\u0002\u0013\u0005a\u000e\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003p\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015\u0019\b\u0001\"\u0001}\u0011!\t\u0019\u0001\u0001b\u0001\n\u0013q\u0007bBA\u0003\u0001\u0001\u0006Ia\u001c\u0005\n\u0003\u000f\u0001!\u0019!C\u0005\u0003\u0013A\u0001\"a\u0005\u0001A\u0003%\u00111\u0002\u0005\n\u0003+\u0001!\u0019!C\u0005\u0003/A\u0001\"!\n\u0001A\u0003%\u0011\u0011\u0004\u0005\t\u0003O\u0001!\u0019!C\u0005]\"9\u0011\u0011\u0006\u0001!\u0002\u0013y\u0007\"CA\u0016\u0001\u0001\u0007I\u0011BA\u0017\u0011%\ty\u0004\u0001a\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0015BA\u0018\u0011%\tY\u0007\u0001b\u0001\n\u0003\ti\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA8\u0011%\ti\b\u0001a\u0001\n\u0013\ty\bC\u0005\u0002\b\u0002\u0001\r\u0011\"\u0003\u0002\n\"A\u0011Q\u0012\u0001!B\u0013\t\t\tC\u0005\u0002\u0012\u0002\u0011\r\u0011\"\u0003\u0002\u0014\"A\u0011\u0011\u0017\u0001!\u0002\u0013\t)\nC\u0006\u00026\u0002\u0001\r\u00111A\u0005\n\u0005]\u0006bCA]\u0001\u0001\u0007\t\u0019!C\u0005\u0003wC!\"a0\u0001\u0001\u0004\u0005\t\u0015)\u0003]\u0011)\t\u0019\r\u0001b\u0001\n\u00039\u0015Q\u0019\u0005\t\u0003\u001b\u0004\u0001\u0015!\u0003\u0002H\"I\u0011\u0011\u001b\u0001C\u0002\u0013%\u00111\u001b\u0005\t\u00037\u0004\u0001\u0015!\u0003\u0002V\"I\u0011q\u001c\u0001A\u0002\u0013%\u0011\u0011\u001d\u0005\n\u0003S\u0004\u0001\u0019!C\u0005\u0003WD\u0001\"a<\u0001A\u0003&\u00111\u001d\u0005\n\u0003g\u0004!\u0019!C\u0005\u0003kD\u0001\"!?\u0001A\u0003%\u0011q\u001f\u0005\n\u0003{\u0004!\u0019!C\u0005\u0003oCq!a@\u0001A\u0003%A\fC\u0004\u0003\u0002\u0001!\tAa\u0001\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0004!A!q\u0002\u0001\u0005\u0002\u001d\u0013\t\u0002C\u0004\u0003\u0018\u0001!IA!\u0007\t\u0013\tm\u0001A1A\u0005\n\tu\u0001\u0002\u0003B\u0014\u0001\u0001\u0006IAa\b\t\u000f\t%\u0002\u0001\"\u0003\u0003,\u00191!\u0011\t\u0001\u0005\u0005\u0007Baa\u001d\u0019\u0005\u0002\t-\u0003b\u0002B)a\u0011\u0005#\u0011\u0004\u0005\b\u0005'\u0002A\u0011\u0002B\r\u0011\u001d\u0011)\u0006\u0001C\u0005\u00053AqAa\u0016\u0001\t\u0003\u0011I\u0002C\u0004\u0003Z\u0001!\tAa\u0017\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d!9!q\r\u0001\u0005\u0002\t%t\u0001\u0003B7\u0007\"\u0005qIa\u001c\u0007\u000f\t\u001b\u0005\u0012A$\u0003r!11O\u000fC\u0001\u0005gB\u0011B!\u001e;\u0005\u0004%\t!a \t\u0011\t]$\b)A\u0005\u0003\u0003C\u0011B!\u001f;\u0005\u0004%\t!!9\t\u0011\tm$\b)A\u0005\u0003GD!B! ;\u0005\u0004%\ta\u0012B@\u0011!\u0011)I\u000fQ\u0001\n\t\u0005%a\u0005)zi\"|gnV8sW\u0016\u0014h)Y2u_JL(B\u0001#F\u0003\u0019\u0001\u0018\u0010\u001e5p]*\u0011aiR\u0001\u0004CBL'B\u0001%J\u0003\u0015\u0019\b/\u0019:l\u0015\tQ5*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0006\u0019qN]4\u0014\u0007\u0001qE\u000b\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006K\u0001\u0004B]f\u0014VM\u001a\t\u0003+bk\u0011A\u0016\u0006\u0003/\u001e\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00033Z\u0013q\u0001T8hO&tw-\u0001\u0006qsRDwN\\#yK\u000e\u001c\u0001\u0001\u0005\u0002^I:\u0011aL\u0019\t\u0003?Bk\u0011\u0001\u0019\u0006\u0003Cn\u000ba\u0001\u0010:p_Rt\u0014BA2Q\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r\u0004\u0016\u0001D<pe.,'/T8ek2,\u0017\u0001\u00043bK6|g.T8ek2,\u0017aB3omZ\u000b'o\u001d\t\u0005;.dF,\u0003\u0002mM\n\u0019Q*\u00199\u0002!U\u001cX\rR1f[>tWI\\1cY\u0016$W#A8\u0011\u0005=\u0003\u0018BA9Q\u0005\u001d\u0011un\u001c7fC:\f\u0011#^:f\t\u0006,Wn\u001c8F]\u0006\u0014G.\u001a3!\u0003\u0019a\u0014N\\5u}Q1Qo\u001e=zun\u0004\"A\u001e\u0001\u000e\u0003\rCQAW\u0004A\u0002qCQaZ\u0004A\u0002qCQ\u0001[\u0004A\u0002qCQ![\u0004A\u0002)DQ!\\\u0004A\u0002=$b!^?\u007f\u007f\u0006\u0005\u0001\"\u0002.\t\u0001\u0004a\u0006\"B4\t\u0001\u0004a\u0006\"B5\t\u0001\u0004Q\u0007\"B7\t\u0001\u0004y\u0017!C;tK\u0012\u000bW-\\8o\u0003))8/\u001a#bK6|g\u000eI\u0001\u0005G>tg-\u0006\u0002\u0002\fA!\u0011QBA\b\u001b\u00059\u0015bAA\t\u000f\nI1\u000b]1sW\u000e{gNZ\u0001\u0006G>tg\rI\u0001\u000bCV$\b\u000eS3ma\u0016\u0014XCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010\u000f\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002$\u0005u!\u0001E*pG.,G/Q;uQ\"+G\u000e]3s\u0003-\tW\u000f\u001e5IK2\u0004XM\u001d\u0011\u0002!%\u001cXK\\5y\t>l\u0017-\u001b8T_\u000e\\\u0017!E5t+:L\u0007\u0010R8nC&t7k\\2lA\u00051A-Y3n_:,\"!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005!A.\u00198h\u0015\t\tI$\u0001\u0003kCZ\f\u0017\u0002BA\u001f\u0003g\u0011q\u0001\u0015:pG\u0016\u001c8/\u0001\u0006eC\u0016lwN\\0%KF$B!a\u0011\u0002JA\u0019q*!\u0012\n\u0007\u0005\u001d\u0003K\u0001\u0003V]&$\b\"CA&%\u0005\u0005\t\u0019AA\u0018\u0003\rAH%M\u0001\bI\u0006,Wn\u001c8!Q\u001d\u0019\u0012\u0011KA3\u0003O\u0002B!a\u0015\u0002b5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u0017\u0002^\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005}\u0013!\u00026bm\u0006D\u0018\u0002BA2\u0003+\u0012\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0005\u0005%\u0014\u0001B:fY\u001a\f!\u0002Z1f[>t\u0007j\\:u+\t\ty\u0007\u0005\u0003\u0002r\u0005]TBAA:\u0015\u0011\t)(a\u000e\u0002\u00079,G/\u0003\u0003\u0002z\u0005M$aC%oKR\fE\r\u001a:fgN\f1\u0002Z1f[>t\u0007j\\:uA\u0005QA-Y3n_:\u0004vN\u001d;\u0016\u0005\u0005\u0005\u0005cA(\u0002\u0004&\u0019\u0011Q\u0011)\u0003\u0007%sG/\u0001\beC\u0016lwN\u001c)peR|F%Z9\u0015\t\u0005\r\u00131\u0012\u0005\n\u0003\u0017:\u0012\u0011!a\u0001\u0003\u0003\u000b1\u0002Z1f[>t\u0007k\u001c:uA!:\u0001$!\u0015\u0002f\u0005\u001d\u0014!\u00043bK6|gnV8sW\u0016\u00148/\u0006\u0002\u0002\u0016BA\u0011qSAQ\u0003K\u000bY+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003\u001diW\u000f^1cY\u0016T1!a(Q\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\u000bIJA\u0006XK\u0006\\\u0007*Y:i\u001b\u0006\u0004\bc\u0001<\u0002(&\u0019\u0011\u0011V\"\u0003\u0019AKH\u000f[8o/>\u00148.\u001a:\u0011\t\u0005E\u0012QV\u0005\u0005\u0003_\u000b\u0019DA\u0007Qe>\u001cWm]:IC:$G.Z\u0001\u000fI\u0006,Wn\u001c8X_J\\WM]:!Q\u001dQ\u0012\u0011KA3\u0003O\na\u0002Z1f[>t7k\\2l!\u0006$\b.F\u0001]\u0003I!\u0017-Z7p]N{7m\u001b)bi\"|F%Z9\u0015\t\u0005\r\u0013Q\u0018\u0005\t\u0003\u0017b\u0012\u0011!a\u00019\u0006yA-Y3n_:\u001cvnY6QCRD\u0007\u0005K\u0004\u001e\u0003#\n)'a\u001a\u0002\u0017%$G.Z,pe.,'o]\u000b\u0003\u0003\u000f\u0004b!a&\u0002J\u0006\u0015\u0016\u0002BAf\u00033\u0013Q!U;fk\u0016\fA\"\u001b3mK^{'o[3sg\u0002BsaHA)\u0003K\n9'A\u000bnCbLE\r\\3X_J\\WM\u001d)p_2\u001c\u0016N_3\u0016\u0005\u0005U\u0007#B(\u0002X\u0006\u0005\u0015bAAm!\n1q\n\u001d;j_:\fa#\\1y\u0013\u0012dWmV8sW\u0016\u0014\bk\\8m'&TX\r\t\u0015\bC\u0005E\u0013QMA4\u00039a\u0017m\u001d;BGRLg/\u001b;z\u001dN,\"!a9\u0011\u0007=\u000b)/C\u0002\u0002hB\u0013A\u0001T8oO\u0006\u0011B.Y:u\u0003\u000e$\u0018N^5us:\u001bx\fJ3r)\u0011\t\u0019%!<\t\u0013\u0005-3%!AA\u0002\u0005\r\u0018a\u00047bgR\f5\r^5wSRLhj\u001d\u0011)\u000f\u0011\n\t&!\u001a\u0002h\u0005i1/[7qY\u0016<vN]6feN,\"!a>\u0011\u0011\u0005]\u0015\u0011UAS\u0003_\tab]5na2,wk\u001c:lKJ\u001c\b\u0005K\u0004'\u0003#\n)'a\u001a\u0002\u0015ALH\u000f[8o!\u0006$\b.A\u0006qsRDwN\u001c)bi\"\u0004\u0013AB2sK\u0006$X\r\u0006\u0002\u0003\u0006A9qJa\u0002\u0002&\n-\u0011b\u0001B\u0005!\n1A+\u001e9mKJ\u0002RaTAl\u0003W\u000b1c\u0019:fCR,G\u000b\u001b:pk\u001eDG)Y3n_:\f!c\u0019:fCR,7+[7qY\u0016<vN]6feR!!Q\u0001B\n\u0011\u0019\u0011)b\u000ba\u0001_\u0006a!\r\\8dW&tw-T8eK\u0006Y1\u000f^1si\u0012\u000bW-\\8o)\t\t\u0019%\u0001\tx_J\\WM\u001d'pO\u000e\u000b\u0007\u000f^;sKV\u0011!q\u0004\t\u0006\u001f\u0006]'\u0011\u0005\t\u0004m\n\r\u0012b\u0001B\u0013\u0007\n1\u0002+\u001f;i_:<vN]6fe2{wmQ1qiV\u0014X-A\tx_J\\WM\u001d'pO\u000e\u000b\u0007\u000f^;sK\u0002\nqC]3eSJ,7\r^*ue\u0016\fWn\u001d+p'R$WM\u001d:\u0015\r\u0005\r#Q\u0006B\u001f\u0011\u001d\u0011yc\fa\u0001\u0005c\taa\u001d;e_V$\b\u0003\u0002B\u001a\u0005si!A!\u000e\u000b\t\t]\u0012qG\u0001\u0003S>LAAa\u000f\u00036\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\u0011yd\fa\u0001\u0005c\taa\u001d;eKJ\u0014(!D'p]&$xN\u001d+ie\u0016\fGmE\u00021\u0005\u000b\u0002B!!\r\u0003H%!!\u0011JA\u001a\u0005\u0019!\u0006N]3bIR\u0011!Q\n\t\u0004\u0005\u001f\u0002T\"\u0001\u0001\u0002\u0007I,h.\u0001\ndY\u0016\fg.\u001e9JI2,wk\u001c:lKJ\u001c\u0018AC:u_B$\u0015-Z7p]\u0006!1\u000f^8q\u0003)\u0019Ho\u001c9X_J\\WM\u001d\u000b\u0005\u0003\u0007\u0012i\u0006C\u0004\u0003`Y\u0002\r!!*\u0002\r]|'o[3s\u00035\u0011X\r\\3bg\u0016<vN]6feR!\u00111\tB3\u0011\u001d\u0011yf\u000ea\u0001\u0003K\u000bq\"[:X_J\\WM]*u_B\u0004X\r\u001a\u000b\u0004_\n-\u0004b\u0002B0q\u0001\u0007\u0011QU\u0001\u0014!f$\bn\u001c8X_J\\WM\u001d$bGR|'/\u001f\t\u0003mj\u001a\"A\u000f(\u0015\u0005\t=\u0014a\u0006)S\u001f\u000e+5kU0X\u0003&#v\fV%N\u000b>+FkX'T\u0003a\u0001&kT\"F'N{v+Q%U?RKU*R(V)~k5\u000bI\u0001\u0017\u0013\u0012cUiX,P%.+%k\u0018+J\u001b\u0016{U\u000bV0O'\u00069\u0012\n\u0012'F?^{%kS#S?RKU*R(V)~s5\u000bI\u0001\u0014I\u00164\u0017-\u001e7u\t\u0006,Wn\u001c8N_\u0012,H.Z\u000b\u0003\u0005\u0003\u0003B!!\r\u0003\u0004&\u0019Q-a\r\u0002)\u0011,g-Y;mi\u0012\u000bW-\\8o\u001b>$W\u000f\\3!\u0001")
public class PythonWorkerFactory
implements Logging {
    public final String org$apache$spark$api$python$PythonWorkerFactory$$pythonExec;
    private final String workerModule;
    private final String daemonModule;
    private final scala.collection.immutable.Map<String, String> envVars;
    private final boolean useDaemonEnabled;
    private final boolean useDaemon;
    private final SparkConf conf;
    private final SocketAuthHelper authHelper;
    private final boolean isUnixDomainSock;
    @GuardedBy(value="self")
    private Process daemon;
    private final InetAddress daemonHost;
    @GuardedBy(value="self")
    private int daemonPort;
    @GuardedBy(value="self")
    private final WeakHashMap<PythonWorker, ProcessHandle> daemonWorkers;
    @GuardedBy(value="self")
    private String daemonSockPath;
    @GuardedBy(value="self")
    private final Queue<PythonWorker> idleWorkers;
    @GuardedBy(value="self")
    private final Option<Object> maxIdleWorkerPoolSize;
    @GuardedBy(value="self")
    private long org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs;
    @GuardedBy(value="self")
    private final WeakHashMap<PythonWorker, Process> simpleWorkers;
    private final String pythonPath;
    private final Option<PythonWorkerLogCapture> workerLogCapture;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long IDLE_WORKER_TIMEOUT_NS() {
        return PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_NS();
    }

    public static int PROCESS_WAIT_TIMEOUT_MS() {
        return PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean useDaemonEnabled() {
        return this.useDaemonEnabled;
    }

    private boolean useDaemon() {
        return this.useDaemon;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private SocketAuthHelper authHelper() {
        return this.authHelper;
    }

    private boolean isUnixDomainSock() {
        return this.isUnixDomainSock;
    }

    private Process daemon() {
        return this.daemon;
    }

    private void daemon_$eq(Process x$1) {
        this.daemon = x$1;
    }

    public InetAddress daemonHost() {
        return this.daemonHost;
    }

    private int daemonPort() {
        return this.daemonPort;
    }

    private void daemonPort_$eq(int x$1) {
        this.daemonPort = x$1;
    }

    private WeakHashMap<PythonWorker, ProcessHandle> daemonWorkers() {
        return this.daemonWorkers;
    }

    private String daemonSockPath() {
        return this.daemonSockPath;
    }

    private void daemonSockPath_$eq(String x$1) {
        this.daemonSockPath = x$1;
    }

    public Queue<PythonWorker> idleWorkers() {
        return this.idleWorkers;
    }

    private Option<Object> maxIdleWorkerPoolSize() {
        return this.maxIdleWorkerPoolSize;
    }

    public long org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs() {
        return this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs;
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(long x$1) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs = x$1;
    }

    private WeakHashMap<PythonWorker, Process> simpleWorkers() {
        return this.simpleWorkers;
    }

    private String pythonPath() {
        return this.pythonPath;
    }

    public Tuple2<PythonWorker, Option<ProcessHandle>> create() {
        Tuple2<PythonWorker, Option<ProcessHandle>> tuple2;
        block8: {
            Object object = new Object();
            try {
                if (this.useDaemon()) {
                    PythonWorkerFactory pythonWorkerFactory = this;
                    synchronized (pythonWorkerFactory) {
                        while (this.idleWorkers().nonEmpty()) {
                            PythonWorker worker = (PythonWorker)this.idleWorkers().dequeue();
                            this.daemonWorkers().get((Object)worker).foreach((Function1 & Serializable)workerHandle -> {
                                PythonWorkerFactory.$anonfun$create$1(object, worker, workerHandle);
                                return BoxedUnit.UNIT;
                            });
                            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Worker ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.WORKER, worker)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"process from idle queue is dead, discarding."}))).log((Seq)Nil$.MODULE$))));
                            this.stopWorker(worker);
                        }
                    }
                    tuple2 = this.createThroughDaemon();
                    break block8;
                }
                tuple2 = this.createSimpleWorker(false);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    tuple2 = (Tuple2<PythonWorker, Option<ProcessHandle>>)ex.value();
                }
                throw ex;
            }
        }
        return tuple2;
    }

    private Tuple2<PythonWorker, Option<ProcessHandle>> createThroughDaemon() {
        Tuple2 tuple2;
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            this.startDaemon();
            tuple2 = this.liftedTree1$1();
        }
        return tuple2;
    }

    public Tuple2<PythonWorker, Option<ProcessHandle>> createSimpleWorker(boolean blockingMode) {
        Tuple2 tuple2;
        LazyRef sockPath$lzy = new LazyRef();
        ServerSocketChannel serverSocketChannel = null;
        try {
            String jobArtifactUUID;
            if (this.isUnixDomainSock()) {
                serverSocketChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
                this.sockPath$1(sockPath$lzy).deleteOnExit();
                v0 = serverSocketChannel.bind(UnixDomainSocketAddress.of(this.sockPath$1(sockPath$lzy).getPath()));
            } else {
                serverSocketChannel = ServerSocketChannel.open();
                v0 = serverSocketChannel.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), 1);
            }
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.workerModule}));
            String string = jobArtifactUUID = (String)this.envVars.getOrElse((Object)"SPARK_JOB_ARTIFACT_UUID", (Function0 & Serializable)() -> "default");
            String string2 = "default";
            if (string == null ? string2 != null : !string.equals(string2)) {
                File f = new File(SparkFiles$.MODULE$.getRootDirectory(), jobArtifactUUID);
                f.mkdir();
                v2 = pb.directory(f);
            } else {
                v2 = BoxedUnit.UNIT;
            }
            Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll(CollectionConverters$.MODULE$.MapHasAsJava(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            if (this.isUnixDomainSock()) {
                workerEnv.put("PYTHON_WORKER_FACTORY_SOCK_PATH", this.sockPath$1(sockPath$lzy).getPath());
                v3 = workerEnv.put("PYTHON_UNIX_DOMAIN_ENABLED", "True");
            } else {
                workerEnv.put("PYTHON_WORKER_FACTORY_PORT", Integer.toString(serverSocketChannel.socket().getLocalPort()));
                v3 = workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            }
            Object object = Utils$.MODULE$.preferIPv6() ? workerEnv.put("SPARK_PREFER_IPV6", "True") : BoxedUnit.UNIT;
            Process workerProcess = pb.start();
            this.redirectStreamsToStderr(workerProcess.getInputStream(), workerProcess.getErrorStream());
            try {
                serverSocketChannel.configureBlocking(false);
                Selector serverSelector = Selector.open();
                serverSocketChannel.register(serverSelector, 16);
                if (serverSelector.select(10000L) <= 0) {
                    throw new SocketTimeoutException("Timed out while waiting for the Python worker to connect back");
                }
                SocketChannel socketChannel = serverSocketChannel.accept();
                this.authHelper().authClient(socketChannel);
                int pid = new DataInputStream(Channels.newInputStream(socketChannel)).readInt();
                if (pid < 0) {
                    throw new IllegalStateException("Python failed to launch worker with code " + pid);
                }
                Object object2 = !blockingMode ? socketChannel.configureBlocking(false) : BoxedUnit.UNIT;
                PythonWorker worker = new PythonWorker(socketChannel);
                PythonWorkerFactory pythonWorkerFactory = this;
                synchronized (pythonWorkerFactory) {
                    this.simpleWorkers().put((Object)worker, (Object)workerProcess);
                }
                tuple2 = new Tuple2((Object)worker.refresh(), (Object)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(ProcessHandle.of(pid))));
            }
            catch (Exception e) {
                throw new SparkException("Python worker failed to connect back.", (Throwable)e);
            }
        }
        finally {
            if (serverSocketChannel != null) {
                serverSocketChannel.close();
                if (this.isUnixDomainSock()) {
                    this.sockPath$1(sockPath$lzy).delete();
                }
            }
        }
        return tuple2;
    }

    private synchronized void startDaemon() {
        if (this.daemon() != null) {
            return;
        }
        try {
            String errorMsg;
            String jobArtifactUUID;
            List<Object> command = Arrays.asList((Object[])new String[]{this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, "-m", this.daemonModule, this.workerModule});
            ProcessBuilder pb = new ProcessBuilder(command);
            String string = jobArtifactUUID = (String)this.envVars.getOrElse((Object)"SPARK_JOB_ARTIFACT_UUID", (Function0 & Serializable)() -> "default");
            String string2 = "default";
            if (string == null ? string2 != null : !string.equals(string2)) {
                File f = new File(SparkFiles$.MODULE$.getRootDirectory(), jobArtifactUUID);
                f.mkdir();
                v1 = pb.directory(f);
            } else {
                v1 = BoxedUnit.UNIT;
            }
            Map<String, String> workerEnv = pb.environment();
            workerEnv.putAll(CollectionConverters$.MODULE$.MapHasAsJava(this.envVars).asJava());
            workerEnv.put("PYTHONPATH", this.pythonPath());
            if (this.isUnixDomainSock()) {
                workerEnv.put("PYTHON_WORKER_FACTORY_SOCK_DIR", this.authHelper().sockDir());
                v2 = workerEnv.put("PYTHON_UNIX_DOMAIN_ENABLED", "True");
            } else {
                v2 = workerEnv.put("PYTHON_WORKER_FACTORY_SECRET", this.authHelper().secret());
            }
            Object object = Utils$.MODULE$.preferIPv6() ? workerEnv.put("SPARK_PREFER_IPV6", "True") : BoxedUnit.UNIT;
            workerEnv.put("PYTHONUNBUFFERED", "YES");
            this.daemon_$eq(pb.start());
            DataInputStream in = new DataInputStream(this.daemon().getInputStream());
            try {
                if (this.isUnixDomainSock()) {
                    this.daemonSockPath_$eq(PythonWorkerUtils$.MODULE$.readUTF(in));
                } else {
                    this.daemonPort_$eq(in.readInt());
                }
            }
            catch (EOFException eOFException) {
                if (this.daemon().isAlive()) {
                    throw SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError(this.daemonModule, SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError$default$2());
                }
                throw SparkCoreErrors$.MODULE$.eofExceptionWhileReadPortNumberError(this.daemonModule, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.daemon().exitValue())));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            boolean isMalformedPort = !this.isUnixDomainSock() && (this.daemonPort() < 1 || this.daemonPort() > 65535);
            boolean isMalformedSockPath = this.isUnixDomainSock() && !new File(this.daemonSockPath()).exists();
            String string3 = errorMsg = this.isUnixDomainSock() ? this.daemonSockPath() : StringOps$.MODULE$.format$extension("%s (0x%08x)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.daemonPort()), BoxesRunTime.boxToInteger((int)this.daemonPort())}));
            if (isMalformedPort || isMalformedSockPath) {
                String exceptionMessage = "\n            |Bad data in " + this.daemonModule + "'s standard output. Invalid port number/socket path:\n            |  " + errorMsg + "\n            |Python command to execute the daemon was:\n            |  " + CollectionConverters$.MODULE$.ListHasAsScala(command).asScala().mkString(" ") + "\n            |Check that you don't have any unexpected modules or libraries in\n            |your PYTHONPATH:\n            |  " + this.pythonPath() + "\n            |Also, check if you have a sitecustomize.py module in your python path,\n            |or in your python installation, that is printing to standard output";
                throw new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(exceptionMessage)));
            }
            this.redirectStreamsToStderr(in, this.daemon().getErrorStream());
        }
        catch (Exception e) {
            String stderr = (String)Option$.MODULE$.apply((Object)this.daemon()).flatMap((Function1 & Serializable)d -> Utils$.MODULE$.getStderr((Process)d, PythonWorkerFactory$.MODULE$.PROCESS_WAIT_TIMEOUT_MS())).getOrElse((Function0 & Serializable)() -> "");
            this.stopDaemon();
            String string = stderr;
            String string4 = "";
            if (string == null ? string4 != null : !string.equals(string4)) {
                String formattedStderr = stderr.replace("\n", "\n  ");
                String errorMessage = "\n              |Error from python worker:\n              |  " + formattedStderr + "\n              |PYTHONPATH was:\n              |  " + this.pythonPath() + "\n              |" + e;
                SparkException wrappedException = new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(errorMessage)));
                wrappedException.setStackTrace(e.getStackTrace());
                throw wrappedException;
            }
            throw e;
        }
    }

    private Option<PythonWorkerLogCapture> workerLogCapture() {
        return this.workerLogCapture;
    }

    private void redirectStreamsToStderr(InputStream stdout, InputStream stderr) {
        try {
            new RedirectThread((InputStream)this.workerLogCapture().map((Function1 & Serializable)x$6 -> x$6.wrapInputStream(stdout)).getOrElse((Function0 & Serializable)() -> stdout), System.err, "stdout reader for " + this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            new RedirectThread(stderr, System.err, "stderr reader for " + this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec, RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception in redirecting streams", (Throwable)e);
        }
    }

    public void org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers() {
        while (this.idleWorkers().nonEmpty()) {
            PythonWorker worker = (PythonWorker)this.idleWorkers().dequeue();
            try {
                worker.stop();
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to stop worker socket", (Throwable)e);
            }
        }
    }

    private synchronized void stopDaemon() {
        if (this.useDaemon()) {
            this.org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
            if (this.daemon() != null) {
                this.daemon().destroy();
            }
            this.daemon_$eq(null);
            this.daemonPort_$eq(0);
            this.daemonSockPath_$eq(null);
            return;
        }
        this.simpleWorkers().values().foreach((Function1 & Serializable)x$7 -> {
            x$7.destroy();
            return BoxedUnit.UNIT;
        });
    }

    public void stop() {
        this.workerLogCapture().foreach((Function1 & Serializable)x$8 -> {
            x$8.closeAllWriters();
            return BoxedUnit.UNIT;
        });
        this.stopDaemon();
    }

    public void stopWorker(PythonWorker worker) {
        PythonWorkerFactory pythonWorkerFactory = this;
        synchronized (pythonWorkerFactory) {
            if (this.useDaemon()) {
                if (this.daemon() != null) {
                    this.daemonWorkers().get((Object)worker).foreach((Function1 & Serializable)processHandle -> {
                        PythonWorkerFactory.$anonfun$stopWorker$1(this, processHandle);
                        return BoxedUnit.UNIT;
                    });
                }
            } else {
                this.simpleWorkers().get((Object)worker).foreach((Function1 & Serializable)x$9 -> {
                    x$9.destroy();
                    return BoxedUnit.UNIT;
                });
            }
        }
        worker.stop();
    }

    public void releaseWorker(PythonWorker worker) {
        if (this.useDaemon()) {
            PythonWorkerFactory pythonWorkerFactory = this;
            synchronized (pythonWorkerFactory) {
                this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(System.nanoTime());
                if (this.maxIdleWorkerPoolSize().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$10 -> this.idleWorkers().size() >= x$10)) {
                    PythonWorker oldestWorker = (PythonWorker)this.idleWorkers().dequeue();
                    this.liftedTree2$1(oldestWorker);
                }
                this.idleWorkers().enqueue((Object)worker);
            }
            return;
        }
        try {
            worker.stop();
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to close worker", (Throwable)e);
        }
    }

    public boolean isWorkerStopped(PythonWorker worker) {
        Predef$.MODULE$.assert(!this.useDaemon(), (Function0 & Serializable)() -> "isWorkerStopped() is not supported for daemon mode");
        return this.simpleWorkers().get((Object)worker).exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)PythonWorkerFactory.$anonfun$isWorkerStopped$2(x$11)));
    }

    public static final /* synthetic */ void $anonfun$create$1(Object nonLocalReturnKey1$1, PythonWorker worker$1, ProcessHandle workerHandle) {
        if (workerHandle.isAlive()) {
            try {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Tuple2((Object)worker$1.refresh(), (Object)new Some((Object)workerHandle)));
            }
            catch (CancelledKeyException cancelledKeyException) {
                return;
            }
        }
    }

    private final Tuple2 createWorker$1() {
        SocketChannel socketChannel = this.isUnixDomainSock() ? SocketChannel.open(UnixDomainSocketAddress.of(this.daemonSockPath())) : SocketChannel.open(new InetSocketAddress(this.daemonHost(), this.daemonPort()));
        int pid = new DataInputStream(Channels.newInputStream(socketChannel)).readInt();
        if (pid < 0) {
            throw new IllegalStateException("Python daemon failed to launch worker with code " + pid);
        }
        ProcessHandle processHandle = ProcessHandle.of(pid).orElseThrow(() -> new IllegalStateException("Python daemon failed to launch worker."));
        this.authHelper().authToServer(socketChannel);
        socketChannel.configureBlocking(false);
        PythonWorker worker = new PythonWorker(socketChannel);
        this.daemonWorkers().put((Object)worker, (Object)processHandle);
        return new Tuple2((Object)worker.refresh(), (Object)new Some((Object)processHandle));
    }

    private final /* synthetic */ Tuple2 liftedTree1$1() {
        Tuple2 tuple2;
        try {
            tuple2 = this.createWorker$1();
        }
        catch (SocketException exc) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to open socket to Python daemon:", (Throwable)exc);
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Assuming that daemon unexpectedly quit, attempting to restart");
            this.stopDaemon();
            this.startDaemon();
            tuple2 = this.createWorker$1();
        }
        return tuple2;
    }

    private final /* synthetic */ File sockPath$lzycompute$1(LazyRef sockPath$lzy$1) {
        File file;
        LazyRef lazyRef = sockPath$lzy$1;
        synchronized (lazyRef) {
            file = sockPath$lzy$1.initialized() ? (File)sockPath$lzy$1.value() : (File)sockPath$lzy$1.initialize((Object)new File(this.authHelper().sockDir(), "." + UUID.randomUUID() + ".sock"));
        }
        return file;
    }

    private final File sockPath$1(LazyRef sockPath$lzy$1) {
        if (sockPath$lzy$1.initialized()) {
            return (File)sockPath$lzy$1.value();
        }
        return this.sockPath$lzycompute$1(sockPath$lzy$1);
    }

    public static final /* synthetic */ void $anonfun$stopWorker$1(PythonWorkerFactory $this, ProcessHandle processHandle) {
        DataOutputStream output = new DataOutputStream($this.daemon().getOutputStream());
        output.writeInt((int)processHandle.pid());
        output.flush();
        $this.daemon().getOutputStream().flush();
    }

    private final /* synthetic */ void liftedTree2$1(PythonWorker oldestWorker$1) {
        try {
            this.stopWorker(oldestWorker$1);
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to stop evicted worker", (Throwable)e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$isWorkerStopped$2(Process x$11) {
        return !x$11.isAlive();
    }

    public PythonWorkerFactory(String pythonExec, String workerModule, String daemonModule, scala.collection.immutable.Map<String, String> envVars, boolean useDaemonEnabled) {
        this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec = pythonExec;
        this.workerModule = workerModule;
        this.daemonModule = daemonModule;
        this.envVars = envVars;
        this.useDaemonEnabled = useDaemonEnabled;
        Logging.$init$((Logging)this);
        this.useDaemon = !Utils$.MODULE$.isWindows() && useDaemonEnabled;
        this.conf = SparkEnv$.MODULE$.get().conf();
        this.authHelper = new SocketAuthHelper(this.conf());
        this.isUnixDomainSock = this.authHelper().isUnixDomainSock();
        this.daemon = null;
        this.daemonHost = InetAddress.getLoopbackAddress();
        this.daemonPort = 0;
        this.daemonWorkers = new WeakHashMap();
        this.idleWorkers = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        this.maxIdleWorkerPoolSize = (Option)this.conf().get(Python$.MODULE$.PYTHON_FACTORY_IDLE_WORKER_MAX_POOL_SIZE());
        this.org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs = 0L;
        new MonitorThread().start();
        this.simpleWorkers = new WeakHashMap();
        this.pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PythonUtils$.MODULE$.sparkPythonPath(), (String)envVars.getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> ""), (String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> "")}));
        this.workerLogCapture = envVars.get((Object)"PYSPARK_SPARK_SESSION_UUID").map((Function1 & Serializable)x$5 -> new PythonWorkerLogCapture((String)x$5, PythonWorkerLogCapture$.MODULE$.$lessinit$greater$default$2()));
    }

    public PythonWorkerFactory(String pythonExec, String workerModule, scala.collection.immutable.Map<String, String> envVars, boolean useDaemonEnabled) {
        this(pythonExec, workerModule, PythonWorkerFactory$.MODULE$.defaultDaemonModule(), envVars, useDaemonEnabled);
    }

    private class MonitorThread
    extends Thread {
        @Override
        public void run() {
            while (true) {
                PythonWorkerFactory pythonWorkerFactory = this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer();
                synchronized (pythonWorkerFactory) {
                    if (PythonWorkerFactory$.MODULE$.IDLE_WORKER_TIMEOUT_NS() < System.nanoTime() - this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs()) {
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$cleanupIdleWorkers();
                        this.org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer().org$apache$spark$api$python$PythonWorkerFactory$$lastActivityNs_$eq(System.nanoTime());
                    }
                }
                Thread.sleep(10000L);
            }
        }

        public /* synthetic */ PythonWorkerFactory org$apache$spark$api$python$PythonWorkerFactory$MonitorThread$$$outer() {
            return PythonWorkerFactory.this;
        }

        public MonitorThread() {
            if (PythonWorkerFactory.this == null) {
                throw null;
            }
            super("Idle Worker Monitor for " + PythonWorkerFactory.this.org$apache$spark$api$python$PythonWorkerFactory$$pythonExec);
            this.setDaemon(true);
        }
    }
}

