/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.scheduler.HDFSCacheTaskLocation;
import org.apache.spark.scheduler.HostTaskLocation;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class HadoopRDD$
implements Logging,
Serializable {
    public static final HadoopRDD$ MODULE$ = new HadoopRDD$();
    private static final Object CONFIGURATION_INSTANTIATION_LOCK;
    private static final DateTimeFormatter org$apache$spark$rdd$HadoopRDD$$DATE_TIME_FORMATTER;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        CONFIGURATION_INSTANTIATION_LOCK = new Object();
        org$apache$spark$rdd$HadoopRDD$$DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss", Locale.US).withZone(ZoneId.systemDefault());
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Object CONFIGURATION_INSTANTIATION_LOCK() {
        return CONFIGURATION_INSTANTIATION_LOCK;
    }

    public DateTimeFormatter org$apache$spark$rdd$HadoopRDD$$DATE_TIME_FORMATTER() {
        return org$apache$spark$rdd$HadoopRDD$$DATE_TIME_FORMATTER;
    }

    public Object getCachedMetadata(String key) {
        return SparkEnv$.MODULE$.get().hadoopJobMetadata().get(key);
    }

    public void org$apache$spark$rdd$HadoopRDD$$putCachedMetadata(String key, Object value) {
        SparkEnv$.MODULE$.get().hadoopJobMetadata().put(key, value);
    }

    public void addLocalConfiguration(String jobTrackerId, int jobId, int splitId, int attemptId, JobConf conf) {
        JobID jobID = new JobID(jobTrackerId, jobId);
        TaskAttemptID taId = new TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobID, TaskType.MAP, splitId), attemptId);
        conf.set("mapreduce.task.id", taId.getTaskID().toString());
        conf.set("mapreduce.task.attempt.id", taId.toString());
        conf.setBoolean("mapreduce.task.ismap", true);
        conf.setInt("mapreduce.task.partition", splitId);
        conf.set("mapreduce.job.id", jobID.toString());
    }

    public Option<Seq<String>> convertSplitLocationInfo(SplitLocationInfo[] infos) {
        return Option$.MODULE$.apply((Object)infos).map((Function1 & Serializable)x$4 -> ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])x$4), (Function1 & Serializable)loc -> {
            String locationStr = loc.getLocation();
            if (locationStr != null) {
                String string = locationStr;
                String string2 = "localhost";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    if (loc.isInMemory()) {
                        MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Partition " + locationStr + " is cached by Hadoop.");
                        return new Some((Object)new HDFSCacheTaskLocation(locationStr).toString());
                    }
                    return new Some((Object)new HostTaskLocation(locationStr).toString());
                }
            }
            return None$.MODULE$;
        }, ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HadoopRDD$.class);
    }

    private HadoopRDD$() {
    }
}

