/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.types.variant;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.UUID;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.network.util.JavaUtils;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;

public class VariantUtil {
    public static final int BASIC_TYPE_BITS = 2;
    public static final int BASIC_TYPE_MASK = 3;
    public static final int TYPE_INFO_MASK = 63;
    public static final int MAX_SHORT_STR_SIZE = 63;
    public static final int PRIMITIVE = 0;
    public static final int SHORT_STR = 1;
    public static final int OBJECT = 2;
    public static final int ARRAY = 3;
    public static final int NULL = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int INT1 = 3;
    public static final int INT2 = 4;
    public static final int INT4 = 5;
    public static final int INT8 = 6;
    public static final int DOUBLE = 7;
    public static final int DECIMAL4 = 8;
    public static final int DECIMAL8 = 9;
    public static final int DECIMAL16 = 10;
    public static final int DATE = 11;
    public static final int TIMESTAMP = 12;
    public static final int TIMESTAMP_NTZ = 13;
    public static final int FLOAT = 14;
    public static final int BINARY = 15;
    public static final int LONG_STR = 16;
    public static final int UUID = 20;
    public static final byte VERSION = 1;
    public static final byte VERSION_MASK = 15;
    public static final int U8_MAX = 255;
    public static final int U16_MAX = 65535;
    public static final int U24_MAX = 0xFFFFFF;
    public static final int U24_SIZE = 3;
    public static final int U32_SIZE = 4;
    public static final int SIZE_LIMIT = JavaUtils.isTesting() ? 0x1000000 : 0x8000000;
    public static final int MAX_DECIMAL4_PRECISION = 9;
    public static final int MAX_DECIMAL8_PRECISION = 18;
    public static final int MAX_DECIMAL16_PRECISION = 38;

    public static void writeLong(byte[] bytes, int pos, long value, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            bytes[pos + i] = (byte)(value >>> 8 * i & 0xFFL);
        }
    }

    public static byte primitiveHeader(int type) {
        return (byte)(type << 2 | 0);
    }

    public static byte shortStrHeader(int size) {
        return (byte)(size << 2 | 1);
    }

    public static byte objectHeader(boolean largeSize, int idSize, int offsetSize) {
        return (byte)((largeSize ? 1 : 0) << 6 | idSize - 1 << 4 | offsetSize - 1 << 2 | 2);
    }

    public static byte arrayHeader(boolean largeSize, int offsetSize) {
        return (byte)((largeSize ? 1 : 0) << 4 | offsetSize - 1 << 2 | 3);
    }

    static SparkRuntimeException malformedVariant() {
        return new SparkRuntimeException("MALFORMED_VARIANT", Map$.MODULE$.empty(), null, new QueryContext[0], "");
    }

    static SparkRuntimeException unknownPrimitiveTypeInVariant(int id) {
        return new SparkRuntimeException("UNKNOWN_PRIMITIVE_TYPE_IN_VARIANT", (Map)new Map.Map1((Object)"id", (Object)Integer.toString(id)), null, new QueryContext[0], "");
    }

    static SparkRuntimeException variantConstructorSizeLimit() {
        return new SparkRuntimeException("VARIANT_CONSTRUCTOR_SIZE_LIMIT", Map$.MODULE$.empty(), null, new QueryContext[0], "");
    }

    static void checkIndex(int pos, int length) {
        if (pos < 0 || pos >= length) {
            throw VariantUtil.malformedVariant();
        }
    }

    static long readLong(byte[] bytes, int pos, int numBytes) {
        VariantUtil.checkIndex(pos, bytes.length);
        VariantUtil.checkIndex(pos + numBytes - 1, bytes.length);
        long result = 0L;
        for (int i = 0; i < numBytes - 1; ++i) {
            long unsignedByteValue = bytes[pos + i] & 0xFF;
            result |= unsignedByteValue << 8 * i;
        }
        long signedByteValue = bytes[pos + numBytes - 1];
        return result |= signedByteValue << 8 * (numBytes - 1);
    }

    public static int readUnsigned(byte[] bytes, int pos, int numBytes) {
        VariantUtil.checkIndex(pos, bytes.length);
        VariantUtil.checkIndex(pos + numBytes - 1, bytes.length);
        int result = 0;
        for (int i = 0; i < numBytes; ++i) {
            int unsignedByteValue = bytes[pos + i] & 0xFF;
            result |= unsignedByteValue << 8 * i;
        }
        if (result < 0) {
            throw VariantUtil.malformedVariant();
        }
        return result;
    }

    public static int getTypeInfo(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        return value[pos] >> 2 & 0x3F;
    }

    public static Type getType(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        switch (basicType) {
            case 1: {
                return Type.STRING;
            }
            case 2: {
                return Type.OBJECT;
            }
            case 3: {
                return Type.ARRAY;
            }
        }
        switch (typeInfo) {
            case 0: {
                return Type.NULL;
            }
            case 1: 
            case 2: {
                return Type.BOOLEAN;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return Type.LONG;
            }
            case 7: {
                return Type.DOUBLE;
            }
            case 8: 
            case 9: 
            case 10: {
                return Type.DECIMAL;
            }
            case 11: {
                return Type.DATE;
            }
            case 12: {
                return Type.TIMESTAMP;
            }
            case 13: {
                return Type.TIMESTAMP_NTZ;
            }
            case 14: {
                return Type.FLOAT;
            }
            case 15: {
                return Type.BINARY;
            }
            case 16: {
                return Type.STRING;
            }
            case 20: {
                return Type.UUID;
            }
        }
        throw VariantUtil.unknownPrimitiveTypeInVariant(typeInfo);
    }

    public static int valueSize(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        switch (basicType) {
            case 1: {
                return 1 + typeInfo;
            }
            case 2: {
                return VariantUtil.handleObject(value, pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> dataStart - pos + VariantUtil.readUnsigned(value, offsetStart + size * offsetSize, offsetSize));
            }
            case 3: {
                return VariantUtil.handleArray(value, pos, (size, offsetSize, offsetStart, dataStart) -> dataStart - pos + VariantUtil.readUnsigned(value, offsetStart + size * offsetSize, offsetSize));
            }
        }
        switch (typeInfo) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: 
            case 11: 
            case 14: {
                return 5;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                return 9;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 18;
            }
            case 15: 
            case 16: {
                return 5 + VariantUtil.readUnsigned(value, pos + 1, 4);
            }
            case 20: {
                return 17;
            }
        }
        throw VariantUtil.unknownPrimitiveTypeInVariant(typeInfo);
    }

    static IllegalStateException unexpectedType(Type type) {
        return new IllegalStateException("Expect type to be " + String.valueOf((Object)type));
    }

    public static boolean getBoolean(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 1 && typeInfo != 2) {
            throw VariantUtil.unexpectedType(Type.BOOLEAN);
        }
        return typeInfo == 1;
    }

    public static long getLong(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        String exceptionMessage = "Expect type to be LONG/DATE/TIMESTAMP/TIMESTAMP_NTZ";
        if (basicType != 0) {
            throw new IllegalStateException(exceptionMessage);
        }
        switch (typeInfo) {
            case 3: {
                return VariantUtil.readLong(value, pos + 1, 1);
            }
            case 4: {
                return VariantUtil.readLong(value, pos + 1, 2);
            }
            case 5: 
            case 11: {
                return VariantUtil.readLong(value, pos + 1, 4);
            }
            case 6: 
            case 12: 
            case 13: {
                return VariantUtil.readLong(value, pos + 1, 8);
            }
        }
        throw new IllegalStateException(exceptionMessage);
    }

    public static double getDouble(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 7) {
            throw VariantUtil.unexpectedType(Type.DOUBLE);
        }
        return Double.longBitsToDouble(VariantUtil.readLong(value, pos + 1, 8));
    }

    private static void checkDecimal(BigDecimal d, int maxPrecision) {
        if (d.precision() > maxPrecision || d.scale() > maxPrecision) {
            throw VariantUtil.malformedVariant();
        }
    }

    public static BigDecimal getDecimalWithOriginalScale(byte[] value, int pos) {
        BigDecimal result;
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0) {
            throw VariantUtil.unexpectedType(Type.DECIMAL);
        }
        int scale = value[pos + 1] & 0xFF;
        switch (typeInfo) {
            case 8: {
                result = BigDecimal.valueOf(VariantUtil.readLong(value, pos + 2, 4), scale);
                VariantUtil.checkDecimal(result, 9);
                break;
            }
            case 9: {
                result = BigDecimal.valueOf(VariantUtil.readLong(value, pos + 2, 8), scale);
                VariantUtil.checkDecimal(result, 18);
                break;
            }
            case 10: {
                VariantUtil.checkIndex(pos + 17, value.length);
                byte[] bytes = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    bytes[i] = value[pos + 17 - i];
                }
                result = new BigDecimal(new BigInteger(bytes), scale);
                VariantUtil.checkDecimal(result, 38);
                break;
            }
            default: {
                throw VariantUtil.unexpectedType(Type.DECIMAL);
            }
        }
        return result;
    }

    public static BigDecimal getDecimal(byte[] value, int pos) {
        return VariantUtil.getDecimalWithOriginalScale(value, pos).stripTrailingZeros();
    }

    public static float getFloat(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 14) {
            throw VariantUtil.unexpectedType(Type.FLOAT);
        }
        return Float.intBitsToFloat((int)VariantUtil.readLong(value, pos + 1, 4));
    }

    public static byte[] getBinary(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 15) {
            throw VariantUtil.unexpectedType(Type.BINARY);
        }
        int start = pos + 1 + 4;
        int length = VariantUtil.readUnsigned(value, pos + 1, 4);
        VariantUtil.checkIndex(start + length - 1, value.length);
        return Arrays.copyOfRange(value, start, start + length);
    }

    public static String getString(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType == 1 || basicType == 0 && typeInfo == 16) {
            int length;
            int start;
            if (basicType == 1) {
                start = pos + 1;
                length = typeInfo;
            } else {
                start = pos + 1 + 4;
                length = VariantUtil.readUnsigned(value, pos + 1, 4);
            }
            VariantUtil.checkIndex(start + length - 1, value.length);
            return new String(value, start, length);
        }
        throw VariantUtil.unexpectedType(Type.STRING);
    }

    public static UUID getUuid(byte[] value, int pos) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 20) {
            throw VariantUtil.unexpectedType(Type.UUID);
        }
        int start = pos + 1;
        VariantUtil.checkIndex(start + 15, value.length);
        ByteBuffer bb = ByteBuffer.wrap(value, start, 16).order(ByteOrder.BIG_ENDIAN);
        return new UUID(bb.getLong(), bb.getLong());
    }

    public static <T> T handleObject(byte[] value, int pos, ObjectHandler<T> handler) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 2) {
            throw VariantUtil.unexpectedType(Type.OBJECT);
        }
        boolean largeSize = (typeInfo >> 4 & 1) != 0;
        int sizeBytes = largeSize ? 4 : 1;
        int size = VariantUtil.readUnsigned(value, pos + 1, sizeBytes);
        int idSize = (typeInfo >> 2 & 3) + 1;
        int offsetSize = (typeInfo & 3) + 1;
        int idStart = pos + 1 + sizeBytes;
        int offsetStart = idStart + size * idSize;
        int dataStart = offsetStart + (size + 1) * offsetSize;
        return handler.apply(size, idSize, offsetSize, idStart, offsetStart, dataStart);
    }

    public static <T> T handleArray(byte[] value, int pos, ArrayHandler<T> handler) {
        VariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 3) {
            throw VariantUtil.unexpectedType(Type.ARRAY);
        }
        boolean largeSize = (typeInfo >> 2 & 1) != 0;
        int sizeBytes = largeSize ? 4 : 1;
        int size = VariantUtil.readUnsigned(value, pos + 1, sizeBytes);
        int offsetSize = (typeInfo & 3) + 1;
        int offsetStart = pos + 1 + sizeBytes;
        int dataStart = offsetStart + (size + 1) * offsetSize;
        return handler.apply(size, offsetSize, offsetStart, dataStart);
    }

    public static String getMetadataKey(byte[] metadata, int id) {
        int nextOffset;
        VariantUtil.checkIndex(0, metadata.length);
        int offsetSize = (metadata[0] >> 6 & 3) + 1;
        int dictSize = VariantUtil.readUnsigned(metadata, 1, offsetSize);
        if (id >= dictSize) {
            throw VariantUtil.malformedVariant();
        }
        int stringStart = 1 + (dictSize + 2) * offsetSize;
        int offset = VariantUtil.readUnsigned(metadata, 1 + (id + 1) * offsetSize, offsetSize);
        if (offset > (nextOffset = VariantUtil.readUnsigned(metadata, 1 + (id + 2) * offsetSize, offsetSize))) {
            throw VariantUtil.malformedVariant();
        }
        VariantUtil.checkIndex(stringStart + nextOffset - 1, metadata.length);
        return new String(metadata, stringStart + offset, nextOffset - offset);
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        NULL,
        BOOLEAN,
        LONG,
        STRING,
        DOUBLE,
        DECIMAL,
        DATE,
        TIMESTAMP,
        TIMESTAMP_NTZ,
        FLOAT,
        BINARY,
        UUID;

    }

    public static interface ObjectHandler<T> {
        public T apply(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface ArrayHandler<T> {
        public T apply(int var1, int var2, int var3, int var4);
    }
}

