/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.protobuf.services;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.sparkproject.connect.grpc.CallOptions;
import org.sparkproject.connect.grpc.ChannelLogger;
import org.sparkproject.connect.grpc.ClientCall;
import org.sparkproject.connect.grpc.ConnectivityState;
import org.sparkproject.connect.grpc.ConnectivityStateInfo;
import org.sparkproject.connect.grpc.LoadBalancer;
import org.sparkproject.connect.grpc.Metadata;
import org.sparkproject.connect.grpc.Status;
import org.sparkproject.connect.grpc.SynchronizationContext;
import org.sparkproject.connect.grpc.health.v1.HealthCheckRequest;
import org.sparkproject.connect.grpc.health.v1.HealthCheckResponse;
import org.sparkproject.connect.grpc.health.v1.HealthGrpc;
import org.sparkproject.connect.grpc.internal.BackoffPolicy;
import org.sparkproject.connect.grpc.internal.ServiceConfigUtil;
import org.sparkproject.connect.grpc.util.ForwardingLoadBalancer;
import org.sparkproject.connect.grpc.util.ForwardingLoadBalancerHelper;
import org.sparkproject.connect.grpc.util.ForwardingSubchannel;
import org.sparkproject.connect.grpc.util.HealthProducerHelper;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.base.MoreObjects;
import org.sparkproject.guava.base.Objects;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.base.Stopwatch;
import org.sparkproject.guava.base.Supplier;

final class HealthCheckingLoadBalancerFactory
extends LoadBalancer.Factory {
    private static final Logger logger = Logger.getLogger(HealthCheckingLoadBalancerFactory.class.getName());
    private final LoadBalancer.Factory delegateFactory;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;

    public HealthCheckingLoadBalancerFactory(LoadBalancer.Factory delegateFactory, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.delegateFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)delegateFactory, (Object)"delegateFactory");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        HelperImpl wrappedHelper = new HelperImpl(helper);
        LoadBalancer delegateBalancer = this.delegateFactory.newLoadBalancer(wrappedHelper);
        return new HealthCheckingLoadBalancer(wrappedHelper, delegateBalancer);
    }

    private final class HealthCheckState
    implements LoadBalancer.SubchannelStateListener {
        private final Runnable retryTask = new Runnable(){

            @Override
            public void run() {
                HealthCheckState.this.startRpc();
            }
        };
        private final SynchronizationContext syncContext;
        private final ScheduledExecutorService timerService;
        private final HelperImpl helperImpl;
        private LoadBalancer.Subchannel subchannel;
        private ChannelLogger subchannelLogger;
        private LoadBalancer.SubchannelStateListener stateListener;
        @Nullable
        private HcStream activeRpc;
        private String serviceName;
        private BackoffPolicy backoffPolicy;
        private ConnectivityStateInfo rawState = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
        private ConnectivityStateInfo concludedState = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
        private boolean running;
        private boolean disabled;
        private SynchronizationContext.ScheduledHandle retryTimer;

        HealthCheckState(HelperImpl helperImpl, SynchronizationContext syncContext, @Nullable ScheduledExecutorService timerService, LoadBalancer.SubchannelStateListener healthListener) {
            this.helperImpl = (HelperImpl)Preconditions.checkNotNull((Object)helperImpl, (Object)"helperImpl");
            this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
            this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timerService, (Object)"timerService");
            this.stateListener = healthListener;
        }

        void setSubchannel(LoadBalancer.Subchannel subchannel) {
            this.subchannel = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)subchannel, (Object)"subchannel");
            this.subchannelLogger = (ChannelLogger)Preconditions.checkNotNull((Object)subchannel.getChannelLogger(), (Object)"subchannelLogger");
        }

        void init(LoadBalancer.SubchannelStateListener listener) {
            Preconditions.checkState((this.stateListener == null ? 1 : 0) != 0, (Object)"init() already called");
            this.stateListener = (LoadBalancer.SubchannelStateListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        }

        void setServiceName(@Nullable String newServiceName) {
            if (Objects.equal((Object)newServiceName, (Object)this.serviceName)) {
                return;
            }
            this.serviceName = newServiceName;
            String cancelMsg = this.serviceName == null ? "Health check disabled by service config" : "Switching to new service name: " + newServiceName;
            this.stopRpc(cancelMsg);
            this.adjustHealthCheck();
        }

        @Override
        public void onSubchannelState(ConnectivityStateInfo rawState) {
            if (Objects.equal((Object)((Object)this.rawState.getState()), (Object)((Object)ConnectivityState.READY)) && !Objects.equal((Object)((Object)rawState.getState()), (Object)((Object)ConnectivityState.READY))) {
                this.disabled = false;
            }
            if (Objects.equal((Object)((Object)rawState.getState()), (Object)((Object)ConnectivityState.SHUTDOWN))) {
                this.helperImpl.hcStates.remove(this);
            }
            this.rawState = rawState;
            this.adjustHealthCheck();
        }

        private boolean isRetryTimerPending() {
            return this.retryTimer != null && this.retryTimer.isPending();
        }

        private void adjustHealthCheck() {
            if (!this.disabled && this.serviceName != null && Objects.equal((Object)((Object)this.rawState.getState()), (Object)((Object)ConnectivityState.READY))) {
                this.running = true;
                if (this.activeRpc == null && !this.isRetryTimerPending()) {
                    this.startRpc();
                }
            } else {
                this.running = false;
                this.stopRpc("Client stops health check");
                this.backoffPolicy = null;
                this.gotoState(this.rawState);
            }
        }

        private void startRpc() {
            Preconditions.checkState((this.serviceName != null ? 1 : 0) != 0, (Object)"serviceName is null");
            Preconditions.checkState((this.activeRpc == null ? 1 : 0) != 0, (Object)"previous health-checking RPC has not been cleaned up");
            Preconditions.checkState((this.subchannel != null ? 1 : 0) != 0, (Object)"init() not called");
            if (!Objects.equal((Object)((Object)this.concludedState.getState()), (Object)((Object)ConnectivityState.READY))) {
                this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING: Starting health-check for \"{0}\"", this.serviceName);
                this.gotoState(ConnectivityStateInfo.forNonError(ConnectivityState.CONNECTING));
            }
            this.activeRpc = new HcStream();
            this.activeRpc.start();
        }

        private void stopRpc(String msg) {
            if (this.activeRpc != null) {
                this.activeRpc.cancel(msg);
                this.activeRpc = null;
            }
            if (this.retryTimer != null) {
                this.retryTimer.cancel();
                this.retryTimer = null;
            }
        }

        private void gotoState(ConnectivityStateInfo newState) {
            Preconditions.checkState((this.subchannel != null ? 1 : 0) != 0, (Object)"init() not called");
            if (!Objects.equal((Object)this.concludedState, (Object)newState)) {
                this.concludedState = newState;
                this.stateListener.onSubchannelState(this.concludedState);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("running", this.running).add("disabled", this.disabled).add("activeRpc", (Object)this.activeRpc).add("serviceName", (Object)this.serviceName).add("rawState", (Object)this.rawState).add("concludedState", (Object)this.concludedState).toString();
        }

        private class HcStream
        extends ClientCall.Listener<HealthCheckResponse> {
            private final ClientCall<HealthCheckRequest, HealthCheckResponse> call;
            private final String callServiceName;
            private final Stopwatch stopwatch;
            private boolean callHasResponded;

            HcStream() {
                this.stopwatch = ((Stopwatch)HealthCheckingLoadBalancerFactory.this.stopwatchSupplier.get()).start();
                this.callServiceName = HealthCheckState.this.serviceName;
                this.call = HealthCheckState.this.subchannel.asChannel().newCall(HealthGrpc.getWatchMethod(), CallOptions.DEFAULT);
            }

            void start() {
                this.call.start(this, new Metadata());
                this.call.sendMessage(HealthCheckRequest.newBuilder().setService(HealthCheckState.this.serviceName).build());
                this.call.halfClose();
                this.call.request(1);
            }

            void cancel(String msg) {
                this.call.cancel(msg, null);
            }

            @Override
            public void onMessage(final HealthCheckResponse response) {
                HealthCheckState.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (HealthCheckState.this.activeRpc == HcStream.this) {
                            HcStream.this.handleResponse(response);
                        }
                    }
                });
            }

            @Override
            public void onClose(final Status status, Metadata trailers) {
                HealthCheckState.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (HealthCheckState.this.activeRpc == HcStream.this) {
                            HealthCheckState.this.activeRpc = null;
                            HcStream.this.handleStreamClosed(status);
                        }
                    }
                });
            }

            void handleResponse(HealthCheckResponse response) {
                this.callHasResponded = true;
                HealthCheckState.this.backoffPolicy = null;
                HealthCheckResponse.ServingStatus status = response.getStatus();
                if (Objects.equal((Object)status, (Object)HealthCheckResponse.ServingStatus.SERVING)) {
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "READY: health-check responded SERVING");
                    HealthCheckState.this.gotoState(ConnectivityStateInfo.forNonError(ConnectivityState.READY));
                } else {
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "TRANSIENT_FAILURE: health-check responded {0}", status);
                    String errorDescription = "Health-check service responded " + status + " for '" + this.callServiceName + "'";
                    HealthCheckState.this.gotoState(ConnectivityStateInfo.forTransientFailure(Status.UNAVAILABLE.withDescription(errorDescription)));
                }
                this.call.request(1);
            }

            void handleStreamClosed(Status status) {
                if (Objects.equal((Object)((Object)status.getCode()), (Object)((Object)Status.Code.UNIMPLEMENTED))) {
                    HealthCheckState.this.disabled = true;
                    logger.log(Level.SEVERE, "Health-check with {0} is disabled. Server returned: {1}", new Object[]{HealthCheckState.this.subchannel.getAllAddresses(), status});
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.ERROR, "Health-check disabled: {0}", status);
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "{0} (no health-check)", HealthCheckState.this.rawState);
                    HealthCheckState.this.gotoState(HealthCheckState.this.rawState);
                    return;
                }
                long delayNanos = 0L;
                HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "TRANSIENT_FAILURE: health-check stream closed with {0}", status);
                String errorDescription = "Health-check stream unexpectedly closed with " + status + " for '" + this.callServiceName + "'";
                HealthCheckState.this.gotoState(ConnectivityStateInfo.forTransientFailure(Status.UNAVAILABLE.withDescription(errorDescription)));
                if (!this.callHasResponded) {
                    if (HealthCheckState.this.backoffPolicy == null) {
                        HealthCheckState.this.backoffPolicy = HealthCheckingLoadBalancerFactory.this.backoffPolicyProvider.get();
                    }
                    delayNanos = HealthCheckState.this.backoffPolicy.nextBackoffNanos() - this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
                }
                if (delayNanos <= 0L) {
                    HealthCheckState.this.startRpc();
                } else {
                    Preconditions.checkState((!HealthCheckState.this.isRetryTimerPending() ? 1 : 0) != 0, (Object)"Retry double scheduled");
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Will retry health-check after {0} ns", delayNanos);
                    HealthCheckState.this.retryTimer = HealthCheckState.this.syncContext.schedule(HealthCheckState.this.retryTask, delayNanos, TimeUnit.NANOSECONDS, HealthCheckState.this.timerService);
                }
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("callStarted", this.call != null).add("serviceName", (Object)this.callServiceName).add("hasResponded", this.callHasResponded).toString();
            }
        }
    }

    private static final class HealthCheckingLoadBalancer
    extends ForwardingLoadBalancer {
        final LoadBalancer delegate;
        final HelperImpl helper;

        HealthCheckingLoadBalancer(HelperImpl helper, LoadBalancer delegate) {
            this.helper = (HelperImpl)Preconditions.checkNotNull((Object)helper, (Object)"helper");
            this.delegate = (LoadBalancer)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        protected LoadBalancer delegate() {
            return this.delegate;
        }

        @Override
        public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            Map<String, ?> healthCheckingConfig = resolvedAddresses.getAttributes().get(LoadBalancer.ATTR_HEALTH_CHECKING_CONFIG);
            String serviceName = ServiceConfigUtil.getHealthCheckedServiceName(healthCheckingConfig);
            this.helper.setHealthCheckedService(serviceName);
            this.delegate.handleResolvedAddresses(resolvedAddresses);
        }

        @Override
        public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            Map<String, ?> healthCheckingConfig = resolvedAddresses.getAttributes().get(LoadBalancer.ATTR_HEALTH_CHECKING_CONFIG);
            String serviceName = ServiceConfigUtil.getHealthCheckedServiceName(healthCheckingConfig);
            this.helper.setHealthCheckedService(serviceName);
            return this.delegate.acceptResolvedAddresses(resolvedAddresses);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate()).toString();
        }
    }

    @VisibleForTesting
    static final class SubchannelImpl
    extends ForwardingSubchannel {
        final LoadBalancer.Subchannel delegate;
        final HealthCheckState hcState;

        SubchannelImpl(LoadBalancer.Subchannel delegate, HealthCheckState hcState) {
            this.delegate = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
            this.hcState = (HealthCheckState)Preconditions.checkNotNull((Object)hcState, (Object)"hcState");
        }

        @Override
        protected LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        @Override
        public void start(LoadBalancer.SubchannelStateListener listener) {
            if (this.hcState.stateListener == null) {
                this.hcState.init(listener);
                this.delegate().start(this.hcState);
            } else {
                this.delegate().start(listener);
            }
        }
    }

    private final class HelperImpl
    extends ForwardingLoadBalancerHelper {
        private final LoadBalancer.Helper delegate;
        private final SynchronizationContext syncContext;
        @Nullable
        String healthCheckedService;
        final HashSet<HealthCheckState> hcStates = new HashSet();

        HelperImpl(LoadBalancer.Helper delegate) {
            this.delegate = new HealthProducerHelper((LoadBalancer.Helper)Preconditions.checkNotNull((Object)delegate, (Object)"delegate"));
            this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)delegate.getSynchronizationContext(), (Object)"syncContext");
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return this.delegate;
        }

        @Override
        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            this.syncContext.throwIfNotInThisSynchronizationContext();
            LoadBalancer.SubchannelStateListener healthConsumerListener = args.getOption(LoadBalancer.HEALTH_CONSUMER_LISTENER_ARG_KEY);
            HealthCheckState hcState = new HealthCheckState(this, this.syncContext, this.delegate.getScheduledExecutorService(), healthConsumerListener);
            if (healthConsumerListener != null) {
                args = args.toBuilder().addOption(LoadBalancer.HEALTH_CONSUMER_LISTENER_ARG_KEY, hcState).build();
            }
            LoadBalancer.Subchannel delegate = super.createSubchannel(args);
            hcState.setSubchannel(delegate);
            this.hcStates.add(hcState);
            SubchannelImpl subchannel = new SubchannelImpl(delegate, hcState);
            if (this.healthCheckedService != null) {
                hcState.setServiceName(this.healthCheckedService);
            }
            return subchannel;
        }

        void setHealthCheckedService(@Nullable String service) {
            this.healthCheckedService = service;
            for (HealthCheckState hcState : this.hcStates) {
                hcState.setServiceName(service);
            }
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate()).toString();
        }
    }
}

