/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.parallel.ExecutionContextTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParVector;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class FileBasedWriteAheadLog$ {
    public static final FileBasedWriteAheadLog$ MODULE$ = new FileBasedWriteAheadLog$();
    private static final Regex logFileRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("log-(\\d+)-(\\d+)"));

    public Regex logFileRegex() {
        return logFileRegex;
    }

    public String timeToLogFile(long startTime, long stopTime) {
        return "log-" + startTime + "-" + stopTime;
    }

    public Option<String> getCallerName() {
        .colon.colon ignoreList = new .colon.colon((Object)"WriteAheadLog", (List)new .colon.colon((Object)"Logging", (List)new .colon.colon((Object)"java.lang", (List)new .colon.colon((Object)"scala.", (List)Nil$.MODULE$))));
        return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()), (Function1 & Serializable)x$8 -> x$8.getClassName(), ClassTag$.MODULE$.apply(String.class))), arg_0 -> FileBasedWriteAheadLog$.$anonfun$getCallerName$2$adapted((Seq)ignoreList, arg_0)).flatMap((Function1 & Serializable)x$9 -> ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.refArrayOps((Object[])x$9.split("\\.")))).flatMap((Function1 & Serializable)x$10 -> ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])x$10.split("\\$\\$"))));
    }

    public Seq<FileBasedWriteAheadLog.LogInfo> logFilesTologInfo(Seq<Path> files) {
        return (Seq)((SeqOps)files.flatMap((Function1 & Serializable)file -> {
            Option option;
            Some some;
            String string;
            Option option2 = MODULE$.logFileRegex().findFirstIn((CharSequence)file.getName());
            if (option2 instanceof Some && (string = (String)(some = (Some)option2).value()) != null && !(option = MODULE$.logFileRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                String startTimeStr = (String)((LinearSeqOps)option.get()).apply(0);
                String stopTimeStr = (String)((LinearSeqOps)option.get()).apply(1);
                long startTime = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(startTimeStr));
                long stopTime = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(stopTimeStr));
                return new Some((Object)new FileBasedWriteAheadLog.LogInfo(startTime, stopTime, file.toString()));
            }
            if (None$.MODULE$.equals(option2) ? true : option2 instanceof Some) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option2);
        })).sortBy((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.startTime()), (Ordering)Ordering.Long$.MODULE$);
    }

    public <I, O> Iterator<O> seqToParIterator(ExecutionContext executionContext, Seq<I> source, Function1<I, Iterator<O>> handler) {
        ExecutionContextTaskSupport taskSupport = new ExecutionContextTaskSupport(executionContext);
        int groupSize = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(taskSupport.parallelismLevel()), 8);
        return source.grouped(groupSize).flatMap((Function1 & Serializable)group -> {
            ParVector parallelCollection = new ParVector(group.toVector());
            parallelCollection.tasksupport_$eq((TaskSupport)taskSupport);
            return (ParVector)parallelCollection.map(handler);
        }).flatten(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getCallerName$2(Seq ignoreList$1, String c) {
        return !ignoreList$1.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)c.contains(x$1)));
    }

    private FileBasedWriteAheadLog$() {
    }

    public static final /* synthetic */ Object $anonfun$getCallerName$2$adapted(Seq ignoreList$1, String c) {
        return BoxesRunTime.boxToBoolean((boolean)FileBasedWriteAheadLog$.$anonfun$getCallerName$2(ignoreList$1, c));
    }
}

