/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import org.apache.spark.SparkException;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.common.DatasetType;
import org.apache.spark.sql.pipelines.common.DatasetType$STREAMING_TABLE$;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class GraphErrors$ {
    public static final GraphErrors$ MODULE$ = new GraphErrors$();

    public SparkException pipelineLocalDatasetNotDefinedError(String datasetName) {
        return SparkException$.MODULE$.internalError("Failed to read dataset '" + datasetName + "'. This dataset was expected to be defined and created by the pipeline.");
    }

    public SparkException unresolvedTablePath(TableIdentifier identifier) {
        return new SparkException("UNRESOLVED_TABLE_PATH", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)identifier.toString())})), null);
    }

    public AnalysisException incompatibleUserSpecifiedAndInferredSchemasError(TableIdentifier tableIdentifier, DatasetType datasetType, StructType specifiedSchema, StructType inferredSchema, Option<Throwable> cause) {
        DatasetType datasetType2 = datasetType;
        DatasetType$STREAMING_TABLE$ datasetType$STREAMING_TABLE$ = DatasetType$STREAMING_TABLE$.MODULE$;
        String streamingTableHint = !(datasetType2 != null ? !datasetType2.equals(datasetType$STREAMING_TABLE$) : datasetType$STREAMING_TABLE$ != null) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\"\n           |Streaming tables are stateful and remember data that has already been\n           |processed. If you want to recompute the table from scratch, please full refresh\n           |the table.\n              ")) : "";
        return new AnalysisException("USER_SPECIFIED_AND_INFERRED_SCHEMA_NOT_COMPATIBLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableIdentifier.unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"streamingTableHint"), (Object)streamingTableHint), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"specifiedSchema"), (Object)specifiedSchema.treeString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inferredDataSchema"), (Object)inferredSchema.treeString())})), Option$.MODULE$.apply(cause.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public Option<Throwable> incompatibleUserSpecifiedAndInferredSchemasError$default$5() {
        return None$.MODULE$;
    }

    public AnalysisException unableToInferSchemaError(TableIdentifier tableIdentifier, StructType inferredSchema, StructType incompatibleSchema, Option<Throwable> cause) {
        return new AnalysisException("UNABLE_TO_INFER_PIPELINE_TABLE_SCHEMA", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableIdentifier.unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inferredDataSchema"), (Object)inferredSchema.treeString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"incompatibleDataSchema"), (Object)incompatibleSchema.treeString())})), Option$.MODULE$.apply(cause.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public Option<Throwable> unableToInferSchemaError$default$4() {
        return None$.MODULE$;
    }

    private GraphErrors$() {
    }
}

