/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.array;

import org.apache.spark.unsafe.Platform;

public class ByteArrayMethods {
    public static final int MAX_ROUNDED_ARRAY_LENGTH = 0x7FFFFFF0;
    private static final boolean unaligned = Platform.unaligned();

    private ByteArrayMethods() {
    }

    public static long nextPowerOf2(long num) {
        long highBit = Long.highestOneBit(num);
        return highBit == num ? num : highBit << 1;
    }

    public static int roundNumberOfBytesToNearestWord(int numBytes) {
        return (int)ByteArrayMethods.roundNumberOfBytesToNearestWord((long)numBytes);
    }

    public static long roundNumberOfBytesToNearestWord(long numBytes) {
        long remainder = numBytes & 7L;
        return numBytes + (8L - remainder & 7L);
    }

    public static boolean arrayEquals(Object leftBase, long leftOffset, Object rightBase, long rightOffset, long length) {
        long i;
        if (!unaligned && leftOffset % 8L == rightOffset % 8L) {
            for (i = 0L; (leftOffset + i) % 8L != 0L && i < length; ++i) {
                if (Platform.getByte(leftBase, leftOffset + i) == Platform.getByte(rightBase, rightOffset + i)) continue;
                return false;
            }
        }
        if (unaligned || (leftOffset + i) % 8L == 0L && (rightOffset + i) % 8L == 0L) {
            while (i <= length - 8L) {
                if (Platform.getLong(leftBase, leftOffset + i) != Platform.getLong(rightBase, rightOffset + i)) {
                    return false;
                }
                i += 8L;
            }
        }
        while (i < length) {
            if (Platform.getByte(leftBase, leftOffset + i) != Platform.getByte(rightBase, rightOffset + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean contains(byte[] arr, byte[] sub) {
        if (sub.length == 0) {
            return true;
        }
        byte first = sub[0];
        for (int i = 0; i <= arr.length - sub.length; ++i) {
            if (arr[i] != first || !ByteArrayMethods.matchAt(arr, sub, i)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(byte[] array, byte[] target) {
        if (target.length > array.length) {
            return false;
        }
        return ByteArrayMethods.arrayEquals(array, Platform.BYTE_ARRAY_OFFSET, target, Platform.BYTE_ARRAY_OFFSET, target.length);
    }

    public static boolean endsWith(byte[] array, byte[] target) {
        if (target.length > array.length) {
            return false;
        }
        return ByteArrayMethods.arrayEquals(array, Platform.BYTE_ARRAY_OFFSET + array.length - target.length, target, Platform.BYTE_ARRAY_OFFSET, target.length);
    }

    public static boolean matchAt(byte[] arr, byte[] sub, int pos) {
        if (sub.length + pos > arr.length || pos < 0) {
            return false;
        }
        return ByteArrayMethods.arrayEquals(arr, Platform.BYTE_ARRAY_OFFSET + pos, sub, Platform.BYTE_ARRAY_OFFSET, sub.length);
    }
}

