/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.orc.OrcConf;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.internal.SQLConf;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class HiveOptions$
implements Serializable {
    public static final HiveOptions$ MODULE$ = new HiveOptions$();
    private static final Set<String> org$apache$spark$sql$hive$execution$HiveOptions$$lowerCasedOptionNames = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    private static final String FILE_FORMAT = MODULE$.newOption("fileFormat");
    private static final String INPUT_FORMAT = MODULE$.newOption("inputFormat");
    private static final String OUTPUT_FORMAT = MODULE$.newOption("outputFormat");
    private static final String SERDE = MODULE$.newOption("serde");
    private static final Map<String, String> delimiterOptions = (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldDelim"), (Object)"field.delim"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"escapeDelim"), (Object)"escape.delim"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collectionDelim"), (Object)"colelction.delim"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapkeyDelim"), (Object)"mapkey.delim"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lineDelim"), (Object)"line.delim")}))).map((Function1 & Serializable)x0$1 -> {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.toLowerCase(Locale.ROOT)), (Object)v);
        }
        throw new MatchError((Object)tuple2);
    });

    public Set<String> org$apache$spark$sql$hive$execution$HiveOptions$$lowerCasedOptionNames() {
        return org$apache$spark$sql$hive$execution$HiveOptions$$lowerCasedOptionNames;
    }

    private String newOption(String name) {
        this.org$apache$spark$sql$hive$execution$HiveOptions$$lowerCasedOptionNames().$plus$eq((Object)name.toLowerCase(Locale.ROOT));
        return name;
    }

    public String FILE_FORMAT() {
        return FILE_FORMAT;
    }

    public String INPUT_FORMAT() {
        return INPUT_FORMAT;
    }

    public String OUTPUT_FORMAT() {
        return OUTPUT_FORMAT;
    }

    public String SERDE() {
        return SERDE;
    }

    public Map<String, String> delimiterOptions() {
        return delimiterOptions;
    }

    public Option<Tuple2<String, String>> getHiveWriteCompression(TableDesc tableInfo, SQLConf sqlConf) {
        Map tableProps = CollectionConverters$.MODULE$.PropertiesHasAsScala(tableInfo.getProperties()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String string = tableInfo.getOutputFileFormatClassName().toLowerCase(Locale.ROOT);
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (string.endsWith("parquetoutputformat")) {
            String compressionCodec = new ParquetOptions(tableProps, sqlConf).compressionCodecClassName();
            return Option$.MODULE$.apply((Object)new Tuple2((Object)"parquet.compression", (Object)compressionCodec));
        }
        if (string.endsWith("orcoutputformat")) {
            String compressionCodec = new OrcOptions(tableProps, sqlConf).compressionCodec();
            return Option$.MODULE$.apply((Object)new Tuple2((Object)OrcConf.COMPRESS.getAttribute(), (Object)compressionCodec));
        }
        return None$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HiveOptions$.class);
    }

    private HiveOptions$() {
    }
}

