/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceAllocationConfiguration;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceAllocationConfigurationBuilder;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceAllocationConfigurationFluent;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceAllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceRequestAllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceRequestAllocationResultBuilder;
import io.fabric8.kubernetes.api.model.resource.v1.DeviceRequestAllocationResultFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeviceAllocationResultFluent<A extends DeviceAllocationResultFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<DeviceAllocationConfigurationBuilder> config = new ArrayList();
    private ArrayList<DeviceRequestAllocationResultBuilder> results = new ArrayList();

    public DeviceAllocationResultFluent() {
    }

    public DeviceAllocationResultFluent(DeviceAllocationResult instance) {
        this.copyInstance(instance);
    }

    public A addAllToConfig(Collection<DeviceAllocationConfiguration> items) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        for (DeviceAllocationConfiguration item : items) {
            DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);
            this._visitables.get((Object)"config").add(builder);
            this.config.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResults(Collection<DeviceRequestAllocationResult> items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (DeviceRequestAllocationResult item : items) {
            DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public ConfigNested<A> addNewConfig() {
        return new ConfigNested(-1, null);
    }

    public ConfigNested<A> addNewConfigLike(DeviceAllocationConfiguration item) {
        return new ConfigNested(-1, item);
    }

    public ResultsNested<A> addNewResult() {
        return new ResultsNested(-1, null);
    }

    public ResultsNested<A> addNewResultLike(DeviceRequestAllocationResult item) {
        return new ResultsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(DeviceAllocationConfiguration ... items) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        for (DeviceAllocationConfiguration item : items) {
            DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);
            this._visitables.get((Object)"config").add(builder);
            this.config.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConfig(int index, DeviceAllocationConfiguration item) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);
        if (index < 0 || index >= this.config.size()) {
            this._visitables.get((Object)"config").add(builder);
            this.config.add(builder);
        } else {
            this._visitables.get((Object)"config").add(builder);
            this.config.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResults(DeviceRequestAllocationResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        for (DeviceRequestAllocationResult item : items) {
            DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToResults(int index, DeviceRequestAllocationResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(index, builder);
        }
        return (A)((Object)this);
    }

    public List<DeviceAllocationConfiguration> buildConfig() {
        return this.config != null ? DeviceAllocationResultFluent.build(this.config) : null;
    }

    public DeviceAllocationConfiguration buildConfig(int index) {
        return this.config.get(index).build();
    }

    public DeviceAllocationConfiguration buildFirstConfig() {
        return this.config.get(0).build();
    }

    public DeviceRequestAllocationResult buildFirstResult() {
        return this.results.get(0).build();
    }

    public DeviceAllocationConfiguration buildLastConfig() {
        return this.config.get(this.config.size() - 1).build();
    }

    public DeviceRequestAllocationResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    public DeviceAllocationConfiguration buildMatchingConfig(Predicate<DeviceAllocationConfigurationBuilder> predicate) {
        for (DeviceAllocationConfigurationBuilder item : this.config) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeviceRequestAllocationResult buildMatchingResult(Predicate<DeviceRequestAllocationResultBuilder> predicate) {
        for (DeviceRequestAllocationResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeviceRequestAllocationResult buildResult(int index) {
        return this.results.get(index).build();
    }

    public List<DeviceRequestAllocationResult> buildResults() {
        return this.results != null ? DeviceAllocationResultFluent.build(this.results) : null;
    }

    protected void copyInstance(DeviceAllocationResult instance) {
        DeviceAllocationResult deviceAllocationResult = instance = instance != null ? instance : new DeviceAllocationResult();
        if (instance != null) {
            this.withConfig(instance.getConfig());
            this.withResults(instance.getResults());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigNested<A> editConfig(int index) {
        if (this.config.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "config"));
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigNested<A> editFirstConfig() {
        if (this.config.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "config"));
        }
        return this.setNewConfigLike(0, this.buildConfig(0));
    }

    public ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "results"));
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    public ConfigNested<A> editLastConfig() {
        int index = this.config.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "config"));
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public ConfigNested<A> editMatchingConfig(Predicate<DeviceAllocationConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.config.size(); ++i) {
            if (!predicate.test(this.config.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "config"));
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ResultsNested<A> editMatchingResult(Predicate<DeviceRequestAllocationResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.test(this.results.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "results"));
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceAllocationResultFluent that = (DeviceAllocationResultFluent)((Object)o);
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.results, that.results)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConfig() {
        return this.config != null && !this.config.isEmpty();
    }

    public boolean hasMatchingConfig(Predicate<DeviceAllocationConfigurationBuilder> predicate) {
        for (DeviceAllocationConfigurationBuilder item : this.config) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingResult(Predicate<DeviceRequestAllocationResultBuilder> predicate) {
        for (DeviceRequestAllocationResultBuilder item : this.results) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.config, this.results, this.additionalProperties);
    }

    public A removeAllFromConfig(Collection<DeviceAllocationConfiguration> items) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        for (DeviceAllocationConfiguration item : items) {
            DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);
            this._visitables.get((Object)"config").remove((Object)builder);
            this.config.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResults(Collection<DeviceRequestAllocationResult> items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (DeviceRequestAllocationResult item : items) {
            DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(DeviceAllocationConfiguration ... items) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        for (DeviceAllocationConfiguration item : items) {
            DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);
            this._visitables.get((Object)"config").remove((Object)builder);
            this.config.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResults(DeviceRequestAllocationResult ... items) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        for (DeviceRequestAllocationResult item : items) {
            DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);
            this._visitables.get((Object)"results").remove((Object)builder);
            this.results.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConfig(Predicate<DeviceAllocationConfigurationBuilder> predicate) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        Iterator<DeviceAllocationConfigurationBuilder> each = this.config.iterator();
        List visitables = this._visitables.get((Object)"config");
        while (each.hasNext()) {
            DeviceAllocationConfigurationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResults(Predicate<DeviceRequestAllocationResultBuilder> predicate) {
        if (this.results == null) {
            return (A)((Object)this);
        }
        Iterator<DeviceRequestAllocationResultBuilder> each = this.results.iterator();
        List visitables = this._visitables.get((Object)"results");
        while (each.hasNext()) {
            DeviceRequestAllocationResultBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConfigNested<A> setNewConfigLike(int index, DeviceAllocationConfiguration item) {
        return new ConfigNested(index, item);
    }

    public ResultsNested<A> setNewResultLike(int index, DeviceRequestAllocationResult item) {
        return new ResultsNested(index, item);
    }

    public A setToConfig(int index, DeviceAllocationConfiguration item) {
        if (this.config == null) {
            this.config = new ArrayList();
        }
        DeviceAllocationConfigurationBuilder builder = new DeviceAllocationConfigurationBuilder(item);
        if (index < 0 || index >= this.config.size()) {
            this._visitables.get((Object)"config").add(builder);
            this.config.add(builder);
        } else {
            this._visitables.get((Object)"config").add(builder);
            this.config.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResults(int index, DeviceRequestAllocationResult item) {
        if (this.results == null) {
            this.results = new ArrayList();
        }
        DeviceRequestAllocationResultBuilder builder = new DeviceRequestAllocationResultBuilder(item);
        if (index < 0 || index >= this.results.size()) {
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        } else {
            this._visitables.get((Object)"results").add(builder);
            this.results.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(this.config);
            sb.append(",");
        }
        if (this.results != null && !this.results.isEmpty()) {
            sb.append("results:");
            sb.append(this.results);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConfig(List<DeviceAllocationConfiguration> config) {
        if (this.config != null) {
            this._visitables.get((Object)"config").clear();
        }
        if (config != null) {
            this.config = new ArrayList();
            for (DeviceAllocationConfiguration item : config) {
                this.addToConfig(item);
            }
        } else {
            this.config = null;
        }
        return (A)((Object)this);
    }

    public A withConfig(DeviceAllocationConfiguration ... config) {
        if (this.config != null) {
            this.config.clear();
            this._visitables.remove((Object)"config");
        }
        if (config != null) {
            for (DeviceAllocationConfiguration item : config) {
                this.addToConfig(item);
            }
        }
        return (A)((Object)this);
    }

    public A withResults(List<DeviceRequestAllocationResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").clear();
        }
        if (results != null) {
            this.results = new ArrayList();
            for (DeviceRequestAllocationResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = null;
        }
        return (A)((Object)this);
    }

    public A withResults(DeviceRequestAllocationResult ... results) {
        if (this.results != null) {
            this.results.clear();
            this._visitables.remove((Object)"results");
        }
        if (results != null) {
            for (DeviceRequestAllocationResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)((Object)this);
    }

    public class ResultsNested<N>
    extends DeviceRequestAllocationResultFluent<ResultsNested<N>>
    implements Nested<N> {
        DeviceRequestAllocationResultBuilder builder;
        int index;

        ResultsNested(int index, DeviceRequestAllocationResult item) {
            this.index = index;
            this.builder = new DeviceRequestAllocationResultBuilder(this, item);
        }

        public N and() {
            return (N)DeviceAllocationResultFluent.this.setToResults(this.index, this.builder.build());
        }

        public N endResult() {
            return this.and();
        }
    }

    public class ConfigNested<N>
    extends DeviceAllocationConfigurationFluent<ConfigNested<N>>
    implements Nested<N> {
        DeviceAllocationConfigurationBuilder builder;
        int index;

        ConfigNested(int index, DeviceAllocationConfiguration item) {
            this.index = index;
            this.builder = new DeviceAllocationConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)DeviceAllocationResultFluent.this.setToConfig(this.index, this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }
}

