/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.io.content;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.util.BufferUtil;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.thread.AutoLock;
import org.sparkproject.jetty.util.thread.SerializedInvoker;

public class ByteBufferContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker invoker = new SerializedInvoker(ByteBufferContentSource.class);
    private final long length;
    private final Collection<ByteBuffer> byteBuffers;
    private Iterator<ByteBuffer> iterator;
    private Content.Chunk terminated;
    private Runnable demandCallback;

    public ByteBufferContentSource(ByteBuffer ... byteBuffers) {
        this(List.of(byteBuffers));
    }

    public ByteBufferContentSource(Collection<ByteBuffer> byteBuffers) {
        this(byteBuffers, 0L, -1L);
    }

    public ByteBufferContentSource(Collection<ByteBuffer> byteBuffers, long offset, long length) {
        long size = byteBuffers.stream().mapToLong(Buffer::remaining).sum();
        length = TypeUtil.checkOffsetLengthSize(offset, length, size);
        this.byteBuffers = offset == 0L && size == length ? byteBuffers : BufferUtil.slice(byteBuffers, offset, length);
        this.length = length;
    }

    public Collection<ByteBuffer> getByteBuffers() {
        return this.byteBuffers;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Content.Chunk read() {
        boolean last;
        ByteBuffer buffer;
        try (AutoLock ignored = this.lock.lock();){
            if (this.terminated != null) {
                Content.Chunk chunk = this.terminated;
                return chunk;
            }
            if (this.iterator == null) {
                this.iterator = this.byteBuffers.iterator();
            }
            if (!this.iterator.hasNext()) {
                Content.Chunk chunk = this.terminated = Content.Chunk.EOF;
                return chunk;
            }
            buffer = this.iterator.next().slice();
            boolean bl = last = !this.iterator.hasNext();
            if (last) {
                this.terminated = Content.Chunk.EOF;
            }
        }
        return Content.Chunk.from(buffer, last);
    }

    @Override
    public boolean rewind() {
        try (AutoLock ignored = this.lock.lock();){
            this.iterator = null;
            this.terminated = null;
            this.demandCallback = null;
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this.invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            this.runDemandCallback(demandCallback);
        }
    }

    private void runDemandCallback(Runnable demandCallback) {
        try {
            demandCallback.run();
        }
        catch (Throwable x) {
            this.fail(x);
        }
    }

    @Override
    public void fail(Throwable failure) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.terminated != null) {
                return;
            }
            this.terminated = Content.Chunk.from(failure);
        }
    }
}

