/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.compress.snappy;

import coursierapi.shaded.compress.IncompatibleJvmException;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

final class UnsafeUtil {
    public static final Unsafe UNSAFE;
    private static final long ADDRESS_OFFSET;

    static {
        ByteOrder order = ByteOrder.nativeOrder();
        if (!order.equals(ByteOrder.LITTLE_ENDIAN)) {
            throw new IncompatibleJvmException(String.format("Snappy requires a little endian platform (found %s)", order));
        }
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new IncompatibleJvmException("Snappy requires access to sun.misc.Unsafe");
        }
        try {
            ADDRESS_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (NoSuchFieldException e) {
            throw new IncompatibleJvmException("Snappy requires access to java.nio.Buffer raw address field");
        }
    }
}

