/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TupleUnionAggInteger;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter$;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$Sum$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

@ExpressionDescription(usage="\n    _FUNC_(child, lgNomEntries, mode) - Returns the unioned TupleSketch compact binary representation.\n      `child` should be a binary TupleSketch representation created with an integer type summary.\n      `lgNomEntries` is the log-base-2 of nominal entries for the union operation. Default is 12.\n      `mode` is the aggregation mode for numeric summaries during union (sum, min, max, alwaysone). Default is sum. ", examples="\n    Examples:\n      > SELECT tuple_sketch_estimate_integer(_FUNC_(sketch)) FROM (SELECT tuple_sketch_agg_integer(key, summary) as sketch FROM VALUES (1, 5), (2, 10) tab(key, summary) UNION ALL SELECT tuple_sketch_agg_integer(key, summary) as sketch FROM VALUES (2, 3), (3, 7) tab(key, summary));\n       3.0\n  ", group="agg_funcs", since="4.2.0")
public final class TupleUnionAggIntegerExpressionBuilder$
implements ExpressionBuilder {
    public static final TupleUnionAggIntegerExpressionBuilder$ MODULE$ = new TupleUnionAggIntegerExpressionBuilder$();
    private static final FunctionSignature defaultFunctionSignature;

    static {
        FunctionBuilderBase.$init$(MODULE$);
        defaultFunctionSignature = new FunctionSignature((Seq<InputParameter>)new .colon.colon((Object)new InputParameter("child", InputParameter$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new InputParameter("lgNomEntries", (Option<Expression>)new Some((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)12)))), (List)new .colon.colon((Object)new InputParameter("mode", (Option<Expression>)new Some((Object)Literal$.MODULE$.apply(TupleSummaryMode$Sum$.MODULE$.toString()))), (List)Nil$.MODULE$))));
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName, resolver);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    public final FunctionSignature defaultFunctionSignature() {
        return defaultFunctionSignature;
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return new Some((Object)this.defaultFunctionSignature());
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        Predef$.MODULE$.assert(expressions.size() == 3);
        return new TupleUnionAggInteger((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2));
    }

    private TupleUnionAggIntegerExpressionBuilder$() {
    }
}

