/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.variant.VariantGetExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="_FUNC_(v, path[, type]) - Extracts a sub-variant from `v` according to `path`, and then cast the sub-variant to `type`. When `type` is omitted, it is default to `variant`. Returns null if the path does not exist. Throws an exception if the cast fails.", examples="\n    Examples:\n      > SELECT _FUNC_(parse_json('{\"a\": 1}'), '$.a', 'int');\n       1\n      > SELECT _FUNC_(parse_json('{\"a\": 1}'), '$.b', 'int');\n       NULL\n      > SELECT _FUNC_(parse_json('[1, \"2\"]'), '$[1]', 'string');\n       2\n      > SELECT _FUNC_(parse_json('[1, \"2\"]'), '$[2]', 'string');\n       NULL\n      > SELECT _FUNC_(parse_json('[1, \"hello\"]'), '$[1]');\n       \"hello\"\n  ", since="4.0.0", group="variant_funcs")
@ScalaSignature(bytes="\u0006\u00059:Qa\u0001\u0003\t\u0002M1Q!\u0006\u0003\t\u0002YAQAG\u0001\u0005\u0002m\t1DV1sS\u0006tGoR3u\u000bb\u0004(/Z:tS>t')^5mI\u0016\u0014(BA\u0003\u0007\u0003\u001d1\u0018M]5b]RT!a\u0002\u0005\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0013)\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u00171\t1a]9m\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001\u0001\t\u0003)\u0005i\u0011\u0001\u0002\u0002\u001c-\u0006\u0014\u0018.\u00198u\u000f\u0016$X\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0014\u0005\u00059\u0002C\u0001\u000b\u0019\u0013\tIBAA\u0010WCJL\u0017M\u001c;HKR,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM\u001d\"bg\u0016\fa\u0001P5oSRtD#A\n)\u0015\u0005i\u0012E\t\u0013&O!R3\u0006\u0005\u0002\u001f?5\ta!\u0003\u0002!\r\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017%A\u0012\u0002\u0003o|f)\u0016(D?\"2H\u0006\t9bi\"\\F\u0006\t;za\u0016l\u0016\u0006I\u0017!\u000bb$(/Y2ug\u0002\n\u0007e];c[Y\f'/[1oi\u00022'o\\7!AZ\u0004\u0007%Y2d_J$\u0017N\\4!i>\u0004\u0003\r]1uQ\u0002d\u0003%\u00198eAQDWM\u001c\u0011dCN$\b\u0005\u001e5fAM,(-\f<be&\fg\u000e\u001e\u0011u_\u0002\u0002G/\u001f9fA:\u0002s\u000b[3oA\u0001$\u0018\u0010]3aA%\u001c\be\\7jiR,G\r\f\u0011ji\u0002J7\u000f\t3fM\u0006,H\u000e\u001e\u0011u_\u0002\u0002g/\u0019:jC:$\bM\f\u0011SKR,(O\\:!]VdG\u000eI5gAQDW\r\t9bi\"\u0004Cm\\3tA9|G\u000fI3ySN$h\u0006\t+ie><8\u000fI1oA\u0015D8-\u001a9uS>t\u0007%\u001b4!i\",\u0007eY1ti\u00022\u0017-\u001b7t]\u0005AQ\r_1na2,7/I\u0001'\u0003\r\r!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b9beN,wL[:p]\":3PI1#u\u0001\nTpJ\u0015-A\u001d\"c&Y\u0014-A\u001dJg\u000e^\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b9beN,wL[:p]\":3PI1#u\u0001\nTpJ\u0015-A\u001d\"cFY\u0014-A\u001dJg\u000e^\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QA\f'o]3`UN|g\u000eK\u0014\\c1\u0002#E\r\u0012^O%b\u0003e\n\u0013\\cu;C\u0006I\u0014tiJLgnZ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b9beN,wL[:p]\":3,\r\u0017!EI\u0012SlJ\u0015-A\u001d\"3LM/(Y\u0001:3\u000f\u001e:j]\u001e<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b9beN,wL[:p]\":3,\r\u0017!E!,G\u000e\\8#;\u001eJC\u0006I\u0014%7Fjv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!E!,G\u000e\\8#\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017%A\u0015\u0002\u000bQr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u00031\nQB^1sS\u0006tGo\u00184v]\u000e\u001c\bF\u0003\u0001\u001eC\t\"Se\n\u0015+W\u0001")
public final class VariantGetExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return VariantGetExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return VariantGetExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return VariantGetExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }

    public static Option<FunctionSignature> functionSignature() {
        return VariantGetExpressionBuilder$.MODULE$.functionSignature();
    }
}

