/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310;

import com.fasterxml.jackson.core.util.JacksonFeature;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleKeyDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.ToEmptyObjectSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeFeature;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310StringParsableDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.JavaTimeDeserializerModifier;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.MonthDayDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.OffsetTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.YearDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.YearMonthDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.DurationKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.InstantKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.LocalDateKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.LocalDateTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.LocalTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.MonthDayKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.OffsetDateTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.OffsetTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.PeriodKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.YearKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.YearMonthKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.ZoneIdKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.ZoneOffsetKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.ZonedDateTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.DurationSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.JavaTimeSerializerModifier;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.MonthDaySerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.YearMonthSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.YearSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.ZoneIdSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.key.ZonedDateTimeKeySerializer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjuster;

public final class JavaTimeModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private JacksonFeatureSet<JavaTimeFeature> _features = JacksonFeatureSet.fromDefaults((JacksonFeature[])JavaTimeFeature.values());

    public JavaTimeModule() {
        super(PackageVersion.VERSION);
    }

    public JavaTimeModule enable(JavaTimeFeature f) {
        this._features = this._features.with((JacksonFeature)f);
        return this;
    }

    public JavaTimeModule disable(JavaTimeFeature f) {
        this._features = this._features.without((JacksonFeature)f);
        return this;
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        SimpleDeserializers desers = new SimpleDeserializers();
        desers.addDeserializer(Instant.class, InstantDeserializer.INSTANT.withFeatures(this._features));
        desers.addDeserializer(OffsetDateTime.class, InstantDeserializer.OFFSET_DATE_TIME.withFeatures(this._features));
        desers.addDeserializer(ZonedDateTime.class, InstantDeserializer.ZONED_DATE_TIME.withFeatures(this._features));
        desers.addDeserializer(Duration.class, (JsonDeserializer)DurationDeserializer.INSTANCE);
        desers.addDeserializer(LocalDateTime.class, (JsonDeserializer)LocalDateTimeDeserializer.INSTANCE.withFeatures(this._features));
        desers.addDeserializer(LocalDate.class, (JsonDeserializer)LocalDateDeserializer.INSTANCE.withFeatures(this._features));
        desers.addDeserializer(LocalTime.class, (JsonDeserializer)LocalTimeDeserializer.INSTANCE);
        desers.addDeserializer(MonthDay.class, (JsonDeserializer)MonthDayDeserializer.INSTANCE);
        desers.addDeserializer(OffsetTime.class, (JsonDeserializer)OffsetTimeDeserializer.INSTANCE);
        desers.addDeserializer(Period.class, JSR310StringParsableDeserializer.PERIOD);
        desers.addDeserializer(Year.class, (JsonDeserializer)YearDeserializer.INSTANCE);
        desers.addDeserializer(YearMonth.class, (JsonDeserializer)YearMonthDeserializer.INSTANCE);
        desers.addDeserializer(ZoneId.class, JSR310StringParsableDeserializer.ZONE_ID);
        desers.addDeserializer(ZoneOffset.class, JSR310StringParsableDeserializer.ZONE_OFFSET);
        context.addDeserializers((Deserializers)desers);
        boolean oneBasedMonthEnabled = this._features.isEnabled((JacksonFeature)JavaTimeFeature.ONE_BASED_MONTHS);
        context.addBeanDeserializerModifier((BeanDeserializerModifier)new JavaTimeDeserializerModifier(oneBasedMonthEnabled));
        context.addBeanSerializerModifier((BeanSerializerModifier)new JavaTimeSerializerModifier(oneBasedMonthEnabled));
        if (this._deserializers != null) {
            context.addDeserializers((Deserializers)this._deserializers);
        }
        JavaTimeSerializers sers = new JavaTimeSerializers();
        sers.addSerializer(Duration.class, (JsonSerializer)DurationSerializer.INSTANCE);
        sers.addSerializer(Instant.class, (JsonSerializer)InstantSerializer.INSTANCE);
        sers.addSerializer(LocalDateTime.class, (JsonSerializer)LocalDateTimeSerializer.INSTANCE);
        sers.addSerializer(LocalDate.class, (JsonSerializer)LocalDateSerializer.INSTANCE);
        sers.addSerializer(LocalTime.class, (JsonSerializer)LocalTimeSerializer.INSTANCE);
        sers.addSerializer(MonthDay.class, (JsonSerializer)MonthDaySerializer.INSTANCE);
        sers.addSerializer(OffsetDateTime.class, (JsonSerializer)OffsetDateTimeSerializer.INSTANCE);
        sers.addSerializer(OffsetTime.class, (JsonSerializer)OffsetTimeSerializer.INSTANCE);
        sers.addSerializer(Period.class, (JsonSerializer)new ToStringSerializer(Period.class));
        sers.addSerializer(Year.class, (JsonSerializer)YearSerializer.INSTANCE);
        sers.addSerializer(YearMonth.class, (JsonSerializer)YearMonthSerializer.INSTANCE);
        sers.addSerializer(ZonedDateTime.class, (JsonSerializer)ZonedDateTimeSerializer.INSTANCE);
        sers.addSerializer(ZoneId.class, (JsonSerializer)new ZoneIdSerializer());
        sers.addSerializer(ZoneOffset.class, (JsonSerializer)new ToStringSerializer(ZoneOffset.class));
        context.addSerializers((Serializers)sers);
        if (this._serializers != null) {
            context.addSerializers((Serializers)this._serializers);
        }
        SimpleSerializers keySers = new SimpleSerializers();
        keySers.addSerializer(ZonedDateTime.class, (JsonSerializer)ZonedDateTimeKeySerializer.INSTANCE);
        context.addKeySerializers((Serializers)keySers);
        if (this._keySerializers != null) {
            context.addKeySerializers((Serializers)this._keySerializers);
        }
        SimpleKeyDeserializers keyDesers = new SimpleKeyDeserializers();
        keyDesers.addDeserializer(Duration.class, (KeyDeserializer)DurationKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(Instant.class, (KeyDeserializer)InstantKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(LocalDateTime.class, (KeyDeserializer)LocalDateTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(LocalDate.class, (KeyDeserializer)LocalDateKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(LocalTime.class, (KeyDeserializer)LocalTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(MonthDay.class, (KeyDeserializer)MonthDayKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(OffsetDateTime.class, (KeyDeserializer)OffsetDateTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(OffsetTime.class, (KeyDeserializer)OffsetTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(Period.class, (KeyDeserializer)PeriodKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(Year.class, (KeyDeserializer)YearKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(YearMonth.class, (KeyDeserializer)YearMonthKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(ZonedDateTime.class, (KeyDeserializer)ZonedDateTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(ZoneId.class, (KeyDeserializer)ZoneIdKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(ZoneOffset.class, (KeyDeserializer)ZoneOffsetKeyDeserializer.INSTANCE);
        context.addKeyDeserializers((KeyDeserializers)keyDesers);
        if (this._keyDeserializers != null) {
            context.addKeyDeserializers((KeyDeserializers)this._keyDeserializers);
        }
        context.addValueInstantiators((ValueInstantiators)new ValueInstantiators.Base(){

            public ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc, ValueInstantiator defaultInstantiator) {
                JavaType type = beanDesc.getType();
                Class raw = type.getRawClass();
                if (ZoneId.class.isAssignableFrom(raw) && defaultInstantiator instanceof StdValueInstantiator) {
                    AnnotatedMethod factory;
                    StdValueInstantiator inst = (StdValueInstantiator)defaultInstantiator;
                    AnnotatedClass ac = raw == ZoneId.class ? beanDesc.getClassInfo() : AnnotatedClassResolver.resolve((MapperConfig)config, (JavaType)config.constructType(ZoneId.class), (ClassIntrospector.MixInResolver)config);
                    if (!inst.canCreateFromString() && (factory = JavaTimeModule.this._findFactory(ac, "of", String.class)) != null) {
                        inst.configureFromStringCreator((AnnotatedWithParams)factory);
                    }
                }
                return defaultInstantiator;
            }
        });
    }

    protected AnnotatedMethod _findFactory(AnnotatedClass cls, String name, Class<?> ... argTypes) {
        int argCount = argTypes.length;
        for (AnnotatedMethod method : cls.getFactoryMethods()) {
            if (!name.equals(method.getName()) || method.getParameterCount() != argCount || !this._allArgTypesMatch(argTypes, method)) continue;
            return method;
        }
        return null;
    }

    private boolean _allArgTypesMatch(Class<?>[] expectedArgTypes, AnnotatedMethod method) {
        int len = expectedArgTypes.length;
        for (int i = 0; i < len; ++i) {
            Class argType = method.getParameter(i).getRawType();
            if (argType.isAssignableFrom(expectedArgTypes[i])) continue;
            return false;
        }
        return true;
    }

    class JavaTimeSerializers
    extends SimpleSerializers {
        JavaTimeSerializers() {
        }

        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
            JsonSerializer ser = super.findSerializer(config, type, beanDesc);
            if (ser == null && type.isTypeOrSubTypeOf(TemporalAdjuster.class) && type.getRawClass().isSynthetic()) {
                return new ToEmptyObjectSerializer(type);
            }
            return ser;
        }
    }
}

