/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ClusterTrustBundleProjection;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterTrustBundleProjectionFluent<A extends ClusterTrustBundleProjectionFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private LabelSelectorBuilder labelSelector;
    private String name;
    private Boolean optional;
    private String path;
    private String signerName;

    public ClusterTrustBundleProjectionFluent() {
    }

    public ClusterTrustBundleProjectionFluent(ClusterTrustBundleProjection instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    protected void copyInstance(ClusterTrustBundleProjection instance) {
        ClusterTrustBundleProjection clusterTrustBundleProjection = instance = instance != null ? instance : new ClusterTrustBundleProjection();
        if (instance != null) {
            this.withLabelSelector(instance.getLabelSelector());
            this.withName(instance.getName());
            this.withOptional(instance.getOptional());
            this.withPath(instance.getPath());
            this.withSignerName(instance.getSignerName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(null));
    }

    public LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterTrustBundleProjectionFluent that = (ClusterTrustBundleProjectionFluent)((Object)o);
        if (!Objects.equals((Object)this.labelSelector, (Object)that.labelSelector)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.optional, that.optional)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.signerName, that.signerName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public String getPath() {
        return this.path;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasOptional() {
        return this.optional != null;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public boolean hasSignerName() {
        return this.signerName != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.labelSelector, this.name, this.optional, this.path, this.signerName, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append((Object)this.labelSelector);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.optional != null) {
            sb.append("optional:");
            sb.append(this.optional);
            sb.append(",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path);
            sb.append(",");
        }
        if (this.signerName != null) {
            sb.append("signerName:");
            sb.append(this.signerName);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.remove((Object)"labelSelector");
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get((Object)"labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get((Object)"labelSelector").remove((Object)this.labelSelector);
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNested(null);
    }

    public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNested(item);
    }

    public A withOptional() {
        return this.withOptional(true);
    }

    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)((Object)this);
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public A withSignerName(String signerName) {
        this.signerName = signerName;
        return (A)((Object)this);
    }

    public class LabelSelectorNested<N>
    extends LabelSelectorFluent<LabelSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        public N and() {
            return (N)ClusterTrustBundleProjectionFluent.this.withLabelSelector(this.builder.build());
        }

        public N endLabelSelector() {
            return this.and();
        }
    }
}

