/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointAddressBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddressFluent;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.EndpointPortFluent;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EndpointSubsetFluent<A extends EndpointSubsetFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<EndpointAddressBuilder> addresses = new ArrayList();
    private ArrayList<EndpointAddressBuilder> notReadyAddresses = new ArrayList();
    private ArrayList<EndpointPortBuilder> ports = new ArrayList();

    public EndpointSubsetFluent() {
    }

    public EndpointSubsetFluent(EndpointSubset instance) {
        this.copyInstance(instance);
    }

    public A addAllToAddresses(Collection<EndpointAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToNotReadyAddresses(Collection<EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get((Object)"notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(EndpointAddress item) {
        return new AddressesNested(-1, item);
    }

    public NotReadyAddressesNested<A> addNewNotReadyAddress() {
        return new NotReadyAddressesNested(-1, null);
    }

    public NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item) {
        return new NotReadyAddressesNested(-1, item);
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public A addNewPort(String appProtocol, String name, Integer port, String protocol) {
        return this.addToPorts(new EndpointPort(appProtocol, name, port, protocol));
    }

    public PortsNested<A> addNewPortLike(EndpointPort item) {
        return new PortsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(EndpointAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(int index, EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToNotReadyAddresses(EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get((Object)"notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToNotReadyAddresses(int index, EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this._visitables.get((Object)"notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        } else {
            this._visitables.get((Object)"notReadyAddresses").add(builder);
            this.notReadyAddresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(index, builder);
        }
        return (A)((Object)this);
    }

    public EndpointAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public List<EndpointAddress> buildAddresses() {
        return this.addresses != null ? EndpointSubsetFluent.build(this.addresses) : null;
    }

    public EndpointAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public EndpointAddress buildFirstNotReadyAddress() {
        return this.notReadyAddresses.get(0).build();
    }

    public EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public EndpointAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public EndpointAddress buildLastNotReadyAddress() {
        return this.notReadyAddresses.get(this.notReadyAddresses.size() - 1).build();
    }

    public EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public EndpointAddress buildMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public EndpointAddress buildMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public EndpointAddress buildNotReadyAddress(int index) {
        return this.notReadyAddresses.get(index).build();
    }

    public List<EndpointAddress> buildNotReadyAddresses() {
        return this.notReadyAddresses != null ? EndpointSubsetFluent.build(this.notReadyAddresses) : null;
    }

    public EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public List<EndpointPort> buildPorts() {
        return this.ports != null ? EndpointSubsetFluent.build(this.ports) : null;
    }

    protected void copyInstance(EndpointSubset instance) {
        EndpointSubset endpointSubset = instance = instance != null ? instance : new EndpointSubset();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withNotReadyAddresses(instance.getNotReadyAddresses());
            this.withPorts(instance.getPorts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public NotReadyAddressesNested<A> editFirstNotReadyAddress() {
        if (this.notReadyAddresses.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "notReadyAddresses"));
        }
        return this.setNewNotReadyAddressLike(0, this.buildNotReadyAddress(0));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "ports"));
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public NotReadyAddressesNested<A> editLastNotReadyAddress() {
        int index = this.notReadyAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "notReadyAddresses"));
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "ports"));
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public NotReadyAddressesNested<A> editMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.notReadyAddresses.size(); ++i) {
            if (!predicate.test(this.notReadyAddresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "notReadyAddresses"));
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "ports"));
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public NotReadyAddressesNested<A> editNotReadyAddress(int index) {
        if (this.notReadyAddresses.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "notReadyAddresses"));
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "ports"));
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSubsetFluent that = (EndpointSubsetFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.notReadyAddresses, that.notReadyAddresses)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public boolean hasMatchingAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingNotReadyAddress(Predicate<EndpointAddressBuilder> predicate) {
        for (EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNotReadyAddresses() {
        return this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty();
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.notReadyAddresses, this.ports, this.additionalProperties);
    }

    public A removeAllFromAddresses(Collection<EndpointAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNotReadyAddresses(Collection<EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            return (A)((Object)this);
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get((Object)"notReadyAddresses").remove((Object)builder);
            this.notReadyAddresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(EndpointAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromNotReadyAddresses(EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            return (A)((Object)this);
        }
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.get((Object)"notReadyAddresses").remove((Object)builder);
            this.notReadyAddresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(EndpointPort ... items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<EndpointAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<EndpointAddressBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromNotReadyAddresses(Predicate<EndpointAddressBuilder> predicate) {
        if (this.notReadyAddresses == null) {
            return (A)((Object)this);
        }
        Iterator<EndpointAddressBuilder> each = this.notReadyAddresses.iterator();
        List visitables = this._visitables.get((Object)"notReadyAddresses");
        while (each.hasNext()) {
            EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        Iterator<EndpointPortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> setNewAddressLike(int index, EndpointAddress item) {
        return new AddressesNested(index, item);
    }

    public NotReadyAddressesNested<A> setNewNotReadyAddressLike(int index, EndpointAddress item) {
        return new NotReadyAddressesNested(index, item);
    }

    public PortsNested<A> setNewPortLike(int index, EndpointPort item) {
        return new PortsNested(index, item);
    }

    public A setToAddresses(int index, EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToNotReadyAddresses(int index, EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this._visitables.get((Object)"notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        } else {
            this._visitables.get((Object)"notReadyAddresses").add(builder);
            this.notReadyAddresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
            sb.append(",");
        }
        if (this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty()) {
            sb.append("notReadyAddresses:");
            sb.append(this.notReadyAddresses);
            sb.append(",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddresses(List<EndpointAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(EndpointAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this._visitables.get((Object)"notReadyAddresses").clear();
        }
        if (notReadyAddresses != null) {
            this.notReadyAddresses = new ArrayList();
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        } else {
            this.notReadyAddresses = null;
        }
        return (A)((Object)this);
    }

    public A withNotReadyAddresses(EndpointAddress ... notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this.notReadyAddresses.clear();
            this._visitables.remove((Object)"notReadyAddresses");
        }
        if (notReadyAddresses != null) {
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public A withPorts(List<EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get((Object)"ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)((Object)this);
    }

    public A withPorts(EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove((Object)"ports");
        }
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public class PortsNested<N>
    extends EndpointPortFluent<PortsNested<N>>
    implements Nested<N> {
        EndpointPortBuilder builder;
        int index;

        PortsNested(int index, EndpointPort item) {
            this.index = index;
            this.builder = new EndpointPortBuilder(this, item);
        }

        public N and() {
            return (N)EndpointSubsetFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class NotReadyAddressesNested<N>
    extends EndpointAddressFluent<NotReadyAddressesNested<N>>
    implements Nested<N> {
        EndpointAddressBuilder builder;
        int index;

        NotReadyAddressesNested(int index, EndpointAddress item) {
            this.index = index;
            this.builder = new EndpointAddressBuilder(this, item);
        }

        public N and() {
            return (N)EndpointSubsetFluent.this.setToNotReadyAddresses(this.index, this.builder.build());
        }

        public N endNotReadyAddress() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends EndpointAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        EndpointAddressBuilder builder;
        int index;

        AddressesNested(int index, EndpointAddress item) {
            this.index = index;
            this.builder = new EndpointAddressBuilder(this, item);
        }

        public N and() {
            return (N)EndpointSubsetFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

