/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.DataEncoder;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaIdRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.Platform;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055c!\u0002\u0010 \u0003\u0003q\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011u\u0002!\u0011!Q\u0001\nyBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq!\u0013\u0001C\u0002\u0013\u0005!\n\u0003\u0004L\u0001\u0001\u0006IA\u0010\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0011\u00191\u0006\u0001)A\u0005\u001d\"9q\u000b\u0001b\u0001\n\u0003i\u0005B\u0002-\u0001A\u0003%a\nC\u0004Z\u0001\t\u0007I\u0011\u0001.\t\ry\u0003\u0001\u0015!\u0003\\\u0011\u001dy\u0006A1A\u0005\u0002iCa\u0001\u0019\u0001!\u0002\u0013Y\u0006bB1\u0001\u0005\u0004%\tA\u0019\u0005\u0007M\u0002\u0001\u000b\u0011B2\t\u000f\u001d\u0004!\u0019!C\u0001E\"1\u0001\u000e\u0001Q\u0001\n\rDq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004o\u0001\u0001\u0006Ia\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0001k\u0011\u0019\u0001\b\u0001)A\u0005W\"9\u0011\u000f\u0001b\u0001\n\u0003Q\u0007B\u0002:\u0001A\u0003%1\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\t\u0002\u0013%>\u001c7n\u001d#C\t\u0006$\u0018-\u00128d_\u0012,'O\u0003\u0002!C\u0005)1\u000f^1uK*\u0011!eI\u0001\ngR\u0014X-Y7j]\u001eT!\u0001J\u0013\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011c\u0001\u00010kA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"AN\u001c\u000e\u0003}I!\u0001O\u0010\u0003\u0017\u0011\u000bG/Y#oG>$WM]\u0001\u0014W\u0016L8\u000b^1uK\u0016s7m\u001c3feN\u0003Xm\u0019\t\u0003mmJ!\u0001P\u0010\u0003'-+\u0017p\u0015;bi\u0016,enY8eKJ\u001c\u0006/Z2\u0002\u0017Y\fG.^3TG\",W.\u0019\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u0016\nQ\u0001^=qKNL!a\u0011!\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0004=S:LGO\u0010\u000b\u0004\r\u001eC\u0005C\u0001\u001c\u0001\u0011\u0015I4\u00011\u0001;\u0011\u0015i4\u00011\u0001?\u0003%YW-_*dQ\u0016l\u0017-F\u0001?\u0003)YW-_*dQ\u0016l\u0017\rI\u0001\re\u0016,8/\u001a3LKf\u0014vn^\u000b\u0002\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002TK\u0005A1-\u0019;bYf\u001cH/\u0003\u0002V!\nIQK\\:bM\u0016\u0014vn^\u0001\u000ee\u0016,8/\u001a3LKf\u0014vn\u001e\u0011\u0002\u001dI,Wo]3e-\u0006dW/\u001a*po\u0006y!/Z;tK\u00124\u0016\r\\;f%><\b%\u0001\tgY>\fGO\u00127ja\nKG/T1tWV\t1\f\u0005\u000219&\u0011Q,\r\u0002\u0004\u0013:$\u0018!\u00054m_\u0006$h\t\\5q\u0005&$X*Y:lA\u0005\u0001b\r\\8biNKwM\u001c\"ji6\u000b7o[\u0001\u0012M2|\u0017\r^*jO:\u0014\u0015\u000e^'bg.\u0004\u0013!\u00053pk\ndWM\u00127ja\nKG/T1tWV\t1\r\u0005\u00021I&\u0011Q-\r\u0002\u0005\u0019>tw-\u0001\ne_V\u0014G.\u001a$mSB\u0014\u0015\u000e^'bg.\u0004\u0013!\u00053pk\ndWmU5h]\nKG/T1tW\u0006\u0011Bm\\;cY\u0016\u001c\u0016n\u001a8CSRl\u0015m]6!\u0003EqWmZ1uSZ,g+\u00197NCJ\\WM]\u000b\u0002WB\u0011\u0001\u0007\\\u0005\u0003[F\u0012AAQ=uK\u0006\u0011b.Z4bi&4XMV1m\u001b\u0006\u00148.\u001a:!\u0003E\u0001xn]5uSZ,g+\u00197NCJ\\WM]\u0001\u0013a>\u001c\u0018\u000e^5wKZ\u000bG.T1sW\u0016\u0014\b%A\u0007ok2dg+\u00197NCJ\\WM]\u0001\u000f]VdGNV1m\u001b\u0006\u00148.\u001a:!\u0003])gnY8eK^KG\u000f[*uCR,7k\u00195f[\u0006LE\r\u0006\u0002vqB\u0019\u0001G^6\n\u0005]\f$!B!se\u0006L\b\"B=\u0019\u0001\u0004Q\u0018aC:dQ\u0016l\u0017-\u00133S_^\u0004\"AN>\n\u0005q|\"\u0001E*uCR,7k\u00195f[\u0006LEMU8x\u0003Y!WmY8eKN#\u0018\r^3TG\",W.Y%e%><HC\u0001>\u0000\u0011\u0019\t\t!\u0007a\u0001k\u0006)!-\u001f;fg\u00061SO\\:vaB|'\u000f^3e\u001fB,'/\u0019;j_:4uN]&fsN#\u0018\r^3F]\u000e|G-\u001a:\u0015\t\u0005\u001d\u0011q\u0004\t\u0005\u0003\u0013\tIB\u0004\u0003\u0002\f\u0005Ua\u0002BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005EQ&\u0001\u0004=e>|GOP\u0005\u0002e%\u0019\u0011qC\u0019\u0002\u000fA\f7m[1hK&!\u00111DA\u000f\u0005u)fn];qa>\u0014H/\u001a3Pa\u0016\u0014\u0018\r^5p]\u0016C8-\u001a9uS>t'bAA\fc!9\u0011\u0011\u0005\u000eA\u0002\u0005\r\u0012!C8qKJ\fG/[8o!\u0011\t)#!\f\u000f\t\u0005\u001d\u0012\u0011\u0006\t\u0004\u0003\u001b\t\u0014bAA\u0016c\u00051\u0001K]3eK\u001aLA!a\f\u00022\t11\u000b\u001e:j]\u001eT1!a\u000b2\u0003=)gnY8eKVs7/\u00194f%><HcA;\u00028!1\u0011\u0011H\u000eA\u00029\u000b1A]8x\u0003E!WmY8eKR{WK\\:bM\u0016\u0014vn\u001e\u000b\u0006\u001d\u0006}\u0012\u0011\t\u0005\u0007\u0003\u0003a\u0002\u0019A;\t\r\u0005\rC\u00041\u0001\\\u0003%qW/\u001c$jK2$7\u000fF\u0003O\u0003\u000f\nI\u0005\u0003\u0004\u0002\u0002u\u0001\r!\u001e\u0005\u0007\u0003\u0017j\u0002\u0019\u0001(\u0002\u0013I,Wo]3e%><\b")
public abstract class RocksDBDataEncoder
implements DataEncoder {
    private final KeyStateEncoderSpec keyStateEncoderSpec;
    private final StructType keySchema;
    private final UnsafeRow reusedKeyRow;
    private final UnsafeRow reusedValueRow;
    private final int floatFlipBitMask;
    private final int floatSignBitMask;
    private final long doubleFlipBitMask;
    private final long doubleSignBitMask;
    private final byte negativeValMarker;
    private final byte positiveValMarker;
    private final byte nullValMarker;

    public StructType keySchema() {
        return this.keySchema;
    }

    public UnsafeRow reusedKeyRow() {
        return this.reusedKeyRow;
    }

    public UnsafeRow reusedValueRow() {
        return this.reusedValueRow;
    }

    public int floatFlipBitMask() {
        return this.floatFlipBitMask;
    }

    public int floatSignBitMask() {
        return this.floatSignBitMask;
    }

    public long doubleFlipBitMask() {
        return this.doubleFlipBitMask;
    }

    public long doubleSignBitMask() {
        return this.doubleSignBitMask;
    }

    public byte negativeValMarker() {
        return this.negativeValMarker;
    }

    public byte positiveValMarker() {
        return this.positiveValMarker;
    }

    public byte nullValMarker() {
        return this.nullValMarker;
    }

    public byte[] encodeWithStateSchemaId(StateSchemaIdRow schemaIdRow) {
        byte[] data = schemaIdRow.bytes();
        short schemaId = schemaIdRow.schemaId();
        byte[] result = new byte[RocksDBStateStoreProvider$.MODULE$.SCHEMA_ID_PREFIX_BYTES() + data.length];
        int offset = Platform.BYTE_ARRAY_OFFSET;
        Platform.putShort((Object)result, (long)offset, (short)schemaId);
        Platform.copyMemory((Object)data, (long)Platform.BYTE_ARRAY_OFFSET, (Object)result, (long)(offset += RocksDBStateStoreProvider$.MODULE$.SCHEMA_ID_PREFIX_BYTES()), (long)data.length);
        return result;
    }

    public StateSchemaIdRow decodeStateSchemaIdRow(byte[] bytes) {
        int offset = Platform.BYTE_ARRAY_OFFSET;
        short schemaId = Platform.getShort((Object)bytes, (long)offset);
        int dataLength = bytes.length - RocksDBStateStoreProvider$.MODULE$.SCHEMA_ID_PREFIX_BYTES();
        byte[] data = new byte[dataLength];
        Platform.copyMemory((Object)bytes, (long)(offset += RocksDBStateStoreProvider$.MODULE$.SCHEMA_ID_PREFIX_BYTES()), (Object)data, (long)Platform.BYTE_ARRAY_OFFSET, (long)dataLength);
        return new StateSchemaIdRow(schemaId, data);
    }

    public UnsupportedOperationException unsupportedOperationForKeyStateEncoder(String operation) {
        return new UnsupportedOperationException("Method " + operation + " not supported for encoder spec type " + this.keyStateEncoderSpec.getClass().getSimpleName());
    }

    public byte[] encodeUnsafeRow(UnsafeRow row) {
        byte[] bytesToEncode = row.getBytes();
        byte[] encodedBytes = new byte[bytesToEncode.length + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()];
        Platform.putByte((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (byte)RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_VERSION());
        Platform.copyMemory((Object)bytesToEncode, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()), (long)bytesToEncode.length);
        return encodedBytes;
    }

    public UnsafeRow decodeToUnsafeRow(byte[] bytes, int numFields) {
        if (bytes != null) {
            UnsafeRow row = new UnsafeRow(numFields);
            return this.decodeToUnsafeRow(bytes, row);
        }
        return null;
    }

    public UnsafeRow decodeToUnsafeRow(byte[] bytes, UnsafeRow reusedRow) {
        if (bytes != null) {
            reusedRow.pointTo((Object)bytes, (long)(Platform.BYTE_ARRAY_OFFSET + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()), bytes.length - RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES());
            return reusedRow;
        }
        return null;
    }

    public RocksDBDataEncoder(KeyStateEncoderSpec keyStateEncoderSpec, StructType valueSchema) {
        this.keyStateEncoderSpec = keyStateEncoderSpec;
        this.keySchema = keyStateEncoderSpec.keySchema();
        this.reusedKeyRow = new UnsafeRow(keyStateEncoderSpec.keySchema().length());
        this.reusedValueRow = new UnsafeRow(valueSchema.length());
        this.floatFlipBitMask = -1;
        this.floatSignBitMask = Integer.MIN_VALUE;
        this.doubleFlipBitMask = -1L;
        this.doubleSignBitMask = Long.MIN_VALUE;
        this.negativeValMarker = (byte)0;
        this.positiveValMarker = (byte)1;
        this.nullValMarker = (byte)2;
    }
}

