/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTaint;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTaintBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTaintFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTaintRuleSpec;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTaintSelector;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTaintSelectorBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTaintSelectorFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeviceTaintRuleSpecFluent<A extends DeviceTaintRuleSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private DeviceTaintSelectorBuilder deviceSelector;
    private DeviceTaintBuilder taint;

    public DeviceTaintRuleSpecFluent() {
    }

    public DeviceTaintRuleSpecFluent(DeviceTaintRuleSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public DeviceTaintSelector buildDeviceSelector() {
        return this.deviceSelector != null ? this.deviceSelector.build() : null;
    }

    public DeviceTaint buildTaint() {
        return this.taint != null ? this.taint.build() : null;
    }

    protected void copyInstance(DeviceTaintRuleSpec instance) {
        DeviceTaintRuleSpec deviceTaintRuleSpec = instance = instance != null ? instance : new DeviceTaintRuleSpec();
        if (instance != null) {
            this.withDeviceSelector(instance.getDeviceSelector());
            this.withTaint(instance.getTaint());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DeviceSelectorNested<A> editDeviceSelector() {
        return this.withNewDeviceSelectorLike(Optional.ofNullable(this.buildDeviceSelector()).orElse(null));
    }

    public DeviceSelectorNested<A> editOrNewDeviceSelector() {
        return this.withNewDeviceSelectorLike(Optional.ofNullable(this.buildDeviceSelector()).orElse(new DeviceTaintSelectorBuilder().build()));
    }

    public DeviceSelectorNested<A> editOrNewDeviceSelectorLike(DeviceTaintSelector item) {
        return this.withNewDeviceSelectorLike(Optional.ofNullable(this.buildDeviceSelector()).orElse(item));
    }

    public TaintNested<A> editOrNewTaint() {
        return this.withNewTaintLike(Optional.ofNullable(this.buildTaint()).orElse(new DeviceTaintBuilder().build()));
    }

    public TaintNested<A> editOrNewTaintLike(DeviceTaint item) {
        return this.withNewTaintLike(Optional.ofNullable(this.buildTaint()).orElse(item));
    }

    public TaintNested<A> editTaint() {
        return this.withNewTaintLike(Optional.ofNullable(this.buildTaint()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceTaintRuleSpecFluent that = (DeviceTaintRuleSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.deviceSelector, (Object)that.deviceSelector)) {
            return false;
        }
        if (!Objects.equals((Object)this.taint, (Object)that.taint)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDeviceSelector() {
        return this.deviceSelector != null;
    }

    public boolean hasTaint() {
        return this.taint != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceSelector, this.taint, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deviceSelector != null) {
            sb.append("deviceSelector:");
            sb.append((Object)this.deviceSelector);
            sb.append(",");
        }
        if (this.taint != null) {
            sb.append("taint:");
            sb.append((Object)this.taint);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDeviceSelector(DeviceTaintSelector deviceSelector) {
        this._visitables.remove((Object)"deviceSelector");
        if (deviceSelector != null) {
            this.deviceSelector = new DeviceTaintSelectorBuilder(deviceSelector);
            this._visitables.get((Object)"deviceSelector").add(this.deviceSelector);
        } else {
            this.deviceSelector = null;
            this._visitables.get((Object)"deviceSelector").remove((Object)this.deviceSelector);
        }
        return (A)((Object)this);
    }

    public DeviceSelectorNested<A> withNewDeviceSelector() {
        return new DeviceSelectorNested(null);
    }

    public DeviceSelectorNested<A> withNewDeviceSelectorLike(DeviceTaintSelector item) {
        return new DeviceSelectorNested(item);
    }

    public TaintNested<A> withNewTaint() {
        return new TaintNested(null);
    }

    public A withNewTaint(String effect, String key, String timeAdded, String value) {
        return this.withTaint(new DeviceTaint(effect, key, timeAdded, value));
    }

    public TaintNested<A> withNewTaintLike(DeviceTaint item) {
        return new TaintNested(item);
    }

    public A withTaint(DeviceTaint taint) {
        this._visitables.remove((Object)"taint");
        if (taint != null) {
            this.taint = new DeviceTaintBuilder(taint);
            this._visitables.get((Object)"taint").add(this.taint);
        } else {
            this.taint = null;
            this._visitables.get((Object)"taint").remove((Object)this.taint);
        }
        return (A)((Object)this);
    }

    public class TaintNested<N>
    extends DeviceTaintFluent<TaintNested<N>>
    implements Nested<N> {
        DeviceTaintBuilder builder;

        TaintNested(DeviceTaint item) {
            this.builder = new DeviceTaintBuilder(this, item);
        }

        public N and() {
            return (N)DeviceTaintRuleSpecFluent.this.withTaint(this.builder.build());
        }

        public N endTaint() {
            return this.and();
        }
    }

    public class DeviceSelectorNested<N>
    extends DeviceTaintSelectorFluent<DeviceSelectorNested<N>>
    implements Nested<N> {
        DeviceTaintSelectorBuilder builder;

        DeviceSelectorNested(DeviceTaintSelector item) {
            this.builder = new DeviceTaintSelectorBuilder(this, item);
        }

        public N and() {
            return (N)DeviceTaintRuleSpecFluent.this.withDeviceSelector(this.builder.build());
        }

        public N endDeviceSelector() {
            return this.and();
        }
    }
}

